// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: 
// Date: 
// Auth: 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "tinman.inc"
#include "light_models.inc"
#include "slippers.inc"
#include "oz_sign.inc"
#include "em_lamp.inc"
#include "paper.inc"


global_settings { assumed_gamma 1.0 }

background { color rgb <0, 0, 0> }



//normal camera
camera {
	location <1.4, 1, -10>
	look_at <0.144, 1, 5>
}   
                        

//ps cam  for placement of lettering and Tinman
    
//camera {
//	location <1.4, 1, -5>
//	look_at <20, 1, -5>
//}             



//topdown camera for placement of objects
//camera {
//	location <0.5, 15.073, 6.897>
//	look_at <1.144, -0.076, 6.000>
//}       




//**********************ground and buildings************************
//Yellow Brock Road
#declare ybr =

height_field
{
  png "ybr.png" 
 
  texture { pigment{ rgb <0.85, 0.85, 0.10>}  finish {
    metallic
    ambient 0.07
    diffuse 0.7
    roughness 1
}}
  scale <30, 0.5, 30>
  translate <-13,-2.95,-10>
  normal { bumps 1 scale 0.02 }
  translate y*1.45}
  
//Same HF rotated 90 degrees
height_field
{
  png "ybr2.png" 
  smooth
  texture { pigment{ rgb <0.85, 0.85, 0.10>}  finish {
    metallic
    ambient 0.07
    diffuse 0.7
    roughness 1
}}
  scale <30, 0.5, 30>
  translate <-13,-2.95,-10>
  normal { bumps 1 scale 0.02 }  
translate y*1.45

}





// Advertisement building  (Flying Monkeys)
box
{
  <-7, -1, -8>  // one corner position <X1 Y1 Z1>
  < 1,  4,  1>  // other corner position <X2 Y2 Z2>
  translate <-2,0,-2>
          texture{ pigment {image_map
                {   png "signwall2.png" // the file to read (iff/gif/tga/png/sys)
                        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                        interpolate 2}
                        scale 10
                        rotate y*-90
                        translate <0.001, -1, 0.0001>}}finish {ambient 0.03}
                        } // image_map
 
//support for Ad lights
box
{
  <0, 0, 0>  // one corner position <X1 Y1 Z1>
  < 0.06,  0.2,  4.5>  // other corner position <X2 Y2 Z2>
texture {
    pigment { rgb <0.55, 0.5, 0.45> }
    finish {
        metallic
        ambient 0.1
        diffuse 0.65
        specular 0.35
        roughness 0.01
        reflection 0.05
        brilliance 0.5
    }normal {bumps 1 scale 0.2}
}
translate <-1.02,1.9,-6.2>}





// Pawn Shop

difference{
box
{
  <-7, -1, -8>  
  < 1,  4,  1>  
  translate <10,0,-2>
  texture{ pigment {rgb <0,1,0>}
                
                        normal{
                                bump_map { 
                                        png "bricks2.png" // the file to read (iff/gif/tga/png/sys)
                                        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                        interpolate 2 
                                        bump_size 1}
                                        scale 10
                                        rotate y*90}}
                                        finish {ambient 0.01}} // image_map  box


//display window

box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  translate <3.3,0.5,-5.7>
  pigment {rgb <0.0, 0.04, 0>}
  normal {
        waves 0.75
        frequency 10
    }finish { ambient 3}}

//doorway    
box
{
  <-0.04, -1.4, -1>  // one corner position <X1 Y1 Z1>
  < 0.3,  1,  0.3>  // other corner position <X2 Y2 Z2>
  translate <3.02,0.5,-3>
  pigment {rgb <0,1,0>}
  normal {
        waves 0.75
        frequency 10
    }finish { ambient 0.01}}}    
 
//Glass for display window

#declare display =
box
{
  <-0.02, -1, -1>  // one corner position <X1 Y1 Z1>
  < 0,  1,  1>  // other corner position <X2 Y2 Z2>
  translate <3.2,0.5,-5.7>
  texture {
    pigment { rgbf <0.98, 1.0, 0.99, 0.75> }
    finish {
        ambient 0.1
        diffuse 0.1
        reflection .25
        //ior 1.5
        specular 1
        roughness .001
    }
} }//end display
                      

//pawn shop door
#declare psdoor =                        
box
{
  <-0.04, -1.4, -1>  // one corner position <X1 Y1 Z1>
  < 0,  1,  0.3>  // other corner position <X2 Y2 Z2>
  translate <3.14,0.5,-3>
  pigment {
    wood
    turbulence 0.31
    scale 0.2
    color_map {
        [0.8 rgb < 0.15, 0.7, 0.0>]
        [0.8 rgb < 0.1, 0.5, 0.0>]
        [1.0 rgb < 0.05, 0.4, 0.0>]
    }
}
  normal {
        waves 0.75
        frequency 10
    }finish { ambient 0.3}}
                        
//end pawnshop


//Strip Club
difference{
box
{
  <-8, -1, -2>  // one corner position <X1 Y1 Z1>
  < 1,  4,  1>  // other corner position <X2 Y2 Z2>
  translate <8,0,10> 
  texture{ pigment {color red 0.137255 green 0.556863 blue 0.137255}
                
                        normal{
                                bump_map { 
                                        png "bricks2.png" // the file to read (iff/gif/tga/png/sys)
                                        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                                        interpolate 2 
                                        bump_size 1}
                                        scale 20
                                        //rotate y*90
                                        }}
                                        finish {ambient 0.01}
}


//Doorways
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < -0.5,  -0.1,  -0.5>  // other corner position <X2 Y2 Z2>
  scale 2
  translate < 3.5,1.2,9.99>
}
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < -0.5,  -0.1,  -0.5>  // other corner position <X2 Y2 Z2>
  scale 2
  translate < 4.6,1.2,9.99>
}
}

//Glass doors
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < -0.5,  -0.1,  -0.95>  // other corner position <X2 Y2 Z2>
  texture { 
    NBglass
    pigment { rgbf <0.1, 0.7, 0.8, 0.8> }
} scale 2
  translate < 3.5,1.2,9.99>
}
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < -0.5,  -0.1,  -0.95>  // other corner position <X2 Y2 Z2>
  texture { 
    NBglass
    pigment { rgbf <0.1, 0.7, 0.8, 0.8> }
} scale 2
  translate < 4.6,1.2,9.99>
}

//marquee
#declare marquee =
// create a box that extends between the 2 specified points
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < 2,  -0.4,  -0.6>  // other corner position <X2 Y2 Z2>
  pigment {rgb 1}
}

text
{
  ttf "crystal.ttf", "LIVE GIRLS",
  1, // depth
  0  // spacing
  
  scale 0.5
  pigment {rgb <1,0,0>} finish {ambient 0.5}
  
  //rotate y*-90
  translate <1.2,1.4,7.7>
}

object { marquee
         translate <2,2.3,8.88>}
//End of Strip Bar         

//Office Building
box
{
  <-8, -1, -2>  // one corner position <X1 Y1 Z1>
  < 0,  6,  1>  // other corner position <X2 Y2 Z2>
  translate <0,0,10> 
  texture{ pigment {rgb <0,1,0>}
                 finish {ambient 0.01}
                 }}
//windows for Office Building
#declare off_box =
// create a box that extends between the 2 specified points
box
{
  <-1, -1, -1>  // one corner position <X1 Y1 Z1>
  < -0.5,  -0.2,  -0.95>  // other corner position <X2 Y2 Z2>
  texture { 
    NBglass
    pigment { rgbf <0.1, 0.7, 0.8, 0.8> }
} scale 2
  translate < -5,5.9,9.99>
}                 
                 
#declare winrun =
union{
#declare Count=0;
 #while (Count < 5)
  object{off_box translate x*1.415*Count}
  #declare Count=Count+1;
 #end} 
 
#declare Count=0;
 #while (Count < 3)
  object{winrun translate y*-1.99*Count} 
  #declare Count=Count+1;
 #end
//end office windows 
//end office building


//Flying Monkey text*********************************


#declare fmms =
union {
text
{
  ttf "crystal.ttf", "Messenger Service",
  1, // depth
  0  // spacing
  
  scale 0.5
  pigment {rgb <1,0,0>} finish {ambient 0.5}
  
  rotate y*-90
  translate <-0.95,2.5,-6>
}

text
{
  ttf "crystal.ttf", "Flying Monkeys!",
  1, // depth
  0  // spacing
  scale 0.5 // stretch it taller
  pigment {rgb <1,0,0>}  finish {ambient 0.5}
  
  rotate y*-90
  translate <-0.95,3,-6>
}
text
{
  ttf "crystal.ttf", "Messenger Service",
  0.05, // depth
  0  // spacing
  
  scale 0.5
  pigment {rgb <1,0,0>} finish {ambient 0.01}
  
  rotate y*-90
  translate <-0.93,2.5,-6>
}


text
{
  ttf "crystal.ttf", "Flying Monkeys!",
  0.05, // depth
  0  // spacing
  scale 0.5 // stretch it taller
  pigment {rgb <1,0,0>}  finish {ambient 0.01}
  
  rotate y*-90
  translate <-0.92,3,-6>
}
}//end union
//end Flying Monkeys sign

//Light above Pawnshop door
#declare doorlight =
union {
light_source
{
  0*x // light's position (translated below)
  color red 0.5  green 0.5  blue 0.5  // light's color
  fade_distance 0.4
  fade_power 1
  translate <2.9, 2, -3.5>
}

cylinder
{
  0*x,  0.4*x,  0.2
  open
pigment {rgb <0,1,0>}
finish { ambient 0.1 }
rotate z*60
translate <3, 1.8, -3.5>
 
}}
//end Door light


//Sky Stuff*****************************************************************************
//Star Plane
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  translate y*300
  texture {
    pigment {
        granite  
        color_map {
            [0.72 rgb 0.00 ] // No Stars in this area
            [0.72 rgb 0.20 ] // Very Very Faint Stars
            [0.75 rgb 0.40 ] // Very Very Faint Stars
            [0.78 rgb 0.60 ] // Very Faint Stars
            [0.81 rgb 0.80 ] // Faint Stars
            [0.85 rgb 0.95 ] // Medium White Stars
            [0.91 rgb 1.00 ] // White Stars 
            [0.91 rgb 0.00 ] // No Stars in this area
        }
    scale 5.015
    }
    finish { ambient 1 }
}
}

//Cloud Layer

plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -1.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  translate y*100
  pigment {
    agate
    color_map {
        [0.3 rgbf <1, 1, 1, 1>]
        [1 red 0.3 green 0.3 blue 0.24]
    }
    scale 400
    
}finish {ambient 0.2}}


//All of the objects come together*****************************************************
 

object {ybr}
object {psdoor}
object {doorlight}
object {fmms}
object {tinman
        scale 0.3
        translate <2.74, -0.73, -3.7> }
object {ad_light
        scale 0.3
        translate <-1,2,-6>}
        
object {ad_light
        scale 0.3
        translate <-1,2,-4>}
        
object {ad_light
        scale 0.3
        translate <-1,2,-2>}                        

object {pawn_light}
object {slippers
        scale 1.5 
        translate <3.65,-0.4,-5.35>}

object {display}
object {oz_sign
scale 0.7
        translate <1.6,5.1,7.7>
finish {ambient 3}}

object {ad_light
        scale 0.3
        rotate y*90
        translate <4.2,4,8>}
        
object {ad_light
        scale 0.3
        rotate y*90
        translate <2.2,4,8>}
        
object {ad_light
        scale 0.3
        rotate y*90
        translate <0.2,4,8>}                        
object {streetlamp
        translate <-1,-1,6.8> }

object {paper
        
        scale 0.5
        translate <0,-0.6,-5>}


//Debris blowing in the wind
#declare parts =        
disc
{
  <0, 1, 0>  // center position
  z,         // normal vector
  1.0,       // outer radius
  //0.2        // optional hole radius
pigment {
    wood
    turbulence 0.6
    color_map {
        [0.0 rgb <0.93, 0.71, 0.53>]
        [0.8 rgb <0.98, 0.81, 0.60>]
        [0.8 rgb <0.60, 0.33, 0.27>]
        [1.0 rgb <0.70, 0.60, 0.23>]
    }
}
scale 0.03
translate <1.3,-1,0>}
#declare Radius   = 0.1; 
#declare N_rev  =  2;//number of revolution
#declare N_p_rev= 9;//elements per revolution
#declare H_p_rev=0.5;//Heightdifference per r.
#declare H = H_p_rev/N_p_rev;
//-------------------------------------------
#declare Nr = 0;                // start
#declare EndNr = N_rev*N_p_rev; // end
#while (Nr < EndNr) 
 object{parts
        translate<Radius,Nr*H,0> 
        rotate<340,Nr * 360/N_p_rev ,0>} 
 #declare Nr = Nr + 1;  // next Nr
#end
//end debris blowing in the wind

object {parts}

//newspaper blowing in the wind
object {paper
        rotate z*45
        rotate y*-20
        scale 0.5}
        
object {paper
        rotate z*15
        rotate y*-60
        translate <2,0.5,1>
        scale 0.5}
        
object {paper
        rotate z*75
        rotate y*-10
        translate <2,-2,-1>
        scale 0.2}
        
object {paper
        rotate z*25
        rotate x*-40
        translate <3,-1,-0>
        scale 0.3}
        
object {paper
        rotate z*1
        rotate y*4
        translate <6,2,0.6>
        scale 0.25}
//end newspaper



