// Pov include file: macros that make sky-scrapers

#include "colors.inc"
#include "textures.inc"

#macro Building_1 (S, W, H, V)
   #local Windows = W; // Number of windows in a storey
   #local Storeys = S; // Number of floors on the building
   #local Hspace = H;   // Space between stories
   #local Vspace = V;   // Space between windows
   #local Wwidth = 4;   // Window Width
   #local Wheight = 8;  // Window heght
   #local Count = 0;    // A loop counter
   #local Walls = 4;    // Number of sides
   #local Length = 0;   // Will hold the final length of the wall
   #local R1 = seed(424345);
   #local R2 = seed(134343);  
   
   MakeTower (Windows, Storeys, Wwidth, Wheight, Vspace, Hspace)   
#end


#macro MakeTower (Windows, Storeys, Wwidth, Wheight, Vspace, Hspace)
   #local Count = 0; // Loop Counter
   #local Vpos = 0;  // Vertical position of the storey
     
   union {
   #while (Count < Storeys)
      #local Percent = rand(R2);     
      #local Wall = MakeStorey (Vspace, Wwidth, Wheight, Windows, Percent)
      object {
         Wall
         
         translate y*Vpos
      }
      object {
         Wall
         
         rotate y*90
         translate y*Vpos
      }
      object {
         Wall
         
         rotate y*90
         translate x* (Wwidth * Windows + Vspace * Windows + (Vspace * .5))
         translate y*Vpos
      }      
      object {
         Wall
         
         translate -z* (Wwidth * Windows + Vspace * Windows + (Vspace * .5))
         translate y*Vpos
      }
      #local Vpos = Vpos + Wheight + Hspace;     
      box {
         <0, Vpos, 0>,
         <(Wwidth * Windows + Vspace * Windows - (Vspace * .5)), Vpos - Hspace, -(Wwidth * Windows + Vspace * Windows - (Vspace * .5))>
         texture {
            pigment {
               color Black
            }
         }
         finish {
            ambient .1
            diffuse .2
            specular .2
            roughness .01
         }  
         
      }      
      #local Count = Count + 1;
   #end
   }

#end  
          
#macro MakeStorey (Vspace, Wwidth, Wheight, Windows, Percent)
      #local WindowCount = 0;
      #local Wvect = <1, 0, 0>; // Width vector
      #local Dvect = <0, 0, 1>; // Depth vector
      #local Hpos = <0, 0 ,0>; // Horizontal position
      
            
      #local WindowCount = 0;
      
      union {
      #while (WindowCount < Windows)
         #local TopLeft = Wvect * Hpos;
         #local TopLeft = TopLeft + (y*Wheight);
         
         #local BottomRight = Wvect * (Hpos + Wwidth);
         #local BottomRight = BottomRight;
         #local BottomRight = BottomRight + (Dvect * .5);
         box {
            TopLeft,
            BottomRight
            
            texture {
               pigment {
                  color Gold
               }
            }
            finish {
               reflection .9
               
               #local Lit = rand(R1);      
               #if (Lit < .5)
                  ambient .9
                  diffuse .5
               #else
                  ambient .1
                  diffuse .2
               #end
               specular .5
               roughness .01
               metallic
            }  
         }
         #if ( WindowCount < Windows - 1)
         box {
            TopLeft + (Wvect * Wwidth) + (Dvect * 1),
            BottomRight + (Wvect * Vspace) + (Dvect * -1)
            texture {
               pigment {
                  color Black
               }
            }
            finish {
               ambient .1
               diffuse .2
               specular .2
               roughness .01
            }
            
               
         }
         #end
         #local WindowCount = WindowCount + 1;
         #local Hpos = Hpos + Wwidth + Vspace;
      #end
      }         
#end