/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* cola.inc
*
* Pub "Hpsi-cola", dans rectangle <0, 1000, 2000> - <0, 1900, 3000>
*
******************************************************************************/

#macro HP_Neon(DZ, Z)
cylinder {
  0, 900*y, DZ/2
  pigment {
    gradient z color_map{
      [0 Cyan]
      [1 Blue]
    }
    scale DZ/2
  }
  finish {ambient 1 diffuse 0}
  translate <0, 1000, Z>
}
#end

#macro HP_Photon()
#local R=10;
#local H=20;
#local L=100;
#local STEPS=int(4*1000/L+1);
sphere_sweep{
  catmull_rom_spline_sphere_sweep,
  STEPS,
  #local X=3000;
  #local i=0;
  #while (i<STEPS)
    <0, 1000+H*sin(X*6.2831/L), X>, R
    #local X = X - L/4;
    #local i=i+1;
  #end
  bounded_by{box{<-R, 1000-H-R, 3000>, <R, 1000+H+R, 2500>}}
  pigment {White}
  finish {ambient 1 diffuse 0}
  translate <10, 500, 0>
}
#end

#macro HP_Texte()
union {
  text {
    ttf "NWV.TTF" "H   - COLA" 
    .1, 0.1*x
    scale <150, 150, 10> 
    rotate 90*y
    translate <30, 1650, 2950>
    bounded_by{box{<60, 1600, 2000><0, 1800, 3000>}}
    translate 50*y
    pigment {White}
    finish {ambient 1 diffuse 0}
  } 
  text {
    ttf "GREEK.TTF" "y" 
    .1, 0
    scale <250, 250, 10> 
    rotate 90*y
    translate <30, 1650, 2830>
    //bounded_by{box{<60, 450, 2000><0, 600, 3000>}}
    translate 50*y
    pigment {White}
    finish {ambient 1 diffuse 0}
  } 
  text {
    ttf "NWV.TTF" "The choice of" 
    .1, 0.1*x
    scale <100, 100, 10> 
    rotate 90*y
    translate <30, 1250, 2955>
    bounded_by{box{<60, 1200, 2000><0, 1400, 3000>}}
    pigment {White}
    finish {ambient 1 diffuse 0}
  } 
  text {
    ttf "NWV.TTF" "a     generation" 
    .1, 0.03*x
    scale <100, 100, 10> 
    rotate 90*y
    translate <30, 1100, 2955>
    bounded_by{box{<60, 1000, 2000><0, 1200, 3000>}}
    pigment {White}
    finish {ambient 1 diffuse 0}
  } 
  text {
    ttf "GREEK.TTF" "n" 
    .1, 0
    scale <200, 200, 10> 
    rotate 90*y
    translate <30, 1100, 2855>
    bounded_by{box{<60, 1000, 2600><0, 1300, 2800>}}
    pigment {White}
    finish {ambient 1 diffuse 0}
  }
  translate -20*x
}
#end

#macro HP_Logo()
#local YinRatio=.5;
union{ // Partie suprieure (rouge)
  difference{
    cylinder {0, 25*x, 100}
    box {<-5, -100, -100>, <30, 0, 100>}
    cylinder {-5*x, 30*x, 50 translate -50*z scale <1, YinRatio, 1>}
  }
  cylinder {0, 25*x, 50  scale <1, YinRatio, 1> translate 50*z}
  pigment {Red}
  finish {ambient 1 diffuse 0}
  translate <0, 1525, 2360>
}
union{ // Partie infrieure (bleue)
  difference{
    cylinder {0, 25*x, 100}
    box {<-5, 0, -100>, <30, 100, 100>}
    cylinder {-5*x, 30*x, 50 scale <1, YinRatio, 1> translate 50*z}
  }
  cylinder {0, 25*x, 50 scale <1, YinRatio, 1> translate -50*z}
  pigment {Blue}
  finish {ambient 1 diffuse 0}
  translate <0, 1475, 2340>
}
union{ // Flches
  cylinder {0, <0, 50, -150>, 10 translate <25, 1550, 2200>}
  cone {<0, 50, -150>, 20, <0, 70, -190>, 0 translate <25, 1550, 2200>}
  cylinder {0, <0, -50, -150>, 10 translate <25, 1450, 2200>}
  cone {<0, -50, -150>, 20, <0, -70, -190>, 0 translate <25, 1450, 2200>}
  pigment {White}
  finish {ambient 1 diffuse 0}
}
#end

#macro PubGauche()
union{
  box {<-5, 1000, 2000>, <-1000, 2000, 3000> pigment {Black}}
  #local Z=2005;
  #local DZ=20;
  #while (Z<3000)
    HP_Neon(DZ, Z)
    #local Z = Z+DZ;
  #end
  HP_Photon()
  HP_Texte()
  HP_Logo()
  light_group "fluo"
}
#end

