/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* halo.pov
*
* 3D light flare
*
******************************************************************************/

#declare Lamp_Halo_Seed=seed(123);
#macro Lampe_Halo(R)
#local KK=3;
#local KK2=.3;
#local THR=0.8;
#local FREQ=20;

sphere {
  0, 1 hollow
  pigment {Clear}
  interior {
    media{
      method 3
      intervals 100 samples 5, 10
      confidence 0.01 variance 0.01
      emission rgb <1, .95, .9>
      density{ // Dcroissance "classique"
	onion color_map{
	  [0.0 Gold/KK]
	  [0.5 Gold*.3/KK]
	  [0.7 Silver*.1/KK]
	  [1.0 Black]
	}
      }
      density{ // Rayons
	radial frequency FREQ
	color_map{
	  [0 Black]
	  [THR White*KK*KK2]
	  [THR White*KK]
	  [1 White*KK]
	}
	scale .1
      }
      density{ // Rayons
	radial frequency FREQ
	color_map{
	  [0 Black]
	  [THR White*KK*KK2]
	  [THR White*KK]
	  [1 White*KK]
	}
	scale .1
	rotate 90*z
      }
      density{ // Rayons
	radial frequency FREQ
	color_map{
	  [0 Black]
	  [THR White*KK*KK2]
	  [THR White*KK]
	  [1 White*KK]
	}
	scale .1
	rotate 90*x
      }
    }
  }
  rotate 360*rand(Lamp_Halo_Seed)
  no_shadow
  scale R
}
#end
