/******************************************************************************
*
* Megapov version alpha 0.3
*
* imbit.pov - 03/00
*
* Picadilly revu et trs corrig
*
******************************************************************************/

#include "common31.inc"
#include "bking.inc"
#include "cola.inc"
#include "hk.inc"
#include "yukawa.inc"
#include "quanta.inc"
#include "halo.inc"
#include "paves.inc"
#include "sol.inc"
#include "whs.inc"
#include "immeubles.inc"
#include "vehicules.inc"

// Motion blur sampling
#declare MBSamples=10;

global_settings{
  max_trace_level 6
  adc_bailout 1/255
  assumed_gamma 1.9
  radiosity{
    brightness       0.5
    count            35
    error_bound      2.25
    gray_threshold   0
    low_error_factor 0.5
    minimum_reuse    0.015
    nearest_count    5
    max_sample       1
    recursion_limit  3
    adc_bailout 0.01/1
  }
  #if(MBSamples>1)
    motion_blur MBSamples, 1
  #end
}

#declare vue=camera {
  perspective
  up           y
  right        -4/3 * x
  #ifdef(INVERSE)
    location     <2000, -180, -200>
    look_at      <0, -700, 1100>
  #else
    location     <2000, 180, -200>
    look_at      <0, 700, 1100>
  #end
  angle        60
}

#declare Cream=color rgb<1, .9, .8>;


#macro CarlsbergText()
  text {
    ttf "hancock.ttf" "Heisenberg" 
    .1, 0.03*x
    scale <90, 90, 10> 
    rotate 90*y
    translate <110, 920, 0>
    //bounded_by{box{<60, 1000, 2000><0, 1200, 3000>}}
    pigment {Yellow}
    finish {ambient 5 diffuse 0}
    light_group "std"
  } 
#end

#macro Carlsberg() // Heisenberg
union {
  union{
    object {CarlsbergText() translate 2800*z}
    object {CarlsbergText() translate 2200*z}
    object {CarlsbergText() translate 1600*z}
    bounded_by {box {<200, 900, 1000>, <100, 1000, 3000> }}
  }
  union {
    box {<100, 900, 1000>, <-200, 1000, 3000> }
    box {<80, 950, 1000>, <-200, 2000, 1020> }
    pigment {rgb <1, .7, .3>}
  }
  translate -50*x
  light_group "std"
}
#end

#macro ScrollHaut()
box {<50, 1900, 1000>, <-200, 2000, 3000> 
  pigment {
    image_map{
      png "albert.png"
      interpolate 2
      once
      transmit 0 1
    }
    translate -.5*x
    rotate 90*y
    scale <1, 100, 2000>
    translate <0, 1900, 2000>
  }
  finish {ambient 1 diffuse 0}
  light_group "fluo"
}
#end

#macro ScrollMilieu()
box {<20, 1400, 1020>, <-200, 1500, 2000> 
  pigment {
    //Orange
    image_map{
      png "landau2.png"
      interpolate 2
      once
    }
    translate -.5*x
    rotate 90*y
    scale <1, 100, 980>
    translate <0, 1400, 1510>
  }
  finish {ambient 1 diffuse 0}
  light_group "fluo"
}
#end

#macro Boots()
#local B_Sales2= box{// "Sales on Orbitals"
  0,1
  pigment {image_map{
    png "sales2.png" //745x145
    interpolate 2 once
  }}
  translate -.5
  scale <745, 145, 1>*0.5
  rotate 90*y
  no_shadow
}
#local B_Sales3= box{// "Exclusive"
    0,1
    pigment {image_map{
      png "sales3.png" //494x145
      interpolate 2 once
    }}
    translate -.5
    scale <494, 145, 1>*0.5
    rotate 90*y
    no_shadow
  }
#local B_Sales4= box{// "-40% on sp3!"
    0,1
    pigment {image_map{
      png "sales4.png" //567x145
      interpolate 2 once
    }}
    translate -.5
    scale <567, 145, 1>*0.35
    rotate 90*y
    no_shadow
  }
union{
  box {<50, 450, 1000>, <-200, 600, 2000> pigment {White}}
  box {<70, 0, 1000>, <-200, 600, 1100> pigment {White}}
  cylinder {
    60*x, 0*x, 1
    scale <1, 70, 100>
    texture{pigment {rgb <.1, .1, .8>}}
    texture{
      pigment{image_map{png "pauli.png" interpolate 2 once}}
      finish {ambient .4}
      translate -.5 rotate 90*y scale <1, 60, 90>*1.6 rotate 20*x}
    translate <0, 525, 1500>
  }
  box {<-105, 0, 1000>, <-200, 600, 2000> pigment {Black}}
  difference{
    box {<-100, 0, 1000>, <-200, 600, 2000>}
    box {<-90, 300, 1150>, <-110, 430, 1430>}
    box {<-90, 300, 1450>, <-110, 430, 1650>}
    box {<-90, 300, 1670>, <-110, 430, 1950>}
    box {<-90, 80, 1150>, <-110, 200, 1350>}
    box {<-90, 80, 1500>, <-110, 200, 1950>}
    box {<-90, 20, 1360>, <-110, 190, 1410>}
    box {<-90, 20, 1440>, <-110, 190, 1490>}
    pigment {White}
  }
  object {B_Sales2 rotate 5*x translate <-100, 140, 1750>}
  object {B_Sales3 rotate -1*x translate <-100, 360, 1290>}
  object {B_Sales3 rotate 3*x translate <-100, 360, 1810>}
  object {B_Sales4 rotate 2*x translate <-100, 360, 1550>}
  light_group "std"
}
#end

#macro PubMilieu()
#local h1=860;
union{
  difference{
    box {< -5, 600, 1000>, <0, 900, 2000>} // Faade
    box {<-20, 700, 1050>, <20, h1, 1175>}
    box {<-20, 700, 1205>, <20, h1, 1330>}
    box {<-20, 700, 1360>, <20, h1, 1485>}
    box {<-20, 700, 1515>, <20, h1, 1640>}
    box {<-20, 700, 1670>, <20, h1, 1795>}
    box {<-20, 700, 1825>, <20, h1, 1950>}
    pigment {BakersChoc*1.5}
    light_group "std"
  }
  box {<-5, 600, 1000>, <-10, 900, 2000> pigment {Black}}
  HK()
  Yukawa()
  light_group "std"
}
#end

#macro PubAngleBas()
union{
  intersection{
    cylinder {600*y, 1050*y, 1000}
    box {<-530, 600.1, -1100>, <530, 1050.1, -800> rotate -45*y}
    pigment{
      image_map {
	png "fermi3.png"
	interpolate 2
	once
      }
      scale <-1100, 750, 1>
      translate 550*x
      rotate -45*y
      translate 440*y
    }
    finish {ambient 1}
    translate <-1000, 0, 1000>
  }
  intersection{
    box {<0, -100, 0>, <-1000, 2100, 1000>}
    union{
      cylinder {
	600*y, 1050*y, 999
	texture {pigment {Clear} finish {ambient 1}}
	translate <-1000, 0, 1000>
      }
      cylinder {600*y, 1050*y, 975 pigment {Black} translate <-1000, 0, 1000>}
      #local Y=600;
      #while (Y<1050)
	difference{
	  torus {985, 7}
	  box {<-530, -10, -1100>, <530, 10, -800> rotate -45*y}
	  pigment {
	    gradient y
	    color_map{
	      [0 Green]
	      [1 ForestGreen]
	    }
	    scale 7/2
	  }
	  finish {ambient 1}
	  translate <-1000, Y, 1000>
	}
	#local Y = Y+20;
      #end
      #local th0=13;
      #local th=th0;
      #while (th <= 90-th0)
	cylinder {600*y, 1050*y, 7
	  pigment {
	    gradient z color_map{
	      [0 White]
	      [.5 White*.9]
	      [1 White*.5]
	    }
	    scale 3.5
	  }
	  finish {ambient 1}
	  translate 985*x
	  rotate th*y
	  translate <-1000, 0, 1000>
	}
	#local th = th+1;
      #end
      //cylinder {1500*y, 2000*y, 1000 pigment {Blue} translate <-1000, 0, 1000>}
    }
  }
  bounded_by{cylinder {600*y, 2000*y, 1005 translate <-1000, 0, 1000>}}
}
#end



#macro PubAngleMilieu()
  intersection{
    cylinder {1050*y, 1500*y, 1000}
    pigment{
      image_map {
	png "erwin.png" //937x707
	interpolate 2
	once
      }
      scale <-1000, 450, 1> *450/450
      translate 550*x
      rotate -55*y
      translate 1050*y
    }
    finish {ambient 1}
    translate <-1000, 0, 1000>
  }
  intersection{
    box {<0, 1000, 0>, <-1000, 1550, 1000>}
    cylinder {1050*y, 1500*y, 990 translate <-1000, 0, 1000>}
    pigment {
      wood color_map{
	[0.00 Black]
	[0.10 Black]
	[0.20 Pink]
	[0.50 White]
	[0.80 Pink]
	[0.90 Black]
	[1.00 Black]
      }
      scale 30
      rotate -20*y
      translate <-1000, 1200, 1000>
    }
    finish {ambient 1}
  }
  intersection{
    box {<0, 1000, 0>, <-1000, 1550, 1000>}
    cylinder {1050*y, 1500*y, 993 translate <-1000, 0, 1000>}
    cylinder {-1000*z, 1000*z, 200
      rotate -20*y
      translate <-1000, 1200, 1000>
    }
    pigment {White}
    finish {ambient 1}
  }
  intersection{
    box {<0, 1000, 0>, <-1000, 1550, 1000>}
    cylinder {1050*y, 1500*y, 996 translate <-1000, 0, 1000>}
    pigment {
      image_map {
	png "chat2.png"//507x709
	interpolate 2
	once
      }
      scale <-507, 709, 1>*.6
      translate 550*x
      rotate -5*y
      translate <-1000, 1060, 1000>
    }
    finish {ambient 1}
  }
#end

#macro PubAngle()
union{
  PubAngleBas()
  PubAngleMilieu()
  PubAngleHaut()
  light_group "fluo"
}
#end

/////////////////////////////////////////////////////////////////////

camera {vue}

union{
  ImmDroite()
  ImmGauche()
  WHSmith(1) // HONEY
  PubAngle()
  PubGauche()
  PubMilieu()
  ScrollHaut()
  ScrollMilieu()
  Carlsberg()
  BKing()
  Boots()
  Jag(<630, 2.5, 1000>)
  M_CAR(<680, 2.5, 2000>)
  Bmw(<1200, 2.5, 1000>)
  union{Bus() rotate 210*y translate <400, 0, -300>}
  Sol(1, 1) // HALO, PAVES
  #ifdef(INVERSE)
    scale <1, -1, 1>
  #end
}

#if (true) // Ciel nuageux
//#if (false) // Ciel nuageux
  #declare galaxy_seed = 2;
  #declare galaxy_bgnebula=6;
  #declare galaxy_intensity=1;
  #declare galaxy_starfield=false;
  #declare galaxy_declare_only=true;
  #include "galaxy.inc"
  sky_sphere {
    pigment {
      BGMilkyWay rotate z * -30
      #ifdef(INVERSE)
	scale <1, -1, 1>
      #end
    }
  }
#end

