// Persistence of Vision Raytracer
// Sol en pavs


//////////////////////////////////////////////////////////////////////// INIT

#ifndef(PAVES_INC)
  #declare paves_seed=seed(150);
  #declare PAVES_INC=1;
#end

//////////////////////////////////////////////////////////////////////// SOL
#macro Paves(paves_Xmin, paves_Xmax, paves_Zmin, paves_Zmax)
union{
  #local SIZE = 20;//11;
  #local cnt=0;
  #local paves_x=paves_Xmin;
  #while (paves_x<=paves_Xmax)
    #local paves_z=paves_Zmin;
    #local pz_old = paves_z;
    #while (paves_z<=paves_Zmax)
      #local paves_alpha=-45;
      #while (paves_alpha < 45)
	object{
	  superellipsoid{
	    <0.2+.1*rand(paves_seed), 0.2+.1*rand(paves_seed)>
	    //bounded_by{box{-1, 1}}
	    rotate 5-10*<rand(paves_seed), rand(paves_seed), rand(paves_seed)>
	    scale 5.5*<1, 1, 1+3/11*(1-abs(paves_alpha/46))>*<SIZE/11, 1, SIZE/11>
	  }
	  texture{T_Stone13 scale 3*SIZE/11}
	  translate 70*z*SIZE/11
	  rotate paves_alpha*y
	  translate <paves_x*2, -5, paves_z>
	}
	#local cnt = cnt+1;
	#local paves_alpha = paves_alpha+10;
      #end
      #local paves_z = paves_z+14*SIZE/11;
    #end
    #local paves_x = paves_x+50*SIZE/11;
  #end
  #debug concat("\n", str(cnt, 0, 0), " pavs crs")
  //bounded_by{box{<paves_Xmin-SIZE,-SIZE, paves_Zmin-SIZE>,<paves_Xmax+SIZE,SIZE, paves_Zmax+SIZE>}}
  //no_shadow
}
#end