/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* quanta.inc
*
* Pub "Quanta Weekly"
*
******************************************************************************/

// Wraps a text around a cylinder, using H as its height and R as radius...
#macro QU_WrapText(T, H, R)
//#local T1=text {
//  ttf "times.ttf" T
//  .1, 0.1*x
//  scale <H, H, 10> 
//}
//#local L = max_extent(T1).x;
#local N=strlen(T);
#local i = 0;
#local Alpha=0;
#while (i < N)
  #local T2=text{
    ttf "times.ttf" substr(T, i+1, 1) 
    1, 0
  }
  object {T2 scale <H, H, 1> translate R*z rotate Alpha*y}
  #local Alpha = Alpha + 180/pi * (max_extent(T2)-min_extent(T2)).x*H/R;
  #local i = i+1;
#end
#end

#macro QU_Txt()
  union{
    union{QU_WrapText("Thermonuclear", 250, 1000) translate 1700*y}
    union{QU_WrapText("Weekly", 180, 1000) rotate 30*y translate 1530*y}
    rotate 90*y
    pigment {Black}
    finish {ambient 1 diffuse 0}
    translate <-1000, 0, 1000>
    no_shadow
  }
#end

#macro PubAngleHaut()
union{
  QU_Txt()
  intersection{
    box {<0, -100, 0>, <-1000, 2100, 1000>}
    union{
      cylinder {1500*y, 2000*y, 975 pigment {Black} translate <-1000, 0, 1000>}
      #local Y=1510;
      #while (Y<2000)
	torus {985, 7
	  pigment {
	    gradient y
	    color_map{
	      [0 Yellow]
	      [1 Orange]
	    }
	    scale 7/2
	  }
	  finish {ambient 1}
	  translate <-1000, Y, 1000>
	}
	#local Y = Y+20;
      #end
      //cylinder {1500*y, 2000*y, 1000 pigment {Blue} translate <-1000, 0, 1000>}
    }
  }
  bounded_by{cylinder {600*y, 2000*y, 1005 translate <-1000, 0, 1000>}}
}
#end

