/******************************************************************************
*
* Superpatch d'aprs Persistence of Vision Raytracer version 3.1
*
* sol.inc
*
* Pub "Hpsi-cola", dans rectangle <0, 1000, 2000> - <0, 1900, 3000>
*
******************************************************************************/

#macro Sol_BarriereStop()
box {<-4, -1, -4>, <4, 100, 4> pigment {White*.7}}
union{
  box {<5, 99, -5>, <5, 102, 5>}
  cone {102*y, 5, 105*y, 3}
  sphere {0, 5 translate 107*y}
  texture {T_Gold_3C}
}
#end

#macro Sol_Barriere()
union{
  box {<-3, 8, 0>, <3, 12, 200>}
  box {<-3, 88, 0>, <3, 92, 200>}
  #local Z=10;
  #while (Z<200)
    box {<-2, 10, Z-1>, <2, 90, Z+1>}
    #local Z = Z+10;
  #end
  pigment {White*.7}
}
Sol_BarriereStop()
#end

#declare light_seed=seed(0);
#macro OneLight0(R, T, HALO)
union{
  light_source {
    0 
    White*.2
    fade_distance 500//800
    fade_power 3.5
    groups "std,bus"
  }
  sphere {
    0, R/1.1
    pigment {
      bozo color_map {
	[0 rgbf <1, .85, .75, .7>]
	[1 rgbf <1, .90, .80, 1>]
      }
      scale .15
      translate rand(light_seed)
    }
    finish {ambient 1}
  }
  sphere {
    0, R
    pigment {
      bozo color_map {
	[0 rgb <1, .9, .8>]
	[1 rgb <1, .95, .9>]
      }
      scale .15
      translate rand(light_seed)
    }
    finish {ambient 1}
    no_shadow
  }
  #if (HALO = 1)
    Lampe_Halo(R*2)
  #end
  translate T
}
#end

#macro Sol_Lampadaire(A, HALO)
#ifndef(Sol_Lamp1)
  #declare Sol_Lamp1=union{
    #include "lampadaire.pov" 
    rotate -90*x rotate 90*y scale <40, 20, 40> 
    pigment {ForestGreen}
    normal {bumps 0.2 bump_size 0.3 scale 3}
    finish {Dull}
  }
#end
union{
  OneLight0(15, 300*y, HALO)
  OneLight0(10, <0, 250, -50>, HALO)
  OneLight0(10, <0, 250,  50>, HALO)
  union{
//    cylinder {-y, 290*y, 8 pigment {Black} finish {Dull}}
    Sol_Lamp1
  }
  rotate A*y
}
#end

#macro Sol_Clous()
union{
  #local X = 530;
  #while (X<1500)
    sphere {0, 1 scale <6, 3, 6> translate <X, 0, 0>}
    #local X = X+30;
  #end
  texture {T_Chrome_4B}
}
#end

#macro Sol_EnFace()
union{
  union{
    box{<1000+2*500, -10, 2500><3500+2*500, 2000, 4000>}
    box{<2500, -10, 500><3500+2*500, 2000, -4000>}
    box{<0, -10, -2000><-5000, 2000, -4000>}
    pigment {Cream*.5+Orange*.5}
    finish {ambient 30}
  }
  union{Sol_Lampadaire(0, 0) translate <1000+500, 15, 1000> no_shadow}
  union{Sol_Lampadaire(0, 0) translate <1000+500, 15, 2000> no_shadow}
  union{Sol_Lampadaire(0, 0) translate <1000+500, 15, 3000> no_shadow}
  //Fill-in bus
  light_source{
    <2010, 80, -2000>
    rgb <1, .9, .8>*.3
    fade_distance 2800 fade_power 3.5
    spotlight
    point_at <500, 50, -300>
    radius 30
    falloff 50
    groups "bus"
  }
    
}
#end

#macro Sol(HALO, PAVES)
#local ecart=500;
union{
  #if (PAVES = 0)
    plane {y, 0 pigment {White *.5}} // Sol
  #end
  union{
    box {<ecart, -1, 1000>, <-1000, 15, 5000>}
    box {<-1000, -1, ecart>, <-5000, 15.01, 5000>}
    cylinder {-y, 14.99*y, 1000+ecart translate <-1000, 0, 1000>}
    pigment {White *.5}
    normal {bumps .3 bump_size 0.4 scale 10}
  }
  union{Sol_Barriere() translate <ecart-15, 15, 1000>}
  union{Sol_Barriere() translate <ecart-15, 15, 1200>}
  union{Sol_BarriereStop() translate <ecart-15, 15, 1400>}
  union{Sol_Barriere() translate <ecart-15, 15, 1800>}
  union{Sol_Barriere() translate <ecart-15, 15, 2000>}
  union{Sol_Barriere() translate <ecart-15, 15, 2200>}
  union{Sol_Barriere() translate <ecart-15, 15, 2400>}
  union{Sol_Barriere() translate <ecart-15, 15, 2600>}
  union{Sol_Barriere() translate <ecart-15, 15, 2800>}
  #local AngBarr = 180/pi*atan2(200, 1000+ecart-15);
  #local Alpha=AngBarr;
  #while (Alpha<90)
    union{Sol_Barriere() translate <1000+ecart-15, 15, 0> rotate Alpha*y translate <-1000, 0, 1000>}
    #local Alpha = Alpha + AngBarr;
  #end
  
  object {Sol_Clous() translate 1450*z}
  object {Sol_Clous() translate 1750*z}
  
  object {Sol_EnFace()}
  
  #ifndef(SimpleLights)
    union{Sol_Lampadaire(0, HALO) translate <ecart-50, 15, 1000>}
    union{Sol_Lampadaire(0, HALO) translate <ecart-50, 15, 2000>}
    union{Sol_Lampadaire(0, HALO) translate <ecart-50, 15, 3000>}
    union{Sol_Lampadaire(0, HALO) translate <ecart-50, 15, 4000>}
    union{Sol_Lampadaire(0, HALO) translate <1000+ecart-50, 15, 0> rotate 30*y translate <-1000, 0, 1000>}
    union{Sol_Lampadaire(0, HALO) translate <1000+ecart-50, 15, 0> rotate 60*y translate <-1000, 0, 1000>}
    union{Sol_Lampadaire(90, HALO) translate <-1000, 15, 50-ecart>}
    union{Sol_Lampadaire(90, HALO) translate <-2000, 15, 50-ecart>}
    union{Sol_Lampadaire(90, HALO) translate <-3000, 15, 50-ecart>}
  #end
  
  #if (PAVES = 1)
    Paves(100, 800, -200, 2400)
  #end
  light_group "std"
}
#end
