global_settings { max_trace_level 15 } 

#include "colors.inc"
#include "stones.inc"

camera {
	location <0, 1, -3> 
	look_at <0, 1, 0> 
	
	scale <100, 100, 100>
}

light_source {
    <1, 5.5, -2> 
    color rgb <1, 0.9, 0.85>
    scale <100, 100, 100>
} 

light_source {
    <0, 0.1, -2.8> 
    color rgb <1, 0.9, 0.7> 
    scale <100, 100, 100>
    shadowless
}

sky_sphere {
    pigment {
        gradient y
        color_map {
            [0 0.3 color rgb <1.2, 0.8, 0.6> color <0.7, 0.4, 0.2>]
            [0.3 1 color rgb <0.7, 0.4, 0.2> color rgb <0.7, 0.4, 0.2>]
        }
    }                                               
}                                                            

#declare City = texture {
    pigment {
        image_map {
            tga "sf.tga"
            map_type 0
            once
            interpolate 2
        }
    }
    finish {ambient 2.5}
}                  
    
#declare Panorama = union {
    smooth_triangle {0, -z, <0, 1, 0>, -z, <1, 0, 0>, -z}
    smooth_triangle {<1, 1, 0>, -z, <1, 0, 0>, -z, <0, 1, 0>, -z}
    
    texture{City} 
    translate <-0.5, -0.3, 0>
    
    scale 6.5
    scale <4.5/3, 1, 1>
    
    rotate y*180
    translate -z*3.1 
    
    scale <100, 100, 100>
}      
object {Panorama}

#declare Window = box{
    0, 1
    pigment {rgbft <0.4, 0.3, 0.1, 0.7, 0.7>}  
    finish{
        ambient 0.1 
        reflection 0.2 
        phong 0.8
    }
     
    translate <-0.5, -0.3, 0>
    
    scale <5, 5, 0.6>
    scale <4/3, 1, 1>
    
    translate z*0.1 
    
    scale <100, 100, 100>
}
object {Window} 

plane {-z, 0 pigment {rgb 0} finish {phong 0} translate z*0.70000001 scale <100, 100, 100>}

#declare cyl = cylinder{
    0, <0, 1, 0>, 0.01
    scale <1, 5, 1>
    
    pigment {rgb <0.6, 0.4, 0.3>}
    finish{ambient 0.12 phong 0.7}
}    
#declare WindowFrame = union {
    object {cyl translate -x*1}
    object {cyl translate x*1}
    object {cyl rotate z*90 translate x*1 scale <6, 1, 1> translate y*2} 
    
    translate z*0.1 
    
    scale <100, 100, 100>
}
object {WindowFrame}

#declare Tango = union {
    smooth_triangle {0, -z, <0, 1, 0>, -z, <1, 0, 0>, -z}
    smooth_triangle {<1, 1, 0>, -z, <1, 0, 0>, -z, <0, 1, 0>, -z}
    
    texture { 
        pigment {
            image_map {
                gif "tango.gif"
                filter 0, 1
                map_type 0
                once
                interpolate 2
            }
        }
        finish {ambient 0.01} 
    }
} 
object {Tango scale <2.8, 2.35, 1> translate <-2.4, 0.4, 0.699999999> scale <99, 99, 99> no_shadow}

#declare Base = box{
    0, 1
    pigment {rgb <0.4, 0.3, 0.1>}
    finish{ambient 0.1 phong 0.8}
     
    translate <-0.5, 0, 0.05>
    
    scale <5, 0.4, 1>
    scale <4/3, 1, 1>
}
object {Base scale <100, 100, 100>}                                                                            
                                                                            
#declare Tile = intersection {
    plane {-z, 0}
    plane {z, 0.01}
    plane {-x, 0 rotate -y*45 translate -x*0.3} 
    plane {x, 0 rotate y*45 translate x*0.3}
    plane {y, 0 rotate -x*45 translate y*0.2}
    plane {-y, 0 rotate x*45 translate -y*0.2}
                  
    translate y*0.2                  
     
    translate z*0.03 
    texture { T_Stone3 scale <0.1, 0.1, 1> finish{ambient 0.25 reflection 0.1}}
}  

#declare Count=0;
    #while (Count < 8)
        object{Tile translate x*0.61*Count scale <100, 100, 100>} 
        object{Tile translate -x*0.61*(Count+1) scale <100, 100, 100>}
    #declare Count=Count+1;
#end  

#declare Smoke = merge {
    sphere {0, 1}
    difference {
        sphere {0, 1 scale <1, 3, 1>}
        plane {y, 0}
    }   
      
    pigment{rgbf 1}
    interior {
        media {
            emission rgb 1
            absorption rgb 0.01
            density {
                spherical 
                color_map {
                    [0.00 rgb 0] 
                    [0.10 rgb <0.0095, 0.009, 0.008>]
                    [0.20 rgb <0.0095, 0.009, 0.008>]
                    [0.30 rgb 0]
                } 
                scale <1, 1.6, 1> 
                translate -0.8*y 
                turbulence 0.3 
                octaves 5 
                lambda 5 
                omega 1
            }             
            samples 1, 200 
            variance 0.001 
            confidence 0.999
        }
    }
    scale <3, 2.4, 3>
    hollow
} 

#declare Ground = difference {
    plane {y, 0}
    cylinder{<0, -0.28, 0>, <0, 1, 0>, 2.4}
}

#declare Bar = intersection {
plane{y, 0 rotate -z*45 translate <0.2, 0.4, 0>} 
plane{y, 0 rotate z*45 translate <-0.2, 0.4, 0>}
plane{y, 0 translate y*0.5} 
plane{x, 0 translate x*0.2}
plane{-x, 0 translate -x*0.2}
plane{-y, 0}   
}

#declare Half = union {
object {Bar}
object {Bar translate x*0.8}
object {Bar translate x*1.6}
object {Bar translate x*2.4}
object {Bar translate x*3.2}
object {Bar translate -x*0.8}
object {Bar translate -x*1.6}
object {Bar translate -x*2.4}
object {Bar translate -x*3.2}
}

#declare Top = union {
    difference {
        union {
            object {Half scale 0.5}
            object {Half scale 0.5 rotate y*90}
        }
        cylinder {
            0, <0, 1, 0>, 1
            scale 2
            inverse
        }  
        cylinder {
            0, <0, 1, 0>, 0.3
            scale 2
        }   
    } 

    cylinder {
        0, <0, 1, 0>, 1
        scale <1, 0.1, 1>
        scale 2
    }

    difference {
        cylinder {0, <0, 0.14, 0>, 1.05}
        cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1}
    
        scale 2
    } 

    difference {
        cylinder {0, <0, 0.14, 0>, 0.3}
        cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 0.25}
    
        scale 2
    }

    difference {
        cylinder {0, <0, 0.14, 0>, 0.15}
        cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 0.1}
    
        scale 2
    }

    difference {
        difference {
            cylinder {0, <0, 0.14, 0>, 1.2}
            cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1.06}
    
            scale 2
        }
        difference {
            box{<-2, 0, -0.1>, <2, 0.4, 0.1>}           
            cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1.18 inverse}  
            scale 2
            translate y*0.1
        }  
        difference {
            box{<-2, 0, -0.1>, <2, 0.4, 0.1>}           
            cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1.18 inverse}  
            scale 2
            translate y*0.1
            rotate y*90
        } 
    }

    difference {
        box{<-2, 0, -0.075>, <2, 0.14, 0.075>}           
        cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1.17 inverse}
        cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1.02}  
        scale 2
    } 

    difference {
        box{<-2, 0, -0.075>, <2, 0.14, 0.075>}           
        cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1.17 inverse}
        cylinder {<0, -0.5, 0>, <0, 0.6, 0>, 1.02}  
        scale 2
        rotate y*90
    }

    scale <1, 0.3, 1>
    translate -y*0.09
} 

union {
    union {
        object {Ground}
        object {Top}
        
        texture {
            pigment{ 
                image_map {
                    tga "ground.tga"
                }       
            }
            finish{ambient 0.14 phong 0.4}
            normal {
                bump_map {
                    tga "groundBump.tga"
                    bump_size 2.0
                }
            }
            
            
            rotate x*90
            translate <-0.5, 0, -0.5>
            scale 32.5*1.5
        }
        
    }
    object {Smoke} 
    
    scale 15
    translate <-110, 0, -55>
} 
 
#include "cart.inc"
object {
    Cart 
    translate <-20, 0, -54>
}  

#include "homeless.inc"
object {
    Homeless 
    translate <-20, 0, -54>
}
  
