// =========================================
// Fire Hydrant for Megapov
// -----------------------------------------
// Modelling by Christophe Bouffartigue, used with permission
// Isosurface adaptation and textures by Gilles Tran tran@inapg.inra.fr
// http://www.mediaport.net/Artichaud/Tran
// -----------------------------------------
// Feel free to use and modify
// -----------------------------------------
// This file will require Megapov 0.4. Since Povray 3.5 is not out when I'm writing this
// there's no way I can be sure it will work smoothly in any future Povray version
// It will require "link.inc" by Chris Colefax to work
// -----------------------------------------
// 28/04/2000
// ============================
#version unofficial MegaPov 0.4;
#include "colors.inc"
// =========================================
// Textures
// -----------------------------------------
#declare Rouge= color rgb <1,0.2, 0.05>*1;
#declare sc=0; // rgle le niveau de reflectivit
#declare Copper=Copper*0.8;
#declare txtCopper=texture{
        pigment{
                crackle solid      
                turbulence 0.2
                color_map{
                        [0 Copper*1.8]
                        [1 Copper*1.3]
                }
        }
        finish{ambient 0 diffuse 0.8 metallic brilliance 8 specular 0.051 roughness 0.001
        reflection 0.1*sc
        }
} 
#declare txtCopper2=texture{txtCopper
        normal{crackle solid turbulence 0.2}
} 
#declare txtCopper3=texture{txtCopper
        normal{wrinkles bump_size 0.2}
} 
#declare pPaint0=pigment{
                crackle solid
                turbulence 0.1
                color_map{
                        [0 Rouge*0.1]
                        [1 Rouge*0.2]
                }
        }          
#declare pPaint1=pigment{
                crackle solid
                turbulence 0.1
                color_map{
                        [0 Rouge*0.3]
                        [1 Rouge*0.5]
                }
        }          
#declare pPaint2=pigment{
                crackle solid
                turbulence 0.1
                color_map{
                        [0 Rouge*1.7]
                        [1 Rouge*1.2]
                }
        }                  
#declare txtPaintTop=texture{
        pigment{
                gradient y
                pigment_map{
                        [0 pPaint1]
                        [1 pPaint2]
                }
        }
        finish{metallic brilliance 6 ambient 0 diffuse 0.7 specular 0.1 roughness 0.01
        reflection 0.1*sc
        }
}                           
#declare txtTop_1_1=texture{
        pigment{
                gradient y
                turbulence 0.1
                poly_wave 0.3
                lambda 4           
                color_map{[0 Copper*0.1][1 Copper*0.5]}
        }
        finish{ambient 0 diffuse 0.8 metallic brilliance 4 specular 0.1 roughness 0.001}
} 
#declare k=0.02; // parameter controlling the penetration of the top paint layer : the smaller the more rusty
#declare turb=0.008;
#declare txtTop_1_2=texture{
        spherical
        turbulence turb
        lambda 3
        texture_map{
                [k*0.5 txtPaintTop]   // external layer
                [k*0.5  txtCopper]
                [k*1 txtCopper]
                [k*5 txtCopper3 scale 0.01 ] // internal layer
        }
}                                                      
#declare txtTop_1_2a=texture{
        spherical
        turbulence turb
        lambda 3
        texture_map{
                [k*0.7 txtPaintTop]   // external
                [k*0.7  txtCopper]
                [k*1 txtCopper]
//                [k*5 txtCopper3 scale 0.1] // internal
                [k*2 txtPaintTop] // internal
        }
}                                                      
#declare txtTop_1_3=texture{
        pigment{
                gradient y
                poly_wave 3
                color_map{
                        [0 Copper]
                        [0.6 Copper]
                        [0.7 Copper*0.5]
                        [1 Copper*0.3]
                }
        }
        finish{ambient 0 diffuse 0.8 metallic brilliance 4 specular 0.1 roughness 0.001
        reflection 0.1*sc
        }
} 
#declare txtTop=texture{
        gradient y   
        turbulence 0.2
        lambda 4
        warp{reset_children}
        texture_map{
                [0 txtTop_1_1]
                [0.05 txtTop_1_2a]
                [0.7 txtTop_1_2a]
                [0.8 txtTop_1_3]
                [1 txtTop_1_3]
        }                                        
}
#declare txtPaint=texture{
        pigment{pPaint2}
        finish{ambient 0 diffuse 0.8 specular 0.1 roughness 0.01}
}                           
#declare txtCopperBase=texture{
        pigment{       
                gradient y
                pigment_map{
                        [0 color Copper*0.1]
                        [1 crackle solid turbulence 0.1 color_map{[0 Copper*2][1 Copper]}]
                }
        }
        normal{crackle solid turbulence 0.1}
        finish{ambient 0 diffuse 0.8 metallic brilliance 4 specular 0.1 roughness 0.001
        }
} 
#declare txtPaintBase=texture{
        pigment{pPaint1}
        normal{crackle solid bump_size 1 scale 0.1}
        finish{ambient 0 diffuse 0.8 specular 1 roughness 0.01}
}                           
#declare txtBody_1=texture{
        pigment{
                gradient y
                pigment_map{
                        [0 pPaint0 scale 0.1*<1,1/4,1>]
                        [0.7 pPaint2 scale 0.1*<1,1/4,1>]
                        [1 color Black scale 0.1*<1,1/4,1>]
                }
        }          
        finish{ambient 0 diffuse 0.8 specular 1 roughness 0.01 reflection 0.1*sc}
}                           
#declare txtBody_2=texture{
        pigment{
                gradient y
                pigment_map{
                        [0 pPaint0 scale 0.1*<1,1/4,1>]
                        [1 pPaint2 scale 0.1*<1,1/4,1>]
                }
        }          
        normal{wrinkles bump_size 0.2 scale 0.1*<1,1/4,1>}
        finish{ambient 0 diffuse 0.8 specular 1 roughness 0.01}
} 
#declare txtBody=texture{
        #declare k=0.012; // parameter controlling the penetration of the top paint layer : the smaller the more rusty
        cylindrical
        turbulence 0.006
        lambda 3
        texture_map{
                [k*0.65 txtBody_1 ]   // external
                [k*0.66  txtCopper scale <1,1/4,1>]
                [k*1 txtCopper3 scale <1,1/4,1>]
                [k*3 txtBody_2 ] // internal
        }
}                     
#declare txtPlug=texture{
        gradient x
        turbulence 0.3
        lambda 4
        warp{reset_children}
        texture_map{
                [0 txtPaint scale 0.1]               
                [0.2 txtPaint scale 0.1]               
                [0.3 txtCopper scale 1/5]                
        }
}
#declare txtBase=texture{
        #declare k=0.2;
        cylindrical
        turbulence 0.3
        lambda 4
        texture_map{
                [k*0.8 txtCopperBase scale <0.1,1,0.1>] // Externe
                [k*1.1 txtPaintBase] // Interne
        }
}
// ============================
// Macros
// ============================

#macro rounded_bar(corner1, corner2, R)

union {
        box{ <corner1.x, corner1.y+R, corner1.z+R>, <corner2.x,corner2.y-R, corner2.z-R> }
        box{ <corner1.x+R, corner1.y, corner1.z+R>, <corner2.x-R,corner2.y, corner2.z-R> }
        box{ <corner1.x+R, corner1.y+R, corner1.z>, <corner2.x-R,corner2.y-R, corner2.z> }
        sphere { 0, R translate <corner1.x+R, corner1.y+R, corner1.z+R> }
        sphere { 0, R translate <corner1.x+R, corner1.y+R, corner2.z-R> }
        sphere { 0, R translate <corner1.x+R, corner2.y-R, corner1.z+R> }
        sphere { 0, R translate <corner1.x+R, corner2.y-R, corner2.z-R> }
        sphere { 0, R translate <corner2.x-R, corner1.y+R, corner1.z+R> }
        sphere { 0, R translate <corner2.x-R, corner1.y+R, corner2.z-R> }
        sphere { 0, R translate <corner2.x-R, corner2.y-R, corner1.z+R> }
        sphere { 0, R translate <corner2.x-R, corner2.y-R, corner2.z-R> }
        cylinder { <corner1.x+R, corner1.y+R, corner1.z+R>, <corner1.x+R,corner1.y+R, corner2.z-R>, R }
        cylinder { <corner1.x+R, corner1.y+R, corner1.z+R>, <corner1.x+R,corner2.y-R, corner1.z+R>, R }
        cylinder { <corner1.x+R, corner1.y+R, corner1.z+R>, <corner2.x-R,corner1.y+R, corner1.z+R>, R }
        cylinder { <corner1.x+R, corner1.y+R, corner2.z-R>, <corner1.x+R,corner2.y-R, corner2.z-R>, R }

        cylinder { <corner1.x+R, corner1.y+R, corner2.z-R>, <corner2.x-R,corner1.y+R, corner2.z-R>, R }
        cylinder { <corner2.x-R, corner1.y+R, corner1.z+R>, <corner2.x-R,corner1.y+R, corner2.z-R>, R }
        cylinder { <corner2.x-R, corner1.y+R, corner1.z+R>, <corner2.x-R,corner2.y-R, corner1.z+R>, R }
        cylinder { <corner2.x-R, corner1.y+R, corner2.z-R>, <corner2.x-R,corner2.y-R, corner2.z-R>, R }

        cylinder { <corner1.x+R, corner2.y-R, corner1.z+R>, <corner1.x+R,corner2.y-R, corner2.z-R>, R }
        cylinder { <corner1.x+R, corner2.y-R, corner1.z+R>, <corner2.x-R,corner2.y-R, corner1.z+R>, R }
        cylinder { <corner1.x+R, corner2.y-R, corner2.z-R>, <corner2.x-R,corner2.y-R, corner2.z-R>, R }
        cylinder { <corner2.x-R, corner2.y-R, corner1.z+R>, <corner2.x-R,corner2.y-R, corner2.z-R>, R }
}

#end

#macro O_Ecrou(sc)
intersection {
        box { -x-z, x+y+z }
        box { -3*x-3*z, x+2*y+3*z rotate y*60 }
        box { -3*x-3*z, x+2*y+3*z rotate y*120 }
        box { -3*x-3*z, x+2*y+3*z rotate y*240 }
        box { -3*x-3*z, x+2*y+3*z rotate y*300 }
        scale sc
}
#end

// ============================
// Fire hydrant
// ============================
#declare r0=0.02;
#declare s0=10;
#declare haut1 = 9.3;
#declare rayon1 = 10*sqrt(1-pow(haut1/10,2));
#declare fpig=function{pigment{wrinkles}}
#declare F_Top = union {
        union {
                cylinder { 0, .3*y, 11.8 }
                cylinder { .3*y, 2*y, 12 }
                difference {             
//                        sphere {0, 1} // original sphere
                        isosurface{
                                function{y^2+x^2+z^2-1+ (1 - fpig(x*s0,y*s0,z*s0))*r0}
                                contained_by {box{-1,1}}
                                eval    
                                sign 1
                                threshold 0
                        }
                        
                        #declare i = 0;
                        #declare n=8;
                        #while (i <n/2)
                                torus { 1.5, 0.57
                                        rotate x*90
                                        scale <1,1,0.7>
                                        rotate y*i*360/n
                                        scale <1,1.11,1>
                                }
                                #declare i = i + 1;
                        #end 
                        
                        texture{txtTop}
                        scale 10
                        translate 2*y
                }
                cylinder { haut1*y, 9.8*y, rayon1 translate 2*y }
        }
        union {
                object {
                        O_Ecrou(<rayon1*.8, 1, rayon1*.8>)
                        translate 9.8*y
                        translate 2*y
                }
                object {
                        rounded_bar(<-rayon1*.4, -.2, -rayon1*.4>,<rayon1*.4, 2, rayon1*.4>, .2)
                        translate 10.8*y
                        translate 2*y
                }
        }
}


#declare F_Corps = union {
        union {                     
                union{
                        torus { 1,1/6 scale <12, 6, 12> translate 1*y }
                        cylinder { 0, 1*y, 12*(1+1/6) }
                        cylinder { 0, 2*y, 12 }
                        cone { 2*y, 11, 3*y, 10 }
                        texture{txtBase scale <13,3,13>}
                }
                #declare tmp = 6;
                #while (tmp > 0)
                        #declare tmp = tmp - 1;
                        object {
                                O_Ecrou(<1, 1, 1>)
                                translate 2.01*y +  11.5*x
                                rotate y*360*tmp/6
                                texture {txtTop_1_3 scale 0.1}
                        }
                #end
                difference {
//                        cylinder {0.3*y, 4*y, 1 } // original cylinder
                        isosurface{
                                function{x^2+z^2-1+ (1 - fpig(x*s0,y*s0,z*s0))*r0}
                                contained_by {box{<-1,0.3,-1>,<1,4,1>}}
                                eval    
                                sign 1
                                threshold 0
                        }
                        
                        #declare tmp = 20;
                        #while (tmp >0)
                                #declare tmp = tmp - 1;
                                union {
                                        sphere { 0, 0.2 }
                                        cylinder { 0, 1.9*y, 0.2 }
                                        sphere { 1.9*y, 0.2 }
                                        translate <1.17,0.4,0>
                                        rotate y*360*tmp/20
                                }
                        #end
                        
                        scale <1,1/4,1>
                        texture{txtBody}
                        scale <10,40,10>
                } 
                union {
                        cylinder {0, 7*x, 5  texture{txtPlug scale 7} translate x*8}
                        cylinder {0, 7*x, 5  texture{txtPlug scale 7} translate x*8 rotate y*180}
                        cylinder { 0, 8*x, 6  texture{txtPlug scale 8} translate x*8 rotate y*90}
                        translate y*30
                }           
                
                cylinder { 38*y, 39*y, 10.5 }
                cylinder { 39*y, 40*y, 11 }
        }
        union {
                superellipsoid { <.2,1>
                        clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
                        scale <6.2, 3, 6.2>
                }
                superellipsoid { <.3,1>
                        clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
                        scale <3.5, 1, 3.5>
                        translate 3*y
                }
                object {
                        O_Ecrou(<1.7, 1, 1.7>)
                        translate 4*y
                }   
                rotate -90*x
                translate 30*y - 16*z
        }
        union {
                superellipsoid { <.25,1>
                        clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
                        scale <5.2, 2, 5.2>
                }
                superellipsoid { <.3,1>
                        translate 2*y
                        scale <3, 1, 3>
                }
                object {
                        O_Ecrou(<1.7, 1, 1.7>)
                        translate 3*y
                }
                rotate -90*x
                rotate -90*y
                translate 30*y + 15*x
        }
        union {
                superellipsoid { <.3,1>
                        clipped_by { box {<-1.1,0,-1.1>, <1.1,1.1,1.1>} }
                        scale <5.2, 2, 5.2>
                }
                superellipsoid { <.3,1>
                        translate 2*y
                        scale <3, 1, 3>
                }
                object {
                        O_Ecrou(<1.7, 1, 1.7>)
                        translate 3*y
                }
                rotate -90*x
                rotate 90*y
                translate 30*y - 15*x
        }
}

// ============================
// A link
// ============================
#declare link_object = union {
   torus {.7, .3 clipped_by {box {<-1, -.3, -1>, <0, .3, 1>}} translate -x* .6}
   torus {.7, .3 clipped_by {box {<-1, -.3, -1>, <0, .3, 1>}} translate -x* .6 scale <-1, 1, 1>}
   cylinder {-x*.6, x*.6, .3 translate z * .7}
   cylinder {-x*.6, x*.6, .3 translate -z * .7}
   scale .5
}


// ============================
// Chris Colefax parameters
// ============================
#declare link_looseness = 15;
#declare link_count = 20;
#declare link_twist = .475;

#declare camera_sky = y-.01*x;
#declare link_point1 = <10, 25.2, 0>;
#declare link_point2 = <17, 28, 0>;
#declare O_Chaine1 = object { #include "link.inc"}

#declare camera_sky = y+.01*x;
#declare link_point1 = <-10, 25.2, 0>;
#declare link_point2 = <-17, 28, 0>;
#declare O_Chaine2 = object{O_Chaine1 scale <-1,1,1>}

#declare link_looseness = 14;
#declare link_count = 22;
#declare camera_sky = y+.01*z;
#declare link_point1 = <0, 24.5, -10>;
#declare link_point2 = <0, 27, -19>;
#declare O_Chaine3 = object { #include "link.inc"}


#declare FireHydrant = union {
        object { F_Top translate y*40 }
        object { F_Corps }
        object { O_Chaine1 }
        object { O_Chaine2 }
        object { O_Chaine3 }
        texture{txtCopper2}
}




// ============================
// Scene
// ============================
#declare PdV=<0,70, -190>;
camera {
        location PdV
        right x*4/3
        up y
        angle 30
        look_at <0,30,0>
}

light_source{<1,1,-1>*1000  color rgb<252,255,255>*2/255 
//        area_light <100,0,0>,<0,0,100> 4,4 jitter orient adaptive 1 // area light for a nice render
}
light_source{<-1,0.5,-0.1>*1000  color rgb<230,245,255>*0.3/255 shadowless}
light_source{<-1,0.5,1>*1000  color rgb<230,245,255>*0.5/255 shadowless}
light_source{PdV  color rgb<230,245,255>*0.24/255 shadowless}

plane{y,0 texture{pigment{rgb<197,181,165>*0.6/255} finish{ambient 0 diffuse 0.7}}}
background{White}
object { FireHydrant rotate y*45}


// ============================
// C'est la fin
// ============================
