// =========================================
// News vending machine type 1 for Povray 3.1g
// -----------------------------------------
// (c) 2000 Gilles Tran tran@inapg.inra.fr
// http://www.mediaport.net/Artichaud/Tran
// -----------------------------------------
// Feel free to use and modify
// -----------------------------------------
// This is a simple macro that creates US-type news vending machines
// No work was done on the textures, it's up to you
// -----------------------------------------
// 28/04/2000
// ============================

#macro mNewsVM(xVMBox,yVMBox,zVMBox,rtyVMBox,eVM,txtPaintHead,txtPaintBox,txtNewsTop,txtNewsFront,txtNewsBottom)
// xVMBox, yVMBoxn, ZVMBox = size of the box containing the papers
// rtMBox : ratio between the bottom part of the box (usually with the newspaper name) and the middle part (with the paper of the day)
// eVM : thickness of the box walls
// txtPaintHead : texture of the head (where you put the money)
// txtPaintBox : texture of the box                            
// txtNewsTop : image map for the head (instructions)
// txtNewsFront : image map for the newspaper
// txtNewsBottom : image map for the bottom of the box

#local xVMHead=xVMBox*0.5;
#local yVMHead=xVMHead/0.7;
#local zVMHead=xVMHead;
#local VMHead=union{
        union{
//                box{0,1 translate -x*0.5 scale <xVMHead/(xVMHead+2*eVM),yVMHead/(yVMHead+eVM),zVMHead/(zVMHead+5*eVM)> translate z*4*eVM} // box
                superellipsoid{<0.1,0.1> scale 0.5 translate <0,0.5,0.5> scale <xVMHead/(xVMHead+2*eVM),yVMHead/(yVMHead+eVM),zVMHead/(zVMHead+5*eVM)> translate z*4*eVM} // box
                cylinder{-0.5*x,x*0.5,1/30 scale <1,1,2> translate <0,29/30,0>}
                union{
                        difference{
                                box{<-0.5,0,1/3>,<0.5,1,1>}
                                plane{z,0 rotate -x*15 translate <0,2/3,1/3>}
                                
                        }                        
                        difference{
                                cylinder{-0.5*x,x*0.5,1/3}
                                plane{z,0 inverse}
                                plane{y,0 inverse}
                                translate <0,1,1/3>
                        }
                }
                scale <xVMHead,yVMHead,zVMHead>     
        }                
        box{0,1 texture{txtNewsTop} translate -x*0.5 scale <xVMHead*0.8,yVMHead*0.4,-eVM> translate <0,yVMHead*0.6-eVM*2,1.9*eVM>}
        #declare rC=zVMHead/15;
        difference{
                cone{0,1,x*0.5,0.8}
                cylinder{-x,x*1.1,0.7}
                scale rC
                translate <xVMHead*0.5,rC*3,zVMHead*2/3>
        }
        difference{
                cone{0,1,x*0.5,0.8}
                cylinder{-x,x*1.1,0.7}
                scale rC
                translate <xVMHead*0.5,rC*3,zVMHead*2/3>
                scale <-1,1,1>
        }
        difference{
                cone{0,1,z*0.5,0.8}
                cylinder{-z,z*1.1,0.7}
                scale rC*0.8
                rotate y*180
                translate <0,yVMHead*2/3,eVM>
        }
}                       
#local VMSides=union{
        box{0,<eVM,yVMBox,zVMBox> translate <-xVMBox/2,0,0>}  // left
        box{0,<eVM,yVMBox,zVMBox> translate <-xVMBox/2,0,0> scale <-1,1,1>} // right
        box{0,1 translate -x*0.5 scale <xVMBox,eVM,zVMBox> translate y*yVMBox} // top
        union{
                union{                // left upper round corner
                        difference{cylinder{0,z,1}plane{y,0}plane{x,0 inverse}}
                        box{0,1 scale <-1,-3,1>}
                        scale <eVM*0.5,eVM,zVMBox>
                        translate -x*xVMBox*0.5
                }
                union{                  // right upper round corner
                        difference{cylinder{0,z,1}plane{y,0}plane{x,0 inverse}}
                        box{0,1 scale <-1,-3,1>}
                        scale <eVM*0.5,eVM,zVMBox>
                        translate -x*xVMBox*0.5
                        scale <-1,1,1>
                }
                translate y*yVMBox     
        }
        box{0,1 translate -x*0.5 scale <xVMBox,yVMBox,eVM> scale <1,1,-1> translate z*(zVMBox-eVM)}
}
#local xVMFront=xVMBox*xVMBox/(xVMBox+3*eVM);
//#warning concat(str(xVMBox+3*eVM,0,3),"\n")
//#warning concat(str(xVMFront,0,3),"\n")
#local yVMFront=rtyVMBox*yVMBox;
#local eVMFront1=xVMBox*0.18/1.4;
#local eVMFront2=eVMFront1*0.4;
#local yVMBottom=yVMBox-yVMFront;
#local VMFront=union{
        // Outer frame
        box{0,1 translate -x*0.5 scale <xVMFront,eVMFront1,eVM>}
        box{0,1 translate -x*0.5 scale <xVMFront,eVMFront1,eVM> scale <1,-1,1> translate y*yVMFront}
        box{0,1 scale <eVMFront1,yVMFront-2*eVMFront1,eVM> translate <-xVMFront*0.5,eVMFront1,0>}
        box{0,1 scale <eVMFront1,yVMFront-2*eVMFront1,eVM> translate <-xVMFront*0.5,eVMFront1,0> scale <-1,1,1>}
        
        // Inner frame
        box{0,1 translate -x*0.5 scale <xVMFront-2*(eVMFront1-eVMFront2),-eVMFront2,-eVM> translate y*eVMFront1}
        box{0,1 translate -x*0.5 scale <xVMFront-2*(eVMFront1-eVMFront2),-eVMFront2,-eVM> scale <1,-1,1> translate y*(yVMFront-eVMFront1)}
        box{0,1 scale <-eVMFront2,yVMFront-2*(eVMFront1-eVMFront2),-eVM> translate <-xVMFront*0.5+eVMFront1,eVMFront1-eVMFront2,0>}
        box{0,1 scale <-eVMFront2,yVMFront-2*(eVMFront1-eVMFront2),-eVM> translate <-xVMFront*0.5+eVMFront1,eVMFront1-eVMFront2,0> scale <-1,1,1>}
        
        // Center pane
        box{0,1 texture{txtNewsFront} translate -x*0.5 scale <xVMFront-2*eVMFront1,yVMFront-2*eVMFront1,eVM> translate y*eVMFront1}
        
        // Hinges
        union{
                cylinder{-x*4/6,-x*2/6,1}
                cylinder{x*2/6,x*4/6,1}
                scale <xVMFront*0.5,2*eVM,2*eVM>
                translate -y*2*eVM
        }
        translate y*yVMBottom
}       
#declare yVMBPane=yVMBottom-2*eVMFront1;
#declare VMBottom=union{
        //Hinges
        union{
                cylinder{-x,-x*0.9*4/6,1}
                cylinder{-x*0.9*2/6,x*0.9*2/6,1}
                cylinder{x,x*0.9*4/6,1}
                scale <xVMFront*0.5,2*eVM,2*eVM>
                translate y*(yVMBottom-2*eVM)
        }    
        cylinder{-x,x,1 scale <xVMFront*0.5,eVMFront1*0.5,eVM> translate y*(yVMBottom-2*eVM-eVMFront1*0.5)}
        // Frame                                                  
        union{
                box{0,1 scale <eVMFront2,yVMBPane,eVM> translate -xVMFront*0.5*x}
                box{0,1 scale <eVMFront2,yVMBPane,eVM> translate -xVMFront*0.5*x scale <-1,1,1>}
                box{0,1 translate -x*0.5 scale <xVMFront,eVMFront2,eVM>}
                box{0,1 translate -x*0.5 scale <xVMFront,eVMFront2,eVM> scale <1,-1,1> translate y*yVMBPane}
                translate y*eVMFront1
        }                
        // Center pane
        box{0,1 texture{txtNewsBottom} translate -x*0.5 scale <xVMFront-2*eVMFront2,yVMBPane-2*eVMFront2,eVM> translate <0,(eVMFront1+eVMFront2),eVM>}
        // Bottom bar
        cylinder{-x,x,1 scale <xVMFront*0.5,eVMFront1*0.5,eVM*2> translate y*eVMFront1*0.5}
        
//        box{0,1 translate -x*0.5 scale <xVMFront,yVMBottom,eVM>}
        
}
#local xVMHandle=xVMHead*2.5/7;
#local yVMHandle=xVMHandle*6/2.5;
#local zVMHandle=6*eVM;
#local rVMHandle=1.5*eVM;
#local rVMHandle2=xVMHandle*0.4;
#local VMHandle=union{
        box{<0,0,-1>,1 translate -x*0.5 scale <xVMHandle,yVMHandle,-zVMHandle>}
        union{                                                    
                cylinder{-x,x,rVMHandle scale <xVMHandle*0.5,1,1> translate y*2*rVMHandle2}
                difference{torus{rVMHandle2,rVMHandle rotate x*90} plane{x,0 inverse} translate <-xVMHandle*0.5,rVMHandle2,0>}
                difference{torus{rVMHandle2,rVMHandle rotate x*90} plane{x,0 inverse} translate <-xVMHandle*0.5,rVMHandle2,0> scale <-1,1,1>}
                rotate -x*75 // you can change the handle angle here
                translate <0,yVMHandle-2*rVMHandle,-zVMHandle*0.5>
        }       
        translate y*(yVMBox-yVMHandle*0.25)
}
#local VMBox=union{
        object{VMSides}
        union{
                object{VMFront}
                object{VMBottom}
                object{VMHandle}
                translate z*eVM*5
        }
}
union{
        object{VMHead texture{txtPaintHead scale yVMHead} translate <0,yVMBox,rVMHandle*2>}
        object{VMBox texture{txtPaintBox scale yVMBox+yVMHandle}}
        
}
#end  

// =========================================
// Examples
// -----------------------------------------

#include "colors.inc"

#declare xVMBox=0.5;
#declare yVMBox=xVMBox*3/1.4;
#declare zVMBox=0.5;
#declare yrtVMBox=0.6;
#declare eVM=0.005;
#declare colNVM=rgb<1,0.6,0.05>*0.7; // jaune
#declare txtNewsTop=texture{pigment{image_map{png "newsmap_2"}} finish{ambient 0 diffuse 0.8}}
#declare txtNewsFront=texture{txtNewsTop} // should be different
#declare txtNewsBottom=texture{txtNewsTop} // should be different
#declare normNVM=normal{bozo 0.2 scale 0.4}
#declare finNVM=finish{ambient 0 diffuse 0.7 specular 0.01 roughness 0.001 reflection 0.1}
#declare txtPaintHead=texture{pigment{gradient y color_map{[0 Black][1 colNVM]}} normal{normNVM} finish{finNVM}}
#declare txtPaintBox=texture{pigment{gradient y color_map{[0 Black][1 colNVM]}} normal{normNVM} finish{finNVM}}

#declare NVM2=object{mNewsVM(xVMBox,yVMBox,zVMBox,yrtVMBox,eVM,txtPaintHead,txtPaintBox,txtNewsTop,txtNewsFront,txtNewsBottom)}

#declare xVMBox=0.49;
#declare yVMBox=xVMBox*2.5/1.4;
#declare zVMBox=0.45;
#declare yrtVMBox=0.64;
#declare colNVM=rgb<1,0.1,0.05>*0.1; // rouge
#declare colNVM2=rgb<1,0.95,0.85>;
#declare txtPaintHead=texture{pigment{gradient y color_map{[0 Black][1 colNVM2]}} normal{normNVM} finish{finNVM}}
#declare txtPaintBox=texture{pigment{gradient y color_map{[0 Black][1 colNVM]}} normal{normNVM} finish{finNVM}}
#declare NVM3=object{mNewsVM(xVMBox,yVMBox,zVMBox,yrtVMBox,eVM,txtPaintHead,txtPaintBox,txtNewsTop,txtNewsFront,txtNewsBottom)}

#declare xVMBox=0.40;
#declare yVMBox=xVMBox*3.2/1.4;
#declare zVMBox=0.4;
#declare yrtVMBox=0.63;
#declare colNVM=rgb<0.141,0.9,0.15>*0.3; // vert
#declare txtPaintHead=texture{pigment{gradient y color_map{[0 Black][1 colNVM]}} normal{normNVM} finish{finNVM}}
#declare txtPaintBox=texture{pigment{gradient y color_map{[0 Black][1 colNVM]}} normal{normNVM} finish{finNVM}}
#declare NVM4=object{mNewsVM(xVMBox,yVMBox,zVMBox,yrtVMBox,eVM,txtPaintHead,txtPaintBox,txtNewsTop,txtNewsFront,txtNewsBottom)}



camera
{
  location  <0.0, 0.7, -3>
  direction 1.5*z
  right     4*x/3
  look_at   <0.0, 0.7, 0.0>
}

background{White}
light_source{<1,1,-1>*1000 color White*0.4}
light_source{<-1,1,-1>*1000 color White*2}
union{
        object{NVM2 translate <-0.5,0,0.1>}
        object{NVM3}
        object{NVM4 translate <0.5,0,-0.1>}
        rotate y*45
} 



