// =========================================
// USA Today vending machine for Povray 3.1g
// -----------------------------------------
// (c) 2000 Gilles Tran tran@inapg.inra.fr
// http://www.mediaport.net/Artichaud/Tran
// -----------------------------------------
// Feel free to use and modify
// -----------------------------------------
// This is a news vending machines for USA today
// -----------------------------------------
// 28/04/2000
// ============================
#include "colors.inc"
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.5,  0.0>
}
background{White}
light_source{<1,1,-1>*1000 color White}
light_source{<-1,1,-1>*1000 color White*0.3}

#declare xV=1.75;
#declare yV=xV*1.4/1.75;
#declare rC=0.15;
#declare eV=0.07;
#declare zV=yV;
#declare yF=xV*2.6/1.75;
#declare rC2=rC+eV;
#declare xF=xV*0.5/1.75;
#declare txtVMHead=texture{
        pigment{rgb<0.93,0.92,0.912>}
//        normal{bozo 0.2 scale 0.1}
        finish{ambient 0 diffuse 0.5 specular 0.01 roughness 0.01 reflection 0.1}
}

#declare txtVMFoot_a=texture{
        pigment{rgb<0.93,0.92,0.912>*0.1}
 //       normal{bozo 0.2}
        finish{ambient 0 diffuse 0.8 specular 0.2 roughness 0.01 reflection 0.01}
}
#declare txtVMFoot_b=texture{
        pigment{rgb<0.93,0.92,0.912>*0.2}
        normal{bozo 0.2}
        finish{ambient 0 diffuse 0.8 specular 0.2 roughness 0.01 reflection 0.1}
}
#declare txtVMFoot=texture{
        bozo
        turbulence 0.3
        texture_map{
                [0.4 txtVMFoot_a]
                [1.6 txtVMFoot_b]
        }
}                    
#declare txtUSAToday=texture{
        pigment{image_map{gif "logo"}}
        normal{bozo 0.2}
        finish{ambient 0 diffuse 0.8 specular 0.1 roughness 0.05 reflection 0.2}
}                       
#declare USAToday=box{0,1 texture{txtUSAToday} translate <-0.5,-0.5,0> scale <213,142,1>/213}
#declare NVM_UT=union{
        // Head
        union{
                difference{cylinder{0,zV*z,rC2}cylinder{-z*0.1,zV*z*1.1,rC}plane{x,0 inverse}plane{y,0} translate <-xV/2,yV/2,0>}
                difference{cylinder{0,zV*z,rC2}cylinder{-z*0.1,zV*z*1.1,rC}plane{x,0}plane{y,0} translate <xV/2,yV/2,0>}
                difference{cylinder{0,zV*z,rC2}cylinder{-z*0.1,zV*z*1.1,rC}plane{x,0 inverse}plane{y,0 inverse} translate <-xV/2,-yV/2,0>}
                difference{cylinder{0,zV*z,rC2}cylinder{-z*0.1,zV*z*1.1,rC}plane{x,0}plane{y,0 inverse} translate <xV/2,-yV/2,0>}
                box{0,<xV,eV,zV> translate <-xV/2,yV/2+rC,0>}
                box{0,<xV,eV,zV> translate <-xV/2,yV/2+rC,0> scale <1,-1,1>}
                box{0,<eV,yV,zV> translate <xV/2+rC,-yV/2,0>}
                box{0,<eV,yV,zV> translate <xV/2+rC,-yV/2,0> scale <-1,1,1>}
                object{USAToday rotate z*45 scale xV/2 rotate y*90 translate <-xV/2-rC-eV*1.01,0,zV/2>}
                
                union{
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0 inverse}plane{y,0} translate <-xV/2,yV/2,0>}
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0}plane{y,0} translate <xV/2,yV/2,0>}
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0 inverse}plane{y,0 inverse} translate <-xV/2,-yV/2,0>}
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0}plane{y,0 inverse} translate <xV/2,-yV/2,0>}
                        cylinder{0,y*yV,eV/2 translate <-xV/2-eV/2-rC,-yV/2,0>}
                        cylinder{0,y*yV,eV/2 translate <xV/2+eV/2+rC,-yV/2,0>}
                        cylinder{0,x*xV,eV/2 translate <-xV/2,yV/2+eV/2+rC,0>}
                        cylinder{0,x*xV,eV/2 translate <-xV/2,-yV/2-eV/2-rC,0>}
                        scale <1,1,3>
                        texture{pigment{Black} finish{ambient 0 diffuse 0 specular 0.3 roughness 0.01 }}
                }
        
                union{
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0 inverse}plane{y,0} translate <-xV/2,yV/2,0>}
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0}plane{y,0} translate <xV/2,yV/2,0>}
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0 inverse}plane{y,0 inverse} translate <-xV/2,-yV/2,0>}
                        difference{torus{rC+eV/2,eV/2 rotate x*-90}plane{x,0}plane{y,0 inverse} translate <xV/2,-yV/2,0>}
                        cylinder{0,y*yV,eV/2 translate <-xV/2-eV/2-rC,-yV/2,0>}
                        cylinder{0,y*yV,eV/2 translate <xV/2+eV/2+rC,-yV/2,0>}
                        cylinder{0,x*xV,eV/2 translate <-xV/2,yV/2+eV/2+rC,0>}
                        cylinder{0,x*xV,eV/2 translate <-xV/2,-yV/2-eV/2-rC,0>}
                        union{
                                box{<-xV/2-rC-eV/2,-yV/2,0>,<xV/2+rC+eV/2,yV/2,eV>}
                                box{<-xV/2,-yV/2-rC-eV/2,0>,<xV/2,yV/2+rC+eV/2,eV>}
                                cylinder{0,eV*z,rC+eV/2 translate <-xV/2,yV/2,0>}
                                cylinder{0,eV*z,rC+eV/2 translate <xV/2,yV/2,0>}
                                cylinder{0,eV*z,rC+eV/2 translate <-xV/2,-yV/2,0>}
                                cylinder{0,eV*z,rC+eV/2 translate <xV/2,-yV/2,0>}
                                scale <1,1,-1>
                                translate z*eV/2
                        }
                        translate z*zV
                }
                union{
                        box{<-xV/2-rC-eV/2,-yV/2,0>,<xV/2+rC+eV/2,yV/2,eV>}
                        box{<-xV/2,-yV/2-rC-eV/2,0>,<xV/2,yV/2+rC+eV/2,eV>}
                        cylinder{0,eV*z,rC+eV/2 translate <-xV/2,yV/2,0>}
                        cylinder{0,eV*z,rC+eV/2 translate <xV/2,yV/2,0>}
                        cylinder{0,eV*z,rC+eV/2 translate <-xV/2,-yV/2,0>}
                        cylinder{0,eV*z,rC+eV/2 translate <xV/2,-yV/2,0>}
                        #declare yH=yV*0.7;
                        #declare zH=eV*2;
                        difference{
                                box{0,<eV,yH,zH> }
                                union{
                                        cylinder{-x*eV/2,x*eV*2,zH/2 translate y*zH}
                                        cylinder{-x*eV/2,x*eV*2,zH/2 translate y*(yH-zH)}
                                        box{<-eV/2,zH,-zH/2>,<eV*2,yH-zH,zH/2>}
                                        translate <0,0,zH>
                                }                     
                                translate <0.65*xV/2,-yV*0.2,0>
                                scale <0.5,1,-1>
                        }
                        translate z*eV
                        texture{pigment{image_map{gif "newsmap_1"}} translate <-0.5,-0.5,0> scale <xV+rC*2,yV+rC*2,1>}
                }
                
                texture{txtVMHead} 
                translate <0,yF+yV/2,-zV/2>
        }      
        difference{  
                superellipsoid{<0.3,0.3>}
                plane{y,-0.5}
                plane{y,0.5 inverse}
                scale <xF*0.5,yF,xF*0.5>
                translate y*yF/2
                texture{txtVMFoot}
        }                   
        #declare VMFootElement=union{
                cylinder{-x,x,rC}
                box{<-1,-rC*2,-rC>,<1,0,rC>}
                rotate x*10
        }                                
        union{  
                box{<-xV/2,-1,-zV/2>,<xV/2,rC,zV/2>}
                sphere{0,rC*0.5 translate <xV/2-rC,rC,zV/2-rC>}
                sphere{0,rC*0.5 translate <-xV/2+rC,rC,zV/2-rC>}
                sphere{0,rC*0.5 translate <xV/2-rC,rC,-zV/2+rC>}
                sphere{0,rC*0.5 translate <-xV/2+rC,rC,-zV/2+rC>}
                difference{object{VMFootElement scale <xV,1,1>}plane{x,0 rotate y*45 translate -x*xV/2}plane{x,0 rotate -y*45 inverse translate x*xV/2} translate -z*zV/2}
                difference{object{VMFootElement scale <xV,1,1>}plane{x,0 rotate y*45 translate -x*xV/2}plane{x,0 rotate -y*45 inverse translate x*xV/2} scale <1,1,-1> translate z*zV/2}
                difference{object{VMFootElement scale <zV,1,1>}plane{x,0 rotate y*45 translate -x*zV/2}plane{x,0 rotate -y*45 inverse translate z*zV/2} rotate y*-90 translate x*xV/2}
                difference{object{VMFootElement scale <zV,1,1>}plane{x,0 rotate y*45 translate -x*zV/2}plane{x,0 rotate -y*45 inverse translate z*zV/2} rotate y*90 translate -x*xV/2}
                translate y*rC
                scale <1.2,0.4,1.2>
                texture{txtVMFoot}
        }
        scale 0.6/xV
}                             

object{NVM_UT rotate -y*45}
plane{y,0 pigment{White}}
