//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 48 materials and 631 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 04/29/2000    (29.04.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.0,0.0,0.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.820,0.820,0.820> }

camera {  //  Camera Main_Cam
  location  <     -1.650,      -9.700,      -1.450>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    0.73618,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      40.000
  look_at   <      1.233,       0.558,      -0.816>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Closeup_Cam
  location  <     -1.450,     -10.750,      -1.800>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <      1.027,       0.904,      -0.824>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.950>*1.1000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 1
  jitter
  scale 20.0
  rotate <-20.93161, -41.717102, 46.694168>
  translate  <-60.5, -60.5, 28.5>
}



//
// ********  MATERIALS  *******
//

#include "building.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cube222 = object {
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.3, 0.01>
    translate  2.25*x
  }
}


#declare Cube011 = object {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.16>
    rotate -3.0*x
    translate  <1.9, 0.05, 0.25>
  }
}


#declare Cube032 = object {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.16>
    rotate -3.0*x
    translate  <1.9, 0.05, 0.25>
  }
}




//
// ********  OBJECTS  *******
//

#include "C:\Rhinoceros\Moray Models\billboard.inc"

#declare Object9_Ref = object {
  Object1
  material {
    KiboSig
    scale <12.0, 8.0, 1.0>
    rotate <90.0, 0.0, -0.0>
    translate <12.500000, 0.000000, 7.500000>
  }
}
#declare Object10_Ref = object {
  Object2
  material {
    KiboSig
    scale <12.0, 8.0, 1.0>
    rotate 90.0*x
    translate <12.500000, 0.000000, 7.500000>
  }
}
#declare Object11_Ref = object {
  Object5
  material {
    Boards
  }
}
#declare Object12_Ref = object {
  Object6
  material {
    Frame
  }
}
#declare Front_Sign = union {
  object { Object9_Ref }
  object { Object10_Ref }
  object { Object11_Ref }
  object { Object12_Ref }
  material {
    Filler
  }
  scale 0.3
  translate  <-3.75, -0.3, 0.95>
}
#declare CSG006 = union {
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 5.0>
    rotate -90.0*x
    translate  <2.2, -2.55, 0.3>
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 10.0>
    translate  <2.0, 0.0, -5.0>
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 10.0>
    translate  <-2.0, 0.0, -5.0>
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 5.0>
    rotate -90.0*x
    translate  <-2.2, -2.55, 0.3>
  }
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.01, 0.05>
    translate  <0.0, 1.6, 0.4>
  }
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.01, 0.05>
    translate  <0.0, -1.6, 0.4>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.01, 0.05>
    translate  <0.0, -2.4, 0.4>
  }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.01, 0.05>
    translate  <0.0, 2.4, 0.4>
  }
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    material {
      Grate
      scale <0.15, 0.375, 0.375>
    }
    scale <2.4, 0.4, 0.005>
    translate  <0.0, 2.0, 0.4>
  }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    material {
      Grate
      scale <0.15, 0.375, 0.375>
    }
    scale <2.4, 0.4, 0.005>
    translate  <0.0, -2.0, 0.4>
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 5.0>
    translate  <2.25, 0.3, -4.35>
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 5.0>
    translate  <2.25, -0.3, -4.35>
  }
  object { Cube222 }
  object { // Cube223->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -0.4>
  }
  object { // Cube224->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -1.2>
  }
  object { // Cube225->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -2.0>
  }
  object { // Cube226->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -1.6>
  }
  object { // Cube227->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -2.8>
  }
  object { // Cube228->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -0.8>
  }
  object { // Cube229->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -2.4>
  }
  object { // Cube230->Cube222
    Cube222
    rotate -0.0*y
    translate  <0.0, 0.0, -3.2>
  }
  material {
    Pole_paint
  }
}
#declare Object13_Ref = object {
  Object5
  material {
    Boards
  }
}
#declare Object14_Ref = object {
  Object6
  material {
    Frame
  }
}
#declare Back_Sign = union {
  object { Object13_Ref }
  object { Object14_Ref }
  material {
    Filler
  }
  scale 0.3
  rotate 180.0*z
  translate  <3.8, 0.3, 0.95>
}
union { // Billboard
  object { Front_Sign }
  object { CSG006 }
  object { Back_Sign }
  scale 0.4
  rotate -90.0*z
  translate  <5.8, 5.7, 3.0>
}


#declare Ground_Door_Frame = difference {
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <0.27, 0.015, 0.46>
    translate  <0.35, 0.4, -2.54>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    scale <0.255, 0.04, 0.4525>
    translate  <0.35, 0.4, -2.55>
  }
  material {
    Door_Frame
  }
}
#declare CSG003 = difference {
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.02, 0.45>
    translate  <0.35, 0.4, -2.55>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      NewBlack
    }
    scale 0.075
    translate  <0.35, 0.32, -2.3>
  }
  material {
    Blue_Door
  }
}
#declare Ground_Floor_Door = union {
  object { Ground_Door_Frame }
  object { CSG003 }
  translate  0.05*y
}
#declare CSG005 = union {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.6, 0.8>
    translate  <0.1, 0.7, -2.2>
  }
}
#declare CSG004 = union {
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.5001, 0.70001>
    translate  <0.1, -0.1, -2.3>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.27, 0.1, 0.46>
    translate  <0.35, 0.4, -2.54>
  }
}
#declare Door_Enclave = difference {
  object { CSG005 }
  object { CSG004 }
  material {
    Concrete_2
    translate <2.150000, 0.000000, -2.000000>
  }
}
union { // Door_and_Enclave
  object { Ground_Floor_Door }
  object { Door_Enclave }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Door_Frame
    }
    scale <0.02, 0.02, 0.1>
    rotate 90.0*x
    translate  <0.55, 0.5, -2.55>
  }
}


union { // Wall_Thingie_1
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      Metal_Roof_1
    }
    scale <0.025, 0.05, 0.15>
    translate  <-0.45, -0.05, -0.15>
  }
  cone { // Cone002
    <0,0,0>, 0.0075, <0,0,1>, 0.02
    material {
      Dirty_Greenish
    }
    scale <1.0, 1.0, 0.05>
    rotate -90.0*x
    translate  <-0.45, -0.15, -0.25>
  }
  cone { // Cone003
    <0,0,0>, 0.0075, <0,0,1>, 0.02
    material {
      Dirty_Greenish
    }
    scale <1.0, 1.0, 0.05>
    rotate -90.0*x
    translate  <-0.45, -0.15, -0.15>
  }
  cone { // Cone004
    <0,0,0>, 0.0075, <0,0,1>, 0.02
    material {
      Dirty_Redish
    }
    scale <1.0, 1.0, 0.05>
    rotate -90.0*x
    translate  <-0.45, -0.15, -0.05>
  }
  translate  -0.4*x
}


#declare HgtFld005 = object { 
  height_field {
    tga "C:\Simon\IRTC - City\BrickField1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    RedBrick_and_Mortar
    translate <0.000000, 0.000000, 0.100000>
  }
  scale <1.0, 1.0, 0.02>
  rotate 90.0*x
  translate  <-0.3, -0.175, 0.0>
}
#declare Broken_Wall_Extended_2 = union {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.2, 0.3>
    translate  <-0.85, 0.0, -0.7>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.2, 0.7>
    translate  <-0.925, 0.0, 0.3>
  }
  material {
    RedBrick_and_Mortar
    rotate 90.0*x
    translate <0.000000, 0.000000, 0.100000>
  }
}
intersection { // Extended_Wall_Intersection_2
  object { HgtFld005 }
  object { Broken_Wall_Extended_2 }
  translate  <-0.3, -0.1, 0.0>
}


#declare HgtFld004 = object { 
  height_field {
    tga "C:\Simon\IRTC - City\BrickField1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    RedBrick_and_Dark_Mortar
  }
  scale <1.0, 1.0, 0.02>
  rotate 90.0*x
  translate  <-0.3, -0.075, 0.0>
}
#declare Broken_Wall_Extended_1 = union {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      RedBrick_and_Dark_Mortar
      rotate 90.0*x
    }
    scale <0.15, 0.1, 0.3>
    translate  <0.85, 0.0, -0.7>
  }
}
intersection { // Extended_wall_intersection_1
  object { HgtFld004 }
  object { Broken_Wall_Extended_1 }
  translate  -0.1*y
}


union { // "Shingles"
  object { // Cube017->Cube011
    Cube011
    translate  -1.92*z
  }
  object { // Cube016->Cube011
    Cube011
    translate  -1.6*z
  }
  object { // Cube015->Cube011
    Cube011
    translate  -1.28*z
  }
  object { // Cube014->Cube011
    Cube011
    translate  -0.96*z
  }
  object { // Cube013->Cube011
    Cube011
    translate  -0.64*z
  }
  object { // Cube012->Cube011
    Cube011
    translate  -0.32*z
  }
  object { Cube011 }
  material {
    Blue_Shingles
    scale <0.9, 0.35, 0.32>
    translate <1.475000, -0.150000, -1.510000>
  }
}


box { // Black_Box_1
  <-1, -1, -1>, <1, 1, 1>
  material {
    NewBlack
  }
  scale <0.3, 0.01, 0.3>
  translate  <3.65, 0.1, 0.35>
}


#declare Roof_Scaled = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.85, 0.075, 0.075>
    rotate -45.0*x
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.85, 0.2, 0.105932>
    translate  0.2*y
  }
  scale <1.0, 0.3, 0.8>
  translate  <1.75, -0.13, 0.7>
}
union { // Roof_1
  object { Roof_Scaled }
  material {
    Metal_Roof_1
    scale 0.1
    translate <0.000000, -0.150000, 0.900000>
  }
}


union { // Brick_Ledge_1
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.1, 0.065>
    translate  <1.75, -0.025, 0.55>
  }
  material {
    RedBrick_and_Dark_Mortar
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate <0.000000, 0.250000, -0.050000>
  }
}


#declare Roof_Scaled1 = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.95, 0.075, 0.075>
    rotate -45.0*x
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.95, 0.2, 0.105932>
    translate  0.2*y
  }
  scale <1.0, 0.3, 0.8>
  translate  <1.75, -0.13, 0.7>
}
union { // Roof_2
  object { Roof_Scaled1 }
  material {
    Metal_Roof_1
    scale 0.1
    translate <20.000000, -0.150000, 0.900000>
  }
  translate  2.1*x
}


#declare Shingles_for_Grafitti = union {
  object { // Cube026->Cube032
    Cube032
    translate  -1.92*z
  }
  object { // Cube027->Cube032
    Cube032
    translate  -1.6*z
  }
  object { // Cube028->Cube032
    Cube032
    translate  -1.28*z
  }
  object { // Cube029->Cube032
    Cube032
    translate  -0.96*z
  }
  object { // Cube030->Cube032
    Cube032
    translate  -0.64*z
  }
  object { // Cube031->Cube032
    Cube032
    translate  -0.32*z
  }
  object { Cube032 }
}
intersection { // Flower_on_Shingles
  object { Shingles_for_Grafitti }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.5, 0.9>
    translate  <1.9, 0.0, -0.7>
  }
  material {
    Grafitti_Flower_Red
    scale <0.6, 1.8, 1.0>
    rotate 90.0*x
    translate <1.600000, 0.000000, -1.600000>
  }
  translate  -0.001*y
}


#declare Extended_Brick_Wall1 = union {
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.1, 0.8>
    translate  <3.8, -0.05, -0.185>
  }
  material {
    RedBrick_and_Variable_Mortar
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate <0.000000, 0.200000, -0.050000>
  }
}
#declare HgtFld006 = object { 
  height_field {
    tga "C:\Simon\IRTC - City\BrickField1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.0, 1.0, 0.02>
  translate  4.0*x
}
#declare HgtFld007 = object { 
  height_field {
    tga "C:\Simon\IRTC - City\BrickField1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.0, 1.0, 0.02>
  translate  2.0*x
}
#declare HgtFld008 = object { 
  height_field {
    tga "C:\Simon\IRTC - City\BrickField1.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.0, 1.0, 0.02>
}
#declare Wall1 = union {
  object { HgtFld006 }
  object { HgtFld007 }
  object { HgtFld008 }
  material {
    RedBrick_and_Mortar
    translate <0.010000, 0.100000, 0.100000>
  }
  rotate 90.0*x
  translate  -0.6*x
}
#declare Lower_Concrete1 = union {
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    material {
      Concrete_3
      scale <7.0, 1.0, 1.0>
      translate <21.700001, 0.000000, 0.000000>
    }
    scale <0.15, 0.2, 1.0>
    translate  <-1.15, -0.1, -2.0>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 0.1, 1.0>
    translate  <1.7, 0.0, -2.0>
  }
  material {
    Concrete_2
    translate <2.100000, 0.000000, -2.000000>
  }
}
#declare Whole_Wall1 = union {
  object { Extended_Brick_Wall1 }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    material {
      Concrete_1
    }
    scale <0.75, 0.1, 0.75>
    translate  <1.75, 0.0, -0.25>
  }
  object { Wall1 }
  object { Lower_Concrete1 }
}
#declare Wall_Removes1 = union {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale 0.25
    translate  <3.65, 0.0, 0.365>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    material {
      Concrete_1
      scale <1.7, 1.0, 0.68>
      translate <-0.450000, 0.000000, 0.425000>
    }
    scale <0.45, 1.0, 1.1>
    translate  <1.915, 0.0, -0.725>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      Concrete_1
    }
    scale <0.3, 1.0, 1.0>
    translate  <-0.5, 0.0, -3.0>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    material {
      Concrete_1
    }
    scale <0.45, 1.0, 1.0>
    translate  <0.55, 0.0, -2.8>
  }
}
difference { // Wall_with_Removes_2
  object { Whole_Wall1 }
  object { Wall_Removes1 }
  material {
    RedBrick_and_Variable_Mortar
  }
}


#declare CSG008 = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG009 = union {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG010 = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG011 = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG012 = union {
  object { CSG008 }
  object { CSG009 }
  object { CSG010 }
  object { CSG011 }
}
#declare Brick_1 = difference {
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG012 }
  material {
    Brick_Concrete
  }
  translate  <-0.5, -0.3, -2.95>
}
#declare CSG016 = union {
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG017 = union {
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG018 = union {
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG019 = union {
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG020 = union {
  object { CSG016 }
  object { CSG017 }
  object { CSG018 }
  object { CSG019 }
}
#declare Brick_3 = difference {
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG020 }
  material {
    Brick_Concrete
  }
  rotate <90.0, -0.0, -57.0>
  translate  <-0.65, -0.4, -2.95>
}
#declare CSG031 = union {
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG032 = union {
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG033 = union {
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG034 = union {
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG035 = union {
  object { CSG031 }
  object { CSG032 }
  object { CSG033 }
  object { CSG034 }
}
#declare Brick_6 = difference {
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG035 }
  material {
    Brick_Concrete
  }
  rotate <0.0, 0.0, -40.0>
  translate  <-0.45, -0.45, -2.95>
}
#declare CSG036 = union {
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG037 = union {
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG038 = union {
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG039 = union {
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG040 = union {
  object { CSG036 }
  object { CSG037 }
  object { CSG038 }
  object { CSG039 }
}
#declare Brick_7 = difference {
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG040 }
  material {
    Brick_Concrete
  }
  rotate <-90.0, 0.0, -91.0>
  translate  <-0.5, -0.4, -2.85>
}
#declare CSG041 = union {
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG042 = union {
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG043 = union {
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG044 = union {
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG045 = union {
  object { CSG041 }
  object { CSG042 }
  object { CSG043 }
  object { CSG044 }
}
#declare Brick_8 = difference {
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG045 }
  material {
    Brick_Concrete
  }
  rotate 40.0*z
  translate  <-0.55, -0.4, -2.75>
}
#declare CSG026 = union {
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG027 = union {
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG028 = union {
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG029 = union {
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG030 = union {
  object { CSG026 }
  object { CSG027 }
  object { CSG028 }
  object { CSG029 }
}
#declare Brick_5 = difference {
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG030 }
  material {
    Brick_Concrete
  }
  rotate <-0.0, 32.0, -132.0>
  translate  <-0.7, -0.55, -2.9>
}
#declare CSG021 = union {
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG022 = union {
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG023 = union {
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG024 = union {
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG025 = union {
  object { CSG021 }
  object { CSG022 }
  object { CSG023 }
  object { CSG024 }
}
#declare Brick_4 = difference {
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG025 }
  material {
    Brick_Concrete
  }
  rotate <90.0, 0.0, 41.0>
  translate  <-0.6, -0.3, -2.85>
}
#declare CSG013 = union {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG014 = union {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG015 = union {
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG046 = union {
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG047 = union {
  object { CSG013 }
  object { CSG014 }
  object { CSG015 }
  object { CSG046 }
}
#declare Brick_2 = difference {
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG047 }
  material {
    Brick_Concrete
  }
  rotate 32.0*y
  translate  <-0.3, -0.3, -2.9>
}
#declare Brick_Pile_1 = union {
  object { Brick_1 }
  object { Brick_3 }
  object { Brick_6 }
  object { Brick_7 }
  object { Brick_8 }
  object { Brick_5 }
  object { Brick_4 }
  object { Brick_2 }
  rotate -26.0*z
  translate  <0.2, -0.2, 0.0>
}
#declare Thin_Shrub10 = union {
  cone { // Cone026
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone027
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  rotate <0.0, -0.0, 45.0>
  translate  <-0.25, -0.55, -3.0>
}
#declare Thin_Shrub11 = union {
  cone { // Cone028
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone029
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  rotate <-0.0, -0.0, -164.0>
  translate  <-0.8, -0.25, -3.0>
}
#declare Thin_Shrub12 = union {
  cone { // Cone030
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone031
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  rotate <-0.0, -0.0, 155.0>
  translate  <-0.5, -0.65, -3.0>
}
#declare Bricks_and_Shrubs = union {
  object { Brick_Pile_1 }
  object { Thin_Shrub10 }
  object { Thin_Shrub11 }
  object { Thin_Shrub12 }
  translate  0.1*y
}
#declare Thin_Shrub = union {
  cone { // Cone006
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone007
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  translate  <2.45, -0.2, -3.05>
}
#declare Thin_Shrub1 = union {
  cone { // Cone008
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone009
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.2>
  translate  <3.0, -0.2, -3.05>
}
#declare Thin_Shrub2 = union {
  cone { // Cone010
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone011
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  rotate <0.0, 0.0, -177.0>
  translate  <3.55, -0.2, -3.05>
}
#declare Thin_Shrub3 = union {
  cone { // Cone012
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone013
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  translate  <2.75, -0.2, -3.0>
}
#declare Thin_Shrub4 = union {
  cone { // Cone014
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone015
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  translate  <3.25, -0.2, -3.05>
}
#declare Shrub_Group_1 = union {
  object { Thin_Shrub }
  object { Thin_Shrub1 }
  object { Thin_Shrub2 }
  object { Thin_Shrub3 }
  object { Thin_Shrub4 }
}
#declare Thin_Shrub5 = union {
  cone { // Cone016
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone017
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  translate  <2.45, -0.2, -3.05>
}
#declare Thin_Shrub6 = union {
  cone { // Cone018
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone019
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.2>
  translate  <3.0, -0.2, -3.05>
}
#declare Thin_Shrub7 = union {
  cone { // Cone020
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone021
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  rotate <0.0, 0.0, -177.0>
  translate  <3.55, -0.2, -3.05>
}
#declare Thin_Shrub8 = union {
  cone { // Cone022
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone023
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  translate  <2.75, -0.2, -3.0>
}
#declare Thin_Shrub9 = union {
  cone { // Cone024
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone025
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  translate  <3.25, -0.2, -3.05>
}
#declare Shrub_Group_2 = union {
  object { Thin_Shrub5 }
  object { Thin_Shrub6 }
  object { Thin_Shrub7 }
  object { Thin_Shrub8 }
  object { Thin_Shrub9 }
  scale <1.0, 1.0, 1.2>
  rotate 180.0*z
  translate  <6.15, -0.35, 0.6>
}
#declare Shrub_Wall_Cluster_1 = union {
  object { Shrub_Group_1 }
  object { Shrub_Group_2 }
}
#declare CSG048 = union {
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG049 = union {
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG050 = union {
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG051 = union {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG052 = union {
  object { CSG048 }
  object { CSG049 }
  object { CSG050 }
  object { CSG051 }
}
#declare Brick_9 = difference {
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG052 }
  material {
    Brick_Concrete
  }
  translate  <-0.5, -0.3, -2.95>
}
#declare CSG053 = union {
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG054 = union {
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG055 = union {
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG056 = union {
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG057 = union {
  object { CSG053 }
  object { CSG054 }
  object { CSG055 }
  object { CSG056 }
}
#declare Brick_10 = difference {
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG057 }
  material {
    Brick_Concrete
  }
  rotate <90.0, -0.0, -57.0>
  translate  <-0.65, -0.4, -2.95>
}
#declare CSG058 = union {
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG059 = union {
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG060 = union {
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG061 = union {
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG062 = union {
  object { CSG058 }
  object { CSG059 }
  object { CSG060 }
  object { CSG061 }
}
#declare Brick_11 = difference {
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG062 }
  material {
    Brick_Concrete
  }
  rotate <0.0, 0.0, -40.0>
  translate  <-0.45, -0.45, -2.95>
}
#declare CSG063 = union {
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG064 = union {
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG065 = union {
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG066 = union {
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG067 = union {
  object { CSG063 }
  object { CSG064 }
  object { CSG065 }
  object { CSG066 }
}
#declare Brick_12 = difference {
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG067 }
  material {
    Brick_Concrete
  }
  rotate <-90.0, 0.0, -91.0>
  translate  <-0.5, -0.4, -2.85>
}
#declare CSG068 = union {
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG069 = union {
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG070 = union {
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG071 = union {
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG072 = union {
  object { CSG068 }
  object { CSG069 }
  object { CSG070 }
  object { CSG071 }
}
#declare Brick_13 = difference {
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG072 }
  material {
    Brick_Concrete
  }
  rotate -52.0*z
  translate  <-0.55, -0.4, -2.75>
}
#declare CSG073 = union {
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG074 = union {
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG075 = union {
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG076 = union {
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG077 = union {
  object { CSG073 }
  object { CSG074 }
  object { CSG075 }
  object { CSG076 }
}
#declare Brick_14 = difference {
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG077 }
  material {
    Brick_Concrete
  }
  rotate <-0.0, 32.0, -132.0>
  translate  <-0.7, -0.55, -2.9>
}
#declare CSG078 = union {
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG079 = union {
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG080 = union {
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG081 = union {
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG082 = union {
  object { CSG078 }
  object { CSG079 }
  object { CSG080 }
  object { CSG081 }
}
#declare Brick_15 = difference {
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG082 }
  material {
    Brick_Concrete
  }
  rotate <90.0, 0.0, 41.0>
  translate  <-0.6, -0.3, -2.85>
}
#declare Brick_Pile_2 = union {
  object { Brick_9 }
  object { Brick_10 }
  object { Brick_11 }
  object { Brick_12 }
  object { Brick_13 }
  object { Brick_14 }
  object { Brick_15 }
  rotate -26.0*z
  translate  <0.2, -0.2, 0.0>
}
#declare Thin_Shrub13 = union {
  cone { // Cone032
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
    translate  <1.2, 0.4, 0.0>
  }
  cone { // Cone033
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
    translate  <1.25, 0.4, 0.0>
  }
  scale 0.15
  rotate <0.0, -0.0, 45.0>
  translate  <-0.25, -0.55, -3.0>
}
#declare Thin_Shrub14 = union {
  cone { // Cone034
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone035
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  rotate <-0.0, -0.0, -164.0>
  translate  <-0.8, -0.25, -3.0>
}
#declare Thin_Shrub15 = union {
  cone { // Cone036
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
    translate  <2.7, -3.4, 0.0>
  }
  cone { // Cone037
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
    translate  <2.85, -3.4, 0.0>
  }
  scale <0.15, 0.15, 0.1>
  rotate <-0.0, -0.0, 155.0>
  translate  <-0.5, -0.65, -3.0>
}
#declare Bricks_and_Shrubs1 = union {
  object { Brick_Pile_2 }
  object { Thin_Shrub13 }
  object { Thin_Shrub14 }
  object { Thin_Shrub15 }
  rotate -178.0*z
  translate  <0.35, -0.2, 0.0>
}
#declare CSG083 = union {
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG084 = union {
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG085 = union {
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG086 = union {
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG087 = union {
  object { CSG083 }
  object { CSG084 }
  object { CSG085 }
  object { CSG086 }
}
#declare Brick_16 = difference {
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG087 }
  material {
    Brick_Concrete
  }
  rotate <-0.0, 0.0, -0.0>
  translate  <-1.05, -1.0, -2.95>
}
#declare CSG088 = union {
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG089 = union {
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG090 = union {
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG091 = union {
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG092 = union {
  object { CSG088 }
  object { CSG089 }
  object { CSG090 }
  object { CSG091 }
}
#declare Brick_17 = difference {
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG092 }
  material {
    Brick_Concrete
  }
  rotate 41.0*z
  translate  <0.2, -1.8, -3.0>
}
#declare CSG093 = union {
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.01*x
}
#declare CSG094 = union {
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.09*x
}
#declare CSG095 = union {
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  -0.07*x
}
#declare CSG096 = union {
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, 0.02>
  }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    translate  -0.05*x
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, 0.02>
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.07, -0.1, -0.02>
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.2>
    rotate -90.0*x
    translate  <-0.03, -0.1, -0.02>
  }
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.1, 0.02>
    rotate 90.0*y
    translate  -0.05*x
  }
  translate  0.17*x
}
#declare CSG097 = union {
  object { CSG093 }
  object { CSG094 }
  object { CSG095 }
  object { CSG096 }
}
#declare Brick_18 = difference {
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.05>
  }
  object { CSG097 }
  material {
    Brick_Concrete
  }
  rotate <8.167984, 14.960253, -60.925762>
  translate  <2.35, -1.85, -2.95>
}
#declare Thin_Shrub16 = union {
  cone { // Cone038
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone039
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  rotate 4.0*z
  translate  <2.3, -1.5, -3.1>
}
#declare Thin_Shrub17 = union {
  cone { // Cone040
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone041
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  rotate <-0.0, 0.0, 51.0>
  translate  <2.5, -2.0, -3.1>
}
#declare Thin_Shrub18 = union {
  cone { // Cone042
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone043
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  rotate 4.0*z
  translate  <0.2, -1.35, -3.1>
}
#declare Thin_Shrub19 = union {
  cone { // Cone044
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone045
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  rotate <-0.0, 0.0, -44.0>
  translate  <-1.25, -0.5, -3.1>
}
#declare Thin_Shrub20 = union {
  cone { // Cone046
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone047
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  translate  <2.45, -0.2, -3.05>
}
#declare Thin_Shrub21 = union {
  cone { // Cone048
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone049
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.2>
  translate  <3.0, -0.2, -3.05>
}
#declare Thin_Shrub22 = union {
  cone { // Cone050
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone051
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  rotate <0.0, 0.0, -177.0>
  translate  <3.55, -0.2, -3.05>
}
#declare Thin_Shrub23 = union {
  cone { // Cone052
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone053
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  translate  <2.75, -0.2, -3.0>
}
#declare Thin_Shrub24 = union {
  cone { // Cone054
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone055
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  translate  <3.25, -0.2, -3.05>
}
#declare Shrub_Group_3 = union {
  object { Thin_Shrub20 }
  object { Thin_Shrub21 }
  object { Thin_Shrub22 }
  object { Thin_Shrub23 }
  object { Thin_Shrub24 }
  scale <0.7, 0.7, 1.0>
  translate  <-0.15, 0.075, 1.1>
}
#include "C:\Rhinoceros\Moray Models\tire.inc"

#declare Object1_Ref = object {
  Object1
  material {
    Ribs
    rotate <-0.0, 90.0, 0.0>
  }
}
#declare Object2_Ref = object {
  Object2
  material {
    Stripe
    scale 15.0
    translate <-5.000000, 0.000000, 0.050000>
  }
}
#declare Object3_Ref = object {
  Object3
  material {
    Stripe
    scale 15.0
    translate <5.000000, 0.000000, 0.000000>
  }
}
#declare Object4_Ref = object {
  Object4
  material {
    Treads
    scale 5.0
  }
}
#declare Old_tire = union {
  object { Object1_Ref }
  object { Object2_Ref }
  object { Object3_Ref }
  object { Object4_Ref }
  material {
    Filler_Red_1
  }
  scale 0.0125
  rotate <-1.845635, -64.95491, -173.389053>
  translate  <-0.6, -3.35, -3.025>
}
#declare Object5_Ref = object {
  Object1
  material {
    Ribs
    rotate <-0.0, 90.0, 0.0>
  }
}
#declare Object6_Ref = object {
  Object2
  material {
    Stripe
    scale 15.0
    translate <-5.000000, 0.000000, 0.050000>
  }
}
#declare Object7_Ref = object {
  Object3
  material {
    Stripe
    scale 15.0
    translate <5.000000, 0.000000, 0.000000>
  }
}
#declare Object8_Ref = object {
  Object4
  material {
    Treads
    scale 5.0
  }
}
#declare Old_tire1 = union {
  object { Object5_Ref }
  object { Object6_Ref }
  object { Object7_Ref }
  object { Object8_Ref }
  material {
    Filler_Red_1
  }
  scale 0.0125
  rotate <-0.249314, -13.997824, -88.969391>
  translate  <1.55, -0.2, -2.9>
}
#declare Thin_Shrub25 = union {
  cone { // Cone056
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone057
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale 0.15
  rotate <-0.0, -0.0, 27.0>
  translate  <1.8, -0.3, -3.05>
}
#declare Thin_Shrub26 = union {
  cone { // Cone058
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone059
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.1>
  rotate <0.0, -0.0, -13.0>
  translate  <1.2, -0.25, -3.05>
}
#declare Thin_Shrub27 = union {
  cone { // Cone060
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      Shrub_1_1
    }
    scale <1.0, 0.2, 2.0>
  }
  cone { // Cone061
    <0,0,0>, 0.0, <0,0,1>, 0.7
    open
    material {
      Shrub_1_1
    }
    scale <0.2, 1.0, 2.5>
    rotate 90.0*z
  }
  scale <0.15, 0.15, 0.2>
  rotate <0.0, -0.0, -10.0>
  translate  <1.5, -0.35, -3.05>
}
#declare Tires_and_stuff = union {
  object { Old_tire }
  object { Old_tire1 }
  object { Thin_Shrub25 }
  object { Thin_Shrub26 }
  object { Thin_Shrub27 }
}
union { // Junk
  object { Bricks_and_Shrubs }
  object { Shrub_Wall_Cluster_1 }
  object { Bricks_and_Shrubs1 }
  object { Brick_16 }
  object { Brick_17 }
  object { Brick_18 }
  object { Thin_Shrub16 }
  object { Thin_Shrub17 }
  object { Thin_Shrub18 }
  object { Thin_Shrub19 }
  object { Shrub_Group_3 }
  object { Tires_and_stuff }
}


#declare Ground_HF = object { 
  height_field {
    tga "C:\Simon\IRTC - City\Main Ground.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Ground_2
    scale <1.0, 1.0, 2.0>
    translate <0.000000, 0.000000, -1.000000>
  }
  scale <5.0, 5.0, 0.05>
  translate  <2.0, -4.8, -3.0>
}
#declare Mound_HF = object { 
  height_field {
    tga "C:\Simon\IRTC - City\Ground Mound.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Dirt_2
    scale <0.25, 1.0, 0.25>
  }
  scale <4.0, 0.6, 0.03>
  translate  <2.4, -0.15, -2.97>
}
union { // HF's_
  object { Ground_HF }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    material {
      Water_1
    }
    scale <5.0, 5.0, 0.035>
    translate  <2.0, -4.8, -3.05>
  }
  object { Mound_HF }
}


#declare CSG002 = difference {
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      Frame_Stain_1
      scale 1.1
      rotate <0.0, -0.0, -180.0>
      translate <0.000000, 0.000000, 1.000000>
    }
    scale <0.45, 0.9, 0.102>
    rotate 90.0*x
    translate  <0.5, 0.0, -2.65>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    material {
      NewClear
    }
    scale <0.3, 1.0, 1.0>
    translate  <0.5, 0.0, -3.0>
  }
  translate  -1.0*x
}
#declare CSG001 = difference {
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      Frame_Stain_1
      scale 1.1
      translate <0.000000, 0.000000, 1.000000>
    }
    scale <0.6, 0.9, 0.1011>
    rotate 90.0*x
    translate  <0.55, 0.0, -2.45>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      NewClear
    }
    scale <0.45, 1.0, 1.0>
    translate  <0.55, 0.0, -2.8>
  }
}
union { // Stains_and_Such
  box { // Edged_Stain_1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain_Edges
      scale 2.0
      translate <-1.000000, 11.200000, 1.000000>
    }
    scale <0.45, 0.101, 0.585>
    translate  <1.915, 0.0, -2.41>
  }
  box { // Stain_Block
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Stain_3
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-0.950000, 0.000000, 1.000000>
    }
    scale <0.22, 0.101, 0.4>
    translate  <0.85, 0.0, -1.4>
  }
  box { // Stain_Block_2
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-1.000000, 5.000000, 1.000000>
    }
    scale <0.22, 0.101, 0.5>
    translate  <-0.3, 0.0, -1.5>
  }
  box { // Graffiti_Block_Sig
    <-1, -1, -1>, <1, 1, 1>
    material {
      Grafitti_1_1
      scale 2.0
      rotate 90.0*x
      translate <-1.000000, 0.000000, -1.000000>
    }
    scale <0.35, 0.0035, 0.245>
    rotate -31.0*y
    translate  <-0.35, -0.1, -1.45>
  }
  box { // Edged_Stain_2
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain_Edges
      scale 2.0
      translate <-1.050000, -30.350000, 1.000000>
    }
    scale <0.8, 0.101, 0.7>
    translate  <3.8, 0.0, -1.7>
  }
  box { // Stain_Block1
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Stain_3
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-0.950000, 5.000000, 1.000000>
    }
    scale <0.3, 0.101, 0.6>
    rotate <180.0, 0.0, 180.0>
    translate  <2.65, 0.0, -2.4>
  }
  box { // Stain_Block_3
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-1.000000, 5.000000, 1.000000>
    }
    scale <0.27, 0.101, 0.25>
    translate  <3.65, -0.05, -0.15>
  }
  object { CSG002 }
  object { CSG001 }
  box { // Stain_Block_4
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-1.000000, 5.000000, 1.000000>
    }
    scale <0.15, 0.101, 0.7>
    translate  <0.8, 0.5, -2.3>
  }
  box { // Stain_Block_5
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Stain_3
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-1.000000, 5.000000, 1.000000>
    }
    scale <0.15, 0.101, 0.7>
    translate  <1.05, 0.5, -2.3>
  }
  box { // Stain_Block_6
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-1.000000, 5.000000, 1.000000>
    }
    scale <0.5, 0.101, 0.5>
    translate  <-0.45, 0.5, -2.5>
  }
  box { // Graffiti_Block_Sig1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Grafitti_1_1
      scale 2.0
      rotate 90.0*x
      translate <-1.000000, 0.000000, -1.000000>
    }
    scale <0.1, 0.001, 0.07>
    rotate 17.0*y
    translate  <0.45, 0.43, -2.65>
  }
  box { // Stain_Block_7
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-1.000000, 5.000000, 1.000000>
    }
    scale <0.1, 0.0009, 0.35>
    translate  <0.35, 0.43, -2.7>
  }
  box { // Stain_Block_8
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dark_Stain
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-1.000000, 32.000000, 1.000000>
    }
    scale <0.5, 0.102, 0.2>
    translate  <1.9, 0.0, -2.05>
  }
  box { // Stain_Block2
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Stain_3
      scale <1.0, 2.0, 2.0>
      rotate 90.0*z
      translate <-0.950000, 0.000000, 1.000000>
    }
    scale <0.15, 0.101, 1.0>
    translate  <-1.15, -0.2, -2.0>
  }
}




box { // POV_Grafitti_Block
  <-1, -1, -1>, <1, 1, 1>
  material {
    Grafitti_POV_1
    rotate 90.0*x
  }
  scale <0.85, 0.0035, 0.85>
  rotate <0.0, -9.0, 0.0>
  translate  <3.45, -0.1, -2.0>
}


union { // Brick_Ledge_2
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.1, 0.045>
    translate  <1.75, 0.025, 0.5>
  }
  material {
    RedBrick_and_Mortar
    scale <1.0, 1.0, 2.0>
    rotate 90.0*x
    translate <0.000000, 0.250000, -0.100000>
  }
  translate  0.5*z
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    Sky_2
  }
  scale <1000.0, 1000.0, 500.0>
} 




//
// Tree Stuff
//




#include "maketree.pov" // tree & leaf macro
#include "colors.inc"
#include "txttree.inc"

//=========================================
// Tree macro Parameters
//-----------------------------------------
// These parameters must be declared before calling the tree macro
//-----------------------------------------
#declare dofile=false;    // true creates a tree file ; false otherwise
#declare dotexture=true;  // true creates a textured tree (with the texture following the branch); false otherwise
#declare ftname="gttree1.inc" // file name for tree
#declare fvname="gtfoliage1.inc" // file name for foliage
#declare ffname="gtleaf1.inc" // file name for leaf
#declare txtTree=texture{txtTree_3} // Bark texture

//-----------------------------------------
// Random streams
// one stream for branches and another one for leaves
// so that the leafed tree has the same structure as the leafless one
//-----------------------------------------
#declare rsd=1431235;      // random seed
#declare rsd=1432;      // random seed
#declare rsd=1433;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

//-----------------------------------------
// Tree structure parameters        
// test with low level0 and nseg0 (3 or 4)
// High (>=6) recursion levels [level0] gives more complex trees
// High (>=6) segment numbers [nseg0] gives smoother trees
//-----------------------------------------
//#declare level0=5;      // recursion level
#declare level0=5;      // recursion level
#declare nseg0=12;       // initial number of branch segments (decreases of one at each level)
#declare nb=4;          // max number of branches per level
#declare dotop=true;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

#declare lb0=1.85;        // initial branch length
#declare rb0=.1//0.0750;         // initial branch radius
#declare ab0=35;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=0.8//0.67;       // branch length decrease ratio (1=constant length)
#declare qrb=0.49;       // branch radius decrease ratio (1=constant radius)
#declare qab=0.88;       // branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare branchproba=.80; // probability of branch apparition 
#declare jb=0.8;        // secondary branches start after this ratio of branch length

#declare fgnarl=0.2;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.5;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0.0; // probability to have a twig on a trunk segment

#declare v0=<.4,0,1>;    // initial direction - change to give an initial orientation
#declare pos0=<-2.0, 3.85, .5>;  // initial trunk position (no need to change this one)

//-----------------------------------------
// constraints parameters
//-----------------------------------------
#declare vpush=<1,0,-3>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=0.2;       // force of push
#declare aboveground=0; // constrains the branches above this level 
#declare belowsky=140;  // constrains the branches below this level 

//-----------------------------------------
// root parameters
//-----------------------------------------
#declare rootproba=0;   // probability of root 0=no root ; 1=all [nb] roots
#declare nroot=5;      // number of roots;
#declare vroot=<0,0,-1>; // initial direction of root 
#declare yroot=<0,0,0.5>;   // initial position of root above ground

//-----------------------------------------
// leaf position parameters
//-----------------------------------------
#declare leafproba=0 //0.9;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=100;       // max z angle for leaf
#declare alx0=-10;      // start x angle for leaf
#declare stdalx=40;     // std x angle for leaf
#declare stdlsize=0.1;     // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_0} // Leaf texture
#declare lsize=0.070;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;          // leaf length
#declare wl=1.2;          // leaf width 
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=3;      // number of lobes (individual leaves)
#declare alobes=110;    // angle made by all the lobes
#declare qlobes=0.7;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=3;          // stalk length (0=no stalk)
#declare ws=0.12;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward
//-----------------------------------------
// end of parameters
//=========================================

//=========================================
// Make the tree now !
//-----------------------------------------

object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
}


