// Persistence of Vision Ray Tracer Scene Description File
// File: Building1.inc
// Vers: 3.1
// Desc: Basic Building meant to be viewed from a distance.
// Date: 3/20/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#declare Building1Window_T = texture {
	pigment {color rgb <.1,.1,.1>}
	finish {
		ambient 0.0
		reflection 0.1
	}
}

#declare Building1Brick_T = texture {
	pigment {
		brick pigment {color rgb <168,174,138>/256} pigment {color rgb <166,110,70>/256}
		mortar 0.25
		scale 1/40
	}
}
#declare Building1WindowStripe_T = texture {
	gradient x
	rotate 45*y
	scale <0.75,1,0.75>
	texture_map {
		[0.0 Building1Brick_T]
		[0.2 Building1Brick_T]
		[0.2 Building1Window_T]
 		[0.8 Building1Window_T]
		[0.8 Building1Brick_T]
		[1.0 Building1Brick_T]
	}
}
#declare Building1_T = texture {
	gradient y
	texture_map {
		[0.0 Building1Brick_T ]
		[0.5 Building1Brick_T ]
		[0.5 Building1WindowStripe_T]
	}
}

#include "MyTextures.inc"

#macro MakeBuilding1(Size)
	#declare Size = <floor(Size.x),floor(Size.y-0.25)+0.25,floor(Size.z)>;
	difference {
		box {
			0,1
			scale Size
			texture {Building1_T}
			translate -<Size.x,0,Size.z>/2
		}
		box {
			0,1
			scale <Size.x,0.99,Size.z>
			texture {
				gradient y
				texture_map {
					[0.2 RoofTar_T]
					[0.2 Aluminum_T]
				}
			}
			scale <1,0.25,1>
			translate <-Size.x/2,Size.y-0.24,-Size.z/2>
			scale <0.95,1,0.95>
		}
	}
#end


#if (Render = 1)
	#declare BuildingSize = <10,15,5>;
	MakeBuilding1(BuildingSize)
	MakeBuilding1(BuildingSize)
	object{MakeBuilding1(BuildingSize) translate 10}
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}
	
	
	plane {
		-1*y,
		0
		pigment {
			checker
			color rgb <0,1,0>
			color <1,1,0>
		}
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <-50, 40, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 40, -50>
	}

	#local view = 1;
	#switch (view)
		#case (2)
			box {
				<-100,-10,30>,
				< 100, 100,3>
				pigment { color <1,1,1>}
			}
			camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <-10.0 , 20.0 , -10.0>
		  		look_at   <0.0 , 10.0 , 0.0>
			}
		#break	
	#end	
#end // if render
