// Persistence of Vision Ray Tracer Scene Description File
// File: Cars.inc
// Vers: 3.1
// Desc: Simple cars with nice sparkly finish and color distribution.
// Date: 3/29/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

#include "MyTextures.inc"

#declare RCars = seed(0);
#local Clear   = rgbt 1;

#declare NumCarPaintColors = 36;
#declare CarPaintColors = array[NumCarPaintColors] 
{	<034,032,027>/256, <172,177,148>/256, <153,161,126>/256, <236,228,205>/256,
	<129,055,040>/256, <199,194,194>/256, <217,226,212>/256, <056,074,092>/256,
	<227,217,206>/256, <191,202,200>/256, <038,053,056>/256, <063,078,045>/256,
	<082,112,156>/256, <196,208,183>/256, <058,080,095>/256, <201,202,220>/256,
	<216,210,203>/256, <085,111,086>/256, <198,201,204>/256, <047,065,078>/256,
	<185,153,065>/256, <243,242,168>/256, <170,155,075>/256, <215,228,209>/256,
	<186,138,073>/256, <242,240,155>/256, <192,068,032>/256, <154,166,104>/256,
	<041,045,054>/256, <046,041,035>/256, <194,065,043>/256, <212,176,070>/256,
	<225,078,011>/256, <027,036,030>/256, <076,074,045>/256, <152,152,024>/256}
//#local AwningColor = AwningColors[floor(rand(RAwning)/1.001*4)];

#macro CarColor()
	#declare TheColor = color rgb CarPaintColors[floor(rand(RCars)/1.001* NumCarPaintColors)]
							+(<rand(RCars),rand(RCars),rand(RCars)>-0.5)/10;
#end

#declare CarMeanLength = 3; // really car center to center spacing.

#declare CarTire = union {
	torus { 1,0.35
		texture {
			pigment {color rgb <0.1,0.1,0.1>}
			normal {bozo scale 1/10}
		}
	}
	sphere {0,0.7
		texture {ShinySteel_T}
		scale <1,0.35/0.7,1>
	}
	scale <1/(1.35),1,1/(1.35)>
	rotate 90*z
	translate 0.25*y
	scale 1/7
}
#macro Car_1()
	union {
		CarColor()
		#local Enamel_T = SparkleEnamel_T(TheColor)
		#local a = 1; // end layered texture.
		#if (Detail_Level < 5)
			box {
				<0,0,0>
				<0.75,0.25,2> // x,z needs to be k*10/4+1/4
				texture {pigment { TheColor} 
					finish {ambient 0.25 brilliance 2 diffuse 0.5 metallic specular 0.80}
				}
				translate <-0.75/2,0.1,-2/2>
			}
		#else
			superellipsoid {<0.3,0.2>
				translate 1
				scale <0.75,0.25,2>/2
				//texture {pigment { TheColor} finish {ambient 0.25 brilliance 2 diffuse 0.5 metallic specular 0.80 roughness 0.0005}}
				texture {Enamel_T}

				translate <-0.75/2,0.1,-2/2>
			}
			#local TireOffset = < 0.75/2,1/8, 0.5>;
			object {CarTire translate TireOffset * < 1, 1, 1>}
			object {CarTire translate TireOffset * < 1, 1,-1>}
			object {CarTire translate TireOffset * <-1, 1, 1>}
			object {CarTire translate TireOffset * <-1, 1,-1>}
		
		#end
		
		#local TheInteriorColor = rgb <0,0,0>;
		#local TheInterior_T = texture {pigment {rgb <0,0,0>}}
		#local a = 1;
		#local WindowLayer_T = texture{ radial frequency 2 rotate 90*y texture_map {[0.00 Glass_T][0.23 Glass_T][0.23 Enamel_T][0.27 Enamel_T][0.27 Glass_T][0.48 Glass_T][0.48 Enamel_T][0.52 Enamel_T][0.52 Glass_T][0.73 Glass_T][0.73 Enamel_T][0.77 Enamel_T][0.77 Glass_T][1.0 Glass_T]}}
		#local a = 1;
		prism {
			conic_sweep
			cubic_spline
			0.75,
			1.0,
			9,
			<0.4,0.5>,<-0.4,0.5>,<-0.5,0.0>,<-0.4,-0.5>,<0.4,-0.5>,<+0.5,0.0>,<0.4,0.5>,<-0.4,0.5>,<-0.5,0.0>
			hollow on
			rotate 180*x
			translate 1*y
			#if (Detail_Level < 7) // Adding partially transparent windows is expensive.
				// window bars at -xz z xz x-z -z -x-z oops, got x and z backwards.
				texture{ pigment { radial frequency 2 rotate 90*y color_map {[0.00 Clear][0.23 Clear][0.23 TheColor][0.27 TheColor][0.27 Clear][0.48 Clear][0.48 TheColor][0.52 TheColor][0.52 Clear][0.73 Clear][0.73 TheColor][0.77 TheColor][0.77 Clear][1.0 Clear]}}
					finish {ambient 0.25 brilliance 2 diffuse 0.5 metallic specular 0.80 roughness 0.0005}
				}
				// interior color at the bottom,clear for the windows, exterior color for the top.
				texture{ pigment { gradient y scale 1/2 color_map {[0.00 TheInteriorColor][0.01 TheInteriorColor][0.01 Clear][0.45 Clear][0.45 TheColor][0.5 TheColor][1.00 TheInteriorColor]}}
					finish {ambient 0.25 brilliance 2 diffuse 0.5 metallic specular 0.80 roughness 0.0005}
				}
			#else
				// window bars at -xz z xz x-z -z -x-z oops, got x and z backwards.
				// interior color at the bottom,clear for the windows, exterior color for the top.
				texture{ gradient y scale 1/2 texture_map {[0.00 TheInterior_T][0.01 TheInterior_T][0.01 WindowLayer_T][0.45 WindowLayer_T][0.45 Enamel_T][0.5 Enamel_T][1.00 TheInterior_T]}}
			#end


			scale <0.75,1,1>
			translate <0,0.51-0.15,0>
			
		}
		
		#declare CarLength = 3; // really car center to center spacing.

	}
#end


#macro PlaceObjects(InObject, XNum, YNum, XSpread, YSpread)
	#local X = -XNum/2;
	#while (X < XNum/2)
		#local Y = -YNum/2;
		#while (Y < YNum/2)
			object {
				InObject
				translate X*x*XSpread/XNum+Y*z*YSpread/YNum + <XSpread/XNum/2,0,YSpread/YNum/2>
			}
			#local Y = Y+1;
		#end
		#local X = X + 1;
	#end
#end



#macro MakeCar()
	object {
		Car_1()
	}
#end


//#declare AwningColors = array[4] {<1,0,0>,<1,1,0>,<0,1,0>,<0,0,1>}
//#local AwningColor = AwningColors[floor(rand(RAwning)/1.001*4)];


#if (Render = 1)
	#local X = -5;
	#while (X < 5)
		#local Y = -5;
		#while (Y < 5)
			object {
				Car_1()
				translate X*x*3+Y*z*4
			}
			#local Y = Y+1;
		#end
		#local X = X + 1;
	#end
	global_settings {ambient_light 3}
	#include "colors.inc"
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	 	pigment
	  	{
	  	  gradient y
	  	  color_map { 
	  	  	[0.0 MidnightBlue] 
	  	  	[1.0 CornflowerBlue*2] 
	  	  }
	  	}
	}
	plane{
		y,
		0
		pigment {color rgb <0,0.5,0.5>}
	}
	camera
	{
	  location  <-10, 2 , -5>
	  look_at   <0 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-100 , 40 , -50>
	}
	
	background {color <1,1,1>}
#end


