// Persistence of Vision Ray Tracer Scene Description File
// File: City.inc
// Vers: 3.1
// Desc: Road building blocks
// Date: 3/29/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

#include "Tower.inc"
#include "Residential.inc"
#include "Industrial.inc"

// *******************************************
// Street Descriptor creation
// *******************************************
// a road value is <Width in lanes,Gap to next road, Road type, Median Type, Sidewalk Type, Num cars per unit length>
#declare NumRoadsH = 16;
#declare RoadDescriptionH = array[NumRoadsH][6] {{9,30,1,1,1,0.5},{7,30,1,0,2,0.4},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0},{5,30,1,0,1,0.0},{7,30,1,0,1,0.0},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0},{5,30,1,0,1,0.0},{7,30,1,0,1,0.0},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0},{5,30,1,0,1,0.0},{7,30,1,0,1,0.0},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0}}
#declare NumRoadsV = 16;
#declare RoadDescriptionV = array[NumRoadsH][6] {{5,30,1,1,1,0.45},{7,30,1,0,1,0.0},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0},{5,30,1,1,1,0.0},{7,30,1,0,1,0.0},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0},{5,30,1,1,1,0.0},{7,30,1,0,1,0.0},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0},{5,30,1,1,1,0.0},{7,30,1,0,1,0.0},{5,20,1,0,1,0.0},{9,20,1,0,1,0.0}}

#include "Road.inc"

#declare RBuildingHeight = seed(0);
#declare Downtown = <0.5,0.9>;
#declare DowntownSize = 0.3;
#declare DowntownProb = 0.5;
#declare ResidentialLoc = <0.0,0.0>;
#declare ResidentialSize = 0.5;
#declare RCity = seed(0);

#macro FillBlock(HLength,VLength,HPos,VPos)
	#local DowntownDistance2 = pow(HPos-Downtown.x,2)+pow(VPos-Downtown.y,2);
	#local ResidentialDistance2 = pow(HPos-ResidentialLoc.x,2)+pow(VPos-ResidentialLoc.y,2);
	#if(DowntownDistance2 < pow(DowntownSize,2))
		#if (rand(RCity) < DowntownProb)
			MakeTower(<HLength*3/4,(1-(sqrt(DowntownDistance2)*2))*(40+20*rand(RTower)),VLength*3/4>)
		#else
			#if (rand(RCity) < 0.5)
				MakeDowntownPark(<HLength,10,VLength>)
			#else
				MakeIndustrialBlock(<HLength,3+rand(RBuildingHeight)*3,VLength>)
			#end
		#end
	#else
		#if (ResidentialDistance2 < pow(ResidentialSize,2))
			MakeResidentialBlock(<HLength,2+rand(RBuildingHeight)*2,VLength>)
		#else
			MakeIndustrialBlock(<HLength,3+rand(RBuildingHeight)*3,VLength>)
		#end
	#end
#end

#declare City = union {	
	MakeStreets(NumRoadsH,RoadDescriptionH,NumRoadsV,RoadDescriptionV)
}

#if (Render = 1)
	object {
		City
		scale 3/4
		translate <30,0.01,-20>
	}
	global_settings {ambient_light 3}
	 //MakeStreetSegment(5,1,1,1,10)
	//MakeStreetIntersection(5,2,1,1,1)
	#include "colors.inc"
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	 	pigment
	  	{
	  	  gradient y
	  	  color_map { 
	  	  	[0.0 MidnightBlue] 
	  	  	[1.0 CornflowerBlue*2] 
	  	  }
	  	}
	}
	plane{
		y,
		-0.1
		pigment {color rgb <0,0.5,0.5>}
	}
		camera
		{
			//up y
			//right 6/4*x
	  		location  <-30.0 , 10.0 , -30.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-30, 60, -30>   // <x y z> position of light
	}
	
	background {color <1,1,1>}
#end


