// Persistence of Vision Ray Tracer Scene Description File
// File: CityParks.inc
// Vers: 3.1
// Desc: Low detail parks to fill residential courtyards and city blocks.
// Date: 4/9/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

#include "ParkTextures.inc"

#include "SimpleTree.inc"

// Remember 1 is the size of a window wall unit.

#declare RCityParks = seed(0);
#macro MakeDowntownPark(Size)
	// I don't thinkyou wil be able to see these at all, so I'm going to make them very simple.
	box {
		<-Size.x/2,0,-Size.z/2>,
		<Size.x/2,0.1,Size.z/2>
		texture {ParkGrass_T}
	}
#end

#declare ResidentialCourtyardTreesPerUnit2 = 1/10;
#declare ResidentialCourtyardMinTreeSize = 0.5;
#declare ResidentialCourtyardTreeSizeRange = 2;
#macro MakeResidentialCourtyard(Size)
	union {
		box {
			<-Size.x/2,0,-Size.z/2>,
			<Size.x/2,0.1,Size.z/2>
			texture {ParkGrass_T}
		}
		#local Units2 = Size.x*Size.z;
		#local Count = 0;
		#while (Count < Units2*ResidentialCourtyardTreesPerUnit2)
			#local TreeSize = ResidentialCourtyardMinTreeSize + ResidentialCourtyardTreeSizeRange * rand(RCityParks);
			#local TreeTop = (Size - TreeSize/2) * <rand(RCityParks),rand(RCityParks),rand(RCityParks)> - <Size.x/2,0,Size.z/2>;
			sphere {
				TreeTop,
				TreeSize
				MakeLeafSphere_T()
			}
			cylinder {
				<TreeTop.x,0,TreeTop.z>,
				TreeTop,
				0.1
				texture {Bark_T}
			}
			#local Count = Count + 1;
		#end
	}
#end

#if (Render = 1)
	global_settings {ambient_light 3}
	#include "colors.inc"
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	 	pigment
	  	{
	  	  gradient y
	  	  color_map { 
	  	  	[0.0 MidnightBlue] 
	  	  	[1.0 CornflowerBlue*2] 
	  	  }
	  	}
	}
	
	object {
		MakeResidentialCourtyard(<20,3,15>)
		translate <-10,0,0>
	}
	
	plane{
		y,
		0
		pigment {color rgb <0,0.5,0.5>}
	}
	camera
	{
	  location  <0, 20 , 20>
	  look_at   <0 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-100 , 50 , -50>
	}
	
	background {color <1,1,1>}
#end


	
