// Persistence of Vision Ray Tracer Scene Description File
// File: Floor.inc
// Vers: 3.1
// Desc: Creates some very nice floor boards.  <grin>
// Date: 3/18/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end



#ifndef (RoomWidth)
	#declare RoomWidth = 12*12;
#end
#ifndef (RoomDepth)
	#declare RoomDepth = 12*12;
#end
#ifndef (RoomHeight)
	#declare RoomHeight = 8*12;
#end

#local RBoardTexture = seed(0);

#if (Detail_Level > 6)
	// this is a fairly costly many layered texture.
	#macro FloorBoardTexture()
		#local Rotate = (<rand(RBoardTexture),rand(RBoardTexture),rand(RBoardTexture)>-.5) * 20;
		#local Translate = (<rand(RBoardTexture),rand(RBoardTexture),rand(RBoardTexture)>-.5);
		#local Scale = <10,2,0.5>;
		#local Brightness = 1+rand(RBoardTexture)/5;
		#local ColorBlend1 = rand(RBoardTexture);
		#local ColorBlend2 = rand(RBoardTexture);
		#local ColorBlend3 = rand(RBoardTexture);
		texture {
			pigment {
				wood
				turbulence 0.1 // should have some!
				color_map { [0.00 color (<254,219,125>*ColorBlend1 + <248,185, 94>*(1-ColorBlend1))/256 * Brightness]
							[0.10 color (<236,162, 67>*ColorBlend2 + <216,124, 65>*(1-ColorBlend2))/256 * Brightness] 
							[0.95 color (<140, 91, 60>*ColorBlend3 + <164, 98, 51>*(1-ColorBlend3))/256 * Brightness]
							[1.00 color <109, 87, 58>/256 * Brightness]} // optional color map
				rotate 90*y
				scale Scale
				rotate Rotate
				translate Translate
			}
			normal {
				wood
				turbulence 0.1 // should have some!
				rotate 90*y
				scale Scale
				rotate Rotate
				translate Translate
			}
		}
		// cross grain
		texture {
			pigment {
				wood
				turbulence 0.3 // should have some!
				color_map { [0.00 color rgbt (<254,219,125,0>*ColorBlend1 + <248,185, 94,0>*(1-ColorBlend1))/256 * Brightness + <0,0,0,0.6>]
							[0.10 color rgbt (<236,162, 67,0>*ColorBlend2 + <216,124, 65,0>*(1-ColorBlend2))/256 * Brightness + <0,0,0,0.6>] 
							[0.95 color rgbt (<140, 91, 60,0>*ColorBlend3 + <164, 98, 51,0>*(1-ColorBlend3))/256 * Brightness + <0,0,0,0.6>]
							[1.00 color rgbt <109, 87, 58,0>/256 * Brightness + <0,0,0,0.6>]} // optional color map
				frequency 8
				rotate 90*y
				scale Scale
				rotate Rotate+75*y
				translate Translate
			}
		}	

		// Dust & Varnish layer
		texture {
			pigment {        
				granite       
				color_map {          
					[0.0 rgb <.2, 0, 0> ]          
					[0.2 rgb <.7,.7,.7> ]          
					[0.2 rgbt <1, 1, 1, 1> ]          
					[1.0 rgbt <1, 1, 1, 1> ]        
				}        
				frequency 16      
			}  
			finish {
				phong 0.75
				phong_size 200
			}  
		}
	#end
#else
	#macro FloorBoardTexture()
		texture {
			pigment {
				color rgb <236,162, 67>/256
			}
		}
	#end
#end

#local RoomSize = <RoomWidth,RoomHeight,RoomDepth>;
#local MeanBoardZ = 5;
#local RangeBoardZ = 2;
#local MeanBoardX = 6*12;
#local RangeBoardX = 3*12;
#local MeanBoardY = 1/2;
#local RangeBoardY = 0;
#local MeanBoardSize = <MeanBoardX,MeanBoardY,MeanBoardZ>;
#local RangeBoardSize = <RangeBoardX,RangeBoardY,RangeBoardZ>;
#local MeanBoardGapX = 1/8;
#local RangeBoardGapX = 1/16;
#local MeanBoardGapZ = 1/8;// 1/16;
#local RangeBoardGapZ = 1/16;

#local NailLengthSpacing = 1*12;
#local NailPosition = <0.5,0.5>;

#local RBoardSize = seed(1);

#local Position = <0,0,0>;

union {
	#while (Position.z < RoomSize.z)
		#local BoardSizeZ = MeanBoardSize.z + RangeBoardSize.z * 2 * (rand(RBoardSize) - 0.5);
		#while (Position.x < RoomSize.x)
			#local BoardSizeY = MeanBoardSize.y + RangeBoardSize.y*2*(rand(RBoardSize)-0.5);
			#local BoardSizeX = MeanBoardSize.x + RangeBoardSize.x*2*(rand(RBoardSize)-0.5);
				
			#local GapX = MeanBoardGapX + RangeBoardGapX * 2 * (rand(RBoardSize)-0.5);
			#local GapZ = MeanBoardGapZ + RangeBoardGapZ * 2 * (rand(RBoardSize)-0.5);
			box {
				<0,0,0>,
				<BoardSizeX,BoardSizeY,BoardSizeZ>
				FloorBoardTexture()
				translate Position+<GapX,0,GapZ>
			}
			
			#local Position = Position + <BoardSizeX+GapX, 0, 0>;
		#end
		#local Position = <0, 0, BoardSizeZ+Position.z+MeanBoardGapZ>;
	#end

	translate <-RoomSize.x/2,-MeanBoardY,-RoomSize.z/2>
}


#if (Render = 1)
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <-50, 40, -10>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <0, 40, -50>
}
/*		camera
		{
	  		location  <-30.0 , 10.0 , -30.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
*/		
#local view = 2
#if (view = 2)
	box {
		<-100,-10,30>,
		< 100, 100,3>
		pigment { color <1,1,1>}
	}
	camera
		{
	  		location  <0.0 , 3.0 , -5.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
#end
#end
