// Persistence of Vision Ray Tracer Scene Description File
// File: Fountain.inc
// Vers: 3.1
// Desc: Creates a fountain.  Has code to generate water arcs given 
//        start point, stop point and height.
// Date: 3/21/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


//#local Render = 1;

#declare T_FountainWater = texture {
	pigment {
		bozo
		color_map {
			[0.0 color rgbf <0.0,0.7,0.8,0.6>]
			[0.3 color rgbf <0.0,0.7,1.8,0.9>]
			[0.6 color rgbf <0.0,0.3,0.8,0.7>]
			[0.9 color rgbf <0.0,0.7,0.3,0.6>]
		}
		scale 0.5
	}
	normal {
		bozo 2
		scale 0.5
	}
	finish {
		reflection 0.3
	}
}
#declare T_FountainDrop = texture {
	pigment {
		bozo
		color_map {
			[0.0 color rgbf <0.7,0.8,0.9,0.8>]
			[0.5 color rgbf <0.8,0.9,1.0,0.8>]
		}
	}
	normal {
		bozo 0.5
	}
	finish {
		reflection 0.5
		ambient 0.3
	}
}

#declare T_FountainStone1 = texture {
	pigment {
		granite 
		color_map {
			[0.0 color <0.0,0.0,0.0>]
			[0.3 color <0.7,0.7,0.7>]
			[0.6 color <0.4,0.6,0.3>]
			[0.8 color <0.8,1.0,0.8>]
		}			
	}
	normal {
		granite
	}
}
		// mossy granite is too dark, it blends into the bushes
		// try something peachyer
#declare T_FountainStone = texture {
	pigment {
		marble 
		turbulence 1
		color_map {
			[0.0 color <1.0,0.3,0.0>]
			[0.1 color <1.0,0.5,0.3>]
			[0.3 color <1.0,0.7,0.7>]
			[0.7 color <1.0,.95,.95>]
		}
		
	}
	normal {
		marble 0.01
		turbulence 1
	}
}

#declare Fountain = union {
	// fountain
	lathe {
		quadratic_spline
		16
		<0.0,0.0>,<3.5,0.0>,<3.5,0.0>,<2.0,2.0>,<3.0,3.5>,<5.0,4.0>,
		<6.0,5.0>,<6.5,6.5>,<5.0,5.0>,<2.0,4.0>,<0.5,5.0>,<0.5,6.0>,<1.0,7.0>,
		<2.0,8.0>,<2.0,8.0>,<0.0,7.0>
		texture {T_FountainStone}
	}
	
			
	// bottom fountain water
	lathe {
		linear_spline
		5
		<5.5,5.5>,<2.0,4.0>,<0.0,4.0>,<0.0,5.5>,
		<5.5,5.5>
		texture {T_FountainWater}
	}
	
	// top fountain water
	lathe {
		linear_spline
		4
		<1.0,7.5>,<0.0,7.5>,<0.0,7.0>,<1.0,7.5>
		texture {T_FountainWater}
	}
	
	#local FountainScale = 2/6;
	#local NumSprays = 13;
	#local SprayStart = <0.5,5.5,0>;
	#local SprayHeight = 10;
	#local SprayEnd = <4.0,6.0,0>;
	#local x1 = SprayStart.x;
	#local x2 = SprayEnd.x;
	#local y1 = SprayStart.y;
	#local y2 = SprayEnd.y;
	#local h  = SprayHeight;
	#local a = (-2*h+y1+y2-2*sqrt(h*h-h*y1-h*y2+y2*y1))/((-x2+x1)*(-x2+x1));
	#local b = (-x1*y2+x1*y1-x1*(-2*h+y1+y2+2*sqrt(h*h-h*y1-h*y2+y2*y1))+y2*x2-y1*x2-x2*(-2*h+y1+y2-2*sqrt(h*h-h*y1-h*y2+y2*y1)))/((-x2+x1)*(-x2+x1));
	#local c = (x2*x2*y1-y1*x2*x1+y2*x1*x1-x1*y2*x2+x1*x2*(-2*h+y1+y2-2*sqrt(h*h-h*y1-h*y2+y2*y1)))/((-x2+x1)*(-x2+x1));
	#debug str(a,3,3)
	#local SprayCount = 0;
	#local deltaX = 0.05;
	#local blobSize = 0.1;
	#local RSpray = seed(0);
	#while (SprayCount < NumSprays)
		#local X = SprayStart.x + rand(RSpray)*deltaX; // so the arcs aren't all defined in exactly the same places.
		//blob {
		//	threshold 0.35
			#while (X < SprayEnd.x)
				sphere {
					<X,a*X*X+b*X+c,0> + blobSize*(<rand(RSpray),rand(RSpray),rand(RSpray)>-0.5)
					blobSize
					//1
			rotate y* SprayCount * 360 / NumSprays
			translate 2*y
			texture {T_FountainDrop}
				}
				#local X = X+deltaX;
			#end
		//}

		#local SprayCount = SprayCount + 1;
	#end
	
	scale FountainScale

}

#if (Render = 1)

object {Fountain}
// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}

#include "colors.inc"
#include "woods.inc"
plane {
	y,
	0
	pigment {Brown}
}


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <-50, 40, -10>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <0, 40, -50>
}
/**/		
#local view = 3;
#switch (view)
	#case (2)
		box {
			<-100,-10,30>,
			< 100, 100,3>
			pigment { color <1,1,1>}
		}
		camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
		#break
	#case (1)
		camera
		{
	  		location  <0.0 , 3.0 , -4.0>
	  		look_at   <0.0 , 2.0 , 0.0>
		}
		#break	
	#case (3) // Scene camera angle
		camera
		{
			//up y
			//right 6/4*x
	  		location  <-7.0 , 4 , -7.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
		#break
#end
#end // if render
