// Persistence of Vision Ray Tracer Scene Description File
// File: House.inc
// Vers: 3.1
// Desc: Constructs a wood block house
// Date: 3/19/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#declare HouseBase1 = superellipsoid {
	<0.1,0.1>
}

#declare HouseCut1 = superellipsoid {
	<0.01,3>
	rotate <0,0,0>
}

#declare HouseBase2 = difference {
	object {HouseBase1}
	object {
		HouseCut1 
		scale <1/3,1/2,1>*1.3
		translate <0,-1/2,-1>
	}
	box {
		0.9*< 1/3, 0, 1.5>,
		0.9*<-1/3,-1.5,-1.5>
	}
		
}

#declare HouseRoof1 = intersection {
	superellipsoid {
		<0.1,0.1>
		translate 1*y
		scale  1.41
	}
	superellipsoid {
		<0.1,0.1>
		rotate 45*z
	}
	scale <1/1.41,1/1.41,1>
}

#declare HouseFiller1 = superellipsoid{
	<0.1,0.1>
	scale <1/3,1/2,1>
	translate <0,-1/2,0>
}

#declare RHouseColor = seed(2);

#include "MyWoodTextures.inc"

#declare LastHouseColor = 0;
#macro HouseColor ()
	#local r = floor((rand(RHouseColor)*0.999)*4);
	#if (r=LastHouseColor)
		#local r = mod(LastHouseColor+1,4);
	#end
	#declare LastHouseColor = r;
	
	#switch (r)
		#case (0)
			DyedWoodLight_T(<0.1,0.55,0.1>)
			#break
		#case (1)
			DyedWoodLight_T(<0.2,0.2,0.75>)
			#break
		#case (2)
			DyedWoodLight_T(<0.75,0.1,0.1>)
			#break
		#case (3)
			DyedWoodLight_T(<0.95,0.95,0.1>)
			#break
	#end
#end

#declare RHousePos = seed(1);

#macro MakeHouse()
	object {
		HouseFiller1
		HouseColor()
		translate (rand(RHousePos)-0.5)*0.4*z
	}
	object {
		HouseBase2
		HouseColor()
	}
	object {
		HouseRoof1
		HouseColor()
		translate y
		rotate (rand(RHousePos)-0.5)*20*y
		translate <(rand(RHousePos)-0.5)*0.2,0,(rand(RHousePos)-0.5)*0.2 >
	}
	translate 1*y
	rotate (rand(RHousePos)-0.5)*20*y
#end

#declare RGroupPos = seed(0);
#declare RHouseExist = seed(1);
#macro MakeHouseGroup(XDim,YDim,Prob,Jitter)
	#local X = 0;
	#while (X < XDim)
		#local Y = 0;
		#while (Y < YDim)
			#if (rand(RHouseExist) < Prob)
				union {
					MakeHouse()
					rotate floor(rand(RGroupPos)*2)*90*y
					translate X*x*3+Y*z*3 + <rand(RGroupPos)-0.5,0,rand(RGroupPos)-0.5>*Jitter*2
				}
			#end
			#local Y = Y+1;
		#end
		#local X = X + 1;
	#end
#end

#if (Render = 1)
	#include "colors.inc"
	
	MakeHouseGroup(10,10,0.5,0.5)

	camera
	{
	  location  <0,4,-5>
	  //right <16,0,0>
	  //up <12,0,0>
	  look_at   <10,0,10>
	}
	global_settings {ambient_light 3}
	background{Green}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.5  // light's color
	  translate <0, 15, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.5  // light's color
	  translate <0, 15, 0>
	}
#end
