// Persistence of Vision Ray Tracer Scene Description File
// File: Imagined.pov
// Vers: 3.1
// Desc: Top level scene file for The City Imagined
// Date: 4/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights and objects
	#local Render = 1;
#else
	#local Render = 0;
#end

// 0-10
#declare Detail_Level = 10;

global_settings { ambient_light <1,1,1>*1}



#declare RoomWidth = 12*12;
#declare RoomDepth = 12*12;
#declare RoomHeight = 8*12;

#include "Room.inc"
	
#declare View = 1;
#switch (View)
	#case (0)
		camera
		{
		  location  <0.0 , 100.0 , 0.0>
		  look_at   <0.0 , 0.0 , 0.0>
		  rotate 180*y
		  orthographic
		}
		light_source
		{
			<0,100,0>
			color White
		}
		#break
	#case(3)
		camera
		{
			 location <-6.5,TrackRiserHeight+2,-23.5>
		 	 look_at <-4.5,TrackRiserHeight,-21.5>
		}
		#break
	#case (1)
		camera
		{
			up y
			right 6/4*x
	  		location  <-30.0 , 10.0 , -30.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
		#break
	#case (2)
		camera
		{
	  		location  <0.0 , 10.0 ,-100.0>
	  		look_at   <0.0 , 0.0 ,100.0>
		}
		#break	
#end

#if (Detail_Level < 10)
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.65 // light's color
	  translate <-50, 40, -10>
	}
	
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.65 // light's color
	  translate <0, 40, -50>
	}
#else
	// Detail level 10 only, this is full out.
	// An area light (creates soft shadows)
	// WARNING: This special light can significantly slow down rendering times!
	light_source
	{
	  0*x // light's position (translated below)
	  color rgb 0.70*2  // light's color
	  // <widthVector> <heightVector> nLightsWide mLightsHigh
	  area_light
	  <0, 20, 0> <0, 0, 20> // lights spread out across this distance (x * z)
	  3,3                // total number of lights in grid (4x*4z = 16 lights)
	  adaptive 0          // 0,1,2,3... 
	  jitter              // adds random softening of light
	  translate <-30, 60, -30>   // <x y z> position of light
	}
#end

background {White}

#include "House.inc"
union {
	MakeHouseGroup(4,4,0.3,0.25)
	translate <7,0,-25>
}
union {
	MakeHouseGroup(3,3,0.3,0.50)
	translate <-10,0,-20>
}

#declare RHouseExist = seed(0);
//#declare RHouseColor = seed(4);
union {
	MakeHouseGroup(3,4,0.3,0.50)
	translate <2,0,3>
}
union {
	MakeHouseGroup(3,3,0.3,0.50)
	translate <2,0,20>
}
#declare RHouseExist = seed(0);
union {
	MakeHouseGroup(4,4,0.3,0.50)
	translate <-15,0,33>
}

#include "City.inc"
object {
	City
	scale 3/4
	translate <40,0.01,-34>
}

union {
	#include "Park.inc"
	scale 5/12
	//translate <-10,0,ParkSize.z*5/12+3>
	translate <10,0,-10>
}

#include "WoodCutOutTrees.inc"
union {
	MakeWoodCutOutTreeForest(7,10,0)
	translate <-10,0,ParkSize.z*5/12+3>
	//translate <10,0,-10>
}
union {
	MakeWoodCutOutTreeForest(10,20,0)
	translate <10,0,-25>
}
union {
	MakeWoodCutOutTreeForest(10,20,0)
	translate <-30,0,10>
}

#include "ParkTextures.inc"
#include "Residential.inc"
object {
	MakeResidentialBlock(<16,2.5,14>)
	scale 3/4
	translate <19,0,9>
}
object {
	MakeResidentialBlock(<16,2.5,14>)
	scale 3/4
	translate <19,0,39>
}


// The whole train mess.
union {
	#include "TrackScene2.inc"
	translate -10*x
}

#include "skies.inc"
sky_sphere {
	S_Cloud1
}

// My ocean background
	plane{
		y,
		-1
		texture {
			// waves in the ocean
			pigment {
				bozo
				color_map {
					[0.00 color rgb <0,0.4,0.4>]
					[0.90 color rgb <0,0.3,0.8>]
					[1.00 color rgb <1,1,1>]
				}
				triangle_wave
			}
			// normals on top layer only...
			finish {
				ambient 0.1
				reflection 0.3
				phong 0.6
				phong_size 150
			}	
		}
		texture {
			// waves in the ocean
			pigment {
				bozo
				color_map {
					[0.00 color rgbt <1,1,1,1>]
					[0.90 color rgbt <1,1,1,1>]
					[1.00 color rgbt <1,1,1,0>]
				}
				triangle_wave
			}
			normal {
				bozo
				sine_wave
			}
			finish {
				ambient 0.8
				reflection 0.1
				phong 0.6
				phong_size 150
			}	
		}
	}

