// Persistence of Vision Ray Tracer Scene Description File
// File: Industrial.inc
// Vers: 3.1
// Desc: Light industry, warehouses
// Date: 3/29/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

#declare RIndustrial = seed(0);
#local Clear   = rgbt 1;

#declare IndustrialPaintColors = array[16] {
	<206,203,180>/256, <233,226,172>/256, <231,232,214>/256, <168,159,107>/256,
	<182,176,105>/256, <155,115,073>/256, <178,181,177>/256, <216,233,245>/256,
	<113,137,145>/256, <195,152,089>/256, <242,231,200>/256, <254,217,160>/256,
	<120,132,121>/256, <051,046,041>/256, <096,088,062>/256, <231,197,091>/256}

//#local AwningColor = AwningColors[floor(rand(RAwning)/1.001*4)];

#macro IndustrialColor()
	#declare TheColor = color rgb IndustrialPaintColors[floor(rand(RIndustrial)/1.001*16)]
							+(<rand(RIndustrial),rand(RIndustrial),rand(RIndustrial)>-0.5)/10;
#end

#macro Industrial_1(Size)
	// round is equivalent to floor(y+0.5)
	#declare Size = <div(Size.x-1,10/4)*10/4+1,floor(Size.y-1/4+0.5)+1/4,div(Size.z-1,10/4)*10/4+1>; // x,z needs to be k*10/4+1/4, y = k+1/4
	union {
		IndustrialColor()
		box {
			<0,0,0>
			Size // x,z needs to be k*10/4+1/4
			
			texture{ pigment { gradient y scale 1/4 color_map {[0.00 TheColor][0.10 TheColor][0.10 Clear][1.00 Clear]}}}
			texture{ pigment { gradient x scale 1/4 rotate 45*y color_map {[0.00 TheColor][0.10 TheColor][0.10 Clear][1.00 Clear]}}}
			texture{ pigment { gradient y scale 1 color_map {[0.00 TheColor][0.33 TheColor][0.33 Clear][1.00 Clear]}}}
			texture{ pigment { gradient x scale 10/4 rotate 45*y color_map {[0.00 TheColor][0.10 TheColor][0.10 Clear][1.00 Clear]}}}
			hollow on
			translate -<Size.x,0,Size.z>/2
			scale 1
			clipped_by { plane { y, Size.y-0.05}}
		}
		box {
			<-Size.x/2+0.5,          0, -Size.z/2+0.5>,
			< Size.x/2-0.5, Size.y-0.5,  Size.z/2-0.5>
			pigment {rgb <0.9,0.9,0.9>}
		}
		
		Industrial_Roof(<Size.x,Size.y-0.25,Size.z>)
	}
#end

#declare GoodIndustrialSkylight = box {
	0,
	1.1
	texture{ pigment { gradient x scale 1/4 color_map {[0.00 rgb <1,1,1>][0.20 rgb <1,1,1>][0.20 rgbt <0,0,0,0.5>][1.00 rgbt <0,0,0,0.5>]}} finish {reflection 0.8 ambient 0 diffuse 0}}
	//pigment {rgb <1,1,1>}
	translate -0.5
	scale <1,0.5,1>
	rotate 45*x
}
#declare IndustrialSkylight = box {
	0,
	1.1
	texture{ pigment { gradient x scale 1/4 color_map {[0.00 rgb <1,1,1>][0.20 rgb <1,1,1>][0.20 rgbt <0,0,0,0.5>][1.00 rgbt <0,0,0,0.5>]}}}
	//pigment {rgb <1,1,1>}
	translate -0.5
	rotate 45*x
	scale <1,0.5,1>
}

#declare IndustrialRoofColors = array[19] {
	<104,096,065>/256, <115,101,075>/256, <098,084,074>/256, <101,093,074>/256, 
	<064,059,053>/256, <113,101,086>/256, <143,151,145>/256, <105,090,067>/256, 
	<117,104,083>/256, <135,140,133>/256, <123,117,090>/256, <078,063,045>/256, 
	<128,112,086>/256, <132,123,086>/256, <110,090,070>/256, <117,105,086>/256, 
	<108,096,072>/256, <110,093,067>/256, <051,037,025>/256}
#macro Industrial_Roof(Size)
	plane {
		y,
		Size.y
		clipped_by { box {<-Size.x/2,Size.y-1,-Size.z/2>, <Size.x/2,Size.y+1,Size.z/2>}}
		#local RoofColor = color rgb (IndustrialRoofColors[floor(rand(RIndustrial)/1.001*19)]
							+(<rand(RIndustrial),rand(RIndustrial),rand(RIndustrial)>-0.5)/10);
		texture {pigment {granite color_map { [0 RoofColor-0.3] [1 RoofColor+0.1]} scale 1/10}}
		texture {pigment {bozo translate rand(RIndustrial)*10 color_map { [0.25 color rgbt <1,1,1,1>] [1 color rgbt <0,0,0,0.5>]} scale 3}}
	}
	#if (rand(RIndustrial) > 0.5) 
		#local XNum = ceil(rand(RIndustrial)*4);
		#local ZNum = ceil(rand(RIndustrial)*4);
		#local TheObject = object {IndustrialSkylight translate Size.y*y}
		PlaceObjects(TheObject, XNum, ZNum, Size.x, Size.z)
 	#end
 #end

#macro PlaceObjects(InObject, XNum, YNum, XSpread, YSpread)
	#local X = -XNum/2;
	#while (X < XNum/2)
		#local Y = -YNum/2;
		#while (Y < YNum/2)
			object {
				InObject
				translate X*x*XSpread/XNum+Y*z*YSpread/YNum + <XSpread/XNum/2,0,YSpread/YNum/2>
			}
			#local Y = Y+1;
		#end
		#local X = X + 1;
	#end
#end

#include "Building1.inc"

#macro MakeIndustrialBuilding(BuildingSize)
	#local Pick = floor(rand(RIndustrial)*0.9999*5);
	//#local Pick = 1;
	#switch (Pick)
		#range (0,3)
			object {
				Industrial_1(BuildingSize)
			}
			#break
		#case (4)
			object {
				MakeBuilding1(BuildingSize)
			}
			#break
		#else
			box {0,1 pigment {rgb <1,0,0>}}
	#end
#end

#macro MakeIndustrialBlock(BlockSize)
		#local NumX = ceil(BlockSize.x/(8+6*rand(RIndustrial)));
		#local NumZ = ceil(BlockSize.z/(8+6*rand(RIndustrial)));
	#if ((NumX > 1) | (NumZ > 1))	
		union {
	#end
		#local CountX = 0;
		#while (CountX < NumX)
			#local CountZ = 0;
			#while (CountZ < NumZ)
				object {
					#declare BuildingSize = <BlockSize.x/NumX,BlockSize.y+4*(rand(RIndustrial)-0.75),BlockSize.z/NumZ>;
					MakeIndustrialBuilding(BuildingSize)
					translate -<BlockSize.x,0,BlockSize.z>/2 + <BuildingSize.x,0,BuildingSize.z>/2 + <CountX/NumX*BlockSize.x,0,CountZ/NumZ*BlockSize.z>
				}
				#local CountZ = CountZ + 1;
			#end
			#local CountX = CountX + 1;
		#end
	#if ((NumX > 1) | (NumZ > 1))	
		}	
	#end
#end


//#declare AwningColors = array[4] {<1,0,0>,<1,1,0>,<0,1,0>,<0,0,1>}
//#local AwningColor = AwningColors[floor(rand(RAwning)/1.001*4)];


#if (Render = 1)
	#declare BlockSize = <20,10,20>;
	#local X = -20;
	#while (X < 20)
		#local Y = -20;
		#while (Y < 20)
			object {
				MakeIndustrialBlock(BlockSize)
				//#debug concat(str(BlockSize.y,3,3)," ")
				#declare BlockSize = <20,10,20>;
				translate X*x*25+Y*z*25
			}
			#local Y = Y+1;
		#end
		#local X = X + 1;
	#end

	global_settings {ambient_light 3}
	#include "colors.inc"
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	 	pigment
	  	{
	  	  gradient y
	  	  color_map { 
	  	  	[0.0 MidnightBlue] 
	  	  	[1.0 CornflowerBlue*2] 
	  	  }
	  	}
	}
	plane{
		y,
		0
		pigment {color rgb <0,0.5,0.5>}
	}
	camera
	{
	  location  <0, 20 , -80>
	  look_at   <0 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-100 , 40 , -50>
	}
	
	background {color <1,1,1>}
#end


