// Persistence of Vision Ray Tracer Scene Description File
// File: MyTextures.inc
// Vers: 3.1
// Desc: My textures
// Date: 4/19/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end


// looks more like shiny graphite...
#declare ShinySteel_T = texture {
	pigment {color <204,210,215>/230}
	normal {dents 0.6 scale 1/20}// dented surface (0...1) [0.0]}

	finish {
		metallic on // on/off
		reflection 0.2
		specular 0.8
		brilliance 8
		roughness 0.000005
	}
}

#declare ShinySteel2_T = texture {
	pigment {color <0.9 0.9 0.9>}
	normal {dents 0.6 }// dented surface (0...1) [0.0]}
	finish {
		metallic on // on/off
		brilliance 7
		specular 1.0
		roughness 0.0005
		reflection 0.4
	}
}

#macro SparkleEnamel_T(Color)
	texture {
		pigment {
			granite
			scale 1/200
			color_map {[0.0 Color*0.5][0.4 Color][0.8 Color][0.8 Color *1.1]}
		}
		finish {
			metallic on // on/off
			reflection 0.25
			specular 0.8
			roughness 0.000005
			brilliance 2
		}
	}
	texture {
		pigment {
			granite
			scale 1/200
			color_map {[0.0 rgbt <1,1,1,1>][0.80 rgbt <1,1,1,1>][0.80 Color][1.0 Color]}
		}
		finish {
			ambient 4
		}
	}
#end

#declare Glass_T = texture{ 
	pigment { rgbt <0.95,0.95,1.0,0.95>}
	finish {specular 0.80 roughness 0.00005 reflection 0.15}
}

#declare Invisible_T = texture {
	pigment {rgbt <1,1,1,1>}
}

#declare RoofTar_T = texture {
	pigment {
		bozo 
		color_map {
			[0.0 color rgb <0.2,0.2,0.2>]
			[0.7 color rgb <0.3,0.3,0.3>]
			[1.0 color rgb <0.5,0.5,0.5>]
		}
		triangle_wave
		scale 1/5
	}
}

#macro MakeGravel_T(Color) 
	texture {
		pigment {
			granite 
			color_map {
				[0.0 color rgb Color/1.2]
				[0.7 color rgb Color]
				[1.0 color rgb Color*1.3]
			}
			triangle_wave
		}
		normal {
			granite 
		}
		finish {
			ambient 0.2
			brilliance 1
			specular 0.2
			roughness 1
		}
		scale 1/5
	}
#end

#declare Aluminum_T = texture {
	pigment {color rgb <0.92,0.95,1.0>}
	normal {
		dents
		scale 1/50
	}
	finish {
     	reflection 0.25
 	  	ambient 0.30
     	diffuse 0.5
 	  	brilliance 2
    	metallic
    	specular 0.70
    	roughness 0.00005
	}
}


#macro MakeEnamel_T(Color)
	texture {
		pigment {Color}
		normal {
			granite 0.025
			scale 1/10
		}	
		finish {
			brilliance 5
			specular 0.9
			roughness 0.005
		}
	}
#end


#macro MakePlastic_T(Color)
	texture {
		pigment {Color}
		finish {
			brilliance 3
			specular 0.6
			roughness 0.05 // default 'plastic'	
		}
	}
#end



#if (Render = 1)

	// Featured object(s)
	sphere{ <0,0,0>,1
		texture {ShinySteel_T}
	}
	sphere{ <2,0,0>,1
		//SparkleEnamel_T(color rgb <1,0.3,0.1>)
		texture {ShinySteel2_T}
	}
	sphere{ <-2,0,0>,1
		MakeGravel_T(<0.4,0.3,0.5>)
		//texture {Glass_T}
	}
	sphere{ <-4,0,0>,1
		texture {Glass_T}
	}



	global_settings {ambient_light 2}
	#include "colors.inc"
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	 	pigment
	  	{
	  	  gradient y
	  	  color_map { 
	  	  	[0.0 MidnightBlue] 
	  	  	[1.0 CornflowerBlue*2] 
	  	  }
	  	}
	}
	
	plane{
		y,
		-1
		pigment {color rgb <0,0.5,0.5>}
	}
	camera
	{
	  location  <0, 4 , -7>
	  look_at   <0 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-5 , 7 , -5>
	}
	
	background {color <1,1,1>}
#end

