// Persistence of Vision Ray Tracer Scene Description File
// File: MyWoodTextures.inc
// Vers: 3.1
// Desc: Separated out common macro wood textures
// Date: 3/26/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end


#declare RTexture = seed(0);

#if (Detail_Level > 5)
	#macro DyedWood_T(Color)
		texture {
			pigment {
				wood
				turbulence 0.1
				color_map {
					[0.00 color 1.0*Color]
					[0.80 color 0.8*Color]
					[1.00 color 0.6*Color]
				}
			}
	/*		normal {
				wood 0.5
				turbulence 0.1
			}
	*/		rotate 90*y
			scale <1,0.2,0.2>
			translate (<rand(RTexture),rand(RTexture),rand(RTexture)>-0.5)*5
		}
	#end
#else 
	#macro DyedWood_T(Color)
		texture {
			pigment { color Color}
		}
	#end
#end

#if (Detail_Level > 5)
	#macro DyedWoodLight_T(Color)
		texture {
			pigment {
				wood
				turbulence 0.1
				color_map {
					[0.00 color 1.0*Color]
					[0.80 color 0.98*Color]
					[0.90 color 0.9*Color]
					[1.00 color 0.8*Color]
				}
			}
			normal {
				dents 0.1
				scale 0.3
			}
			rotate 90*y
			scale <1,0.2,0.2>
			translate (<rand(RTexture),rand(RTexture),rand(RTexture)>-0.5)*5
		}
	#end
#else
	#macro DyedWoodLight_T(Color)
		texture {
			pigment {color Color}
		}
	#end
#end
	
#if (Detail_Level > 5)
	#macro PaintedBoard_T(Color)
		texture {
			normal {
				wood 0.25
				ramp_wave
				rotate 90*x
				turbulence <0.1,0.1,0.1> // should have some!
				frequency 8
				slope_map {
					[0.0  < 0, 0>]
					[0.45  <-.05,-1>]
					[0.5  <-0.25, 0>]
					[0.55  <-.05,1>]
					[1.0  < 0, 0>]
				}
			}
			finish {
				//ambient 0.1
				//diffuse 0.6
				//brilliance 0.2
				phong 0.2
				phong_size 40
			}
			scale <2, 50, 10>
			pigment {color Color}
		}	
	#end
#else
	#macro PaintedBoard_T(Color)
		texture { pigment { color Color}}
	#end
#end

#if (Render = 1)

	box {
		-2,2
		DyedWoodLight_T(<0,1,0>)
		rotate 60*y	
	}
	global_settings {ambient_light 3}
	light_source
	{
		<-10,20,-20>
		color rgb 1
	}

	camera
	{
	  location  <0.0 , 4.0 ,-10.0>
	  look_at   <0.0 , 0.0 , 0.0>
	}
#end
