// Persistence of Vision Ray Tracer Scene Description File
// File: PanneledDoor.inc
// Vers: 3.1
// Desc: A Colonial type door
// Date: 3/15/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



//#local PannelProfile = array[10] {<-10,2>,<-8,2>,<-6,3>,<-6,3.5>,<6,3.5>,<6,3>,<8,2>,<10,2>,<10,0>,<-10,2>}

#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#declare PannelThickness = 1.5;
#local PannelEdge = prism
{
	linear_sweep
	linear_spline
	-1.1,
	1.1,
	8,
	<-3,3.5>,<-2.8,3.5>,<-2.5,3>,<-1,2>,<.1,1.9>,<.1,10>,<-3,10>,<-3,3.5>
	rotate -90*x
	scale <1,PannelThickness/3,1>
}

#macro MakePannel(Height,Width)
	difference {
		// basic pannel Size
		box {
			<-Width/2,-2,-Height/2>
			< Width/2,PannelThickness*1.1, Height/2>
		}
		object {
			PannelEdge
			scale <1,1,Height/2>
			translate Width/2*x
		}
		object {
			PannelEdge
			scale <1,1,Height/2>
			translate Width/2*x
			rotate 180*y
		}
		object {
			PannelEdge
			scale <1,1,Width/2>
			translate Height/2*x
			rotate 90*y
		}
		object {
			PannelEdge
			scale <1,1,Width/2>
			translate Height/2*x
			rotate -90*y
		}
		rotate -90*x
		translate <Width/2,Height/2,0>
	}
#end

#local Molding = prism
{
	linear_sweep
	quadratic_spline
	-1.1,
	1.1,
	10,
	<0.00,0.00>,<0.00,3.00>,<0.75,2.75>,<1.00,2.00>,
	<1.75,1.75>,<2.00,1.00>,<2.75,0.75>,<3.00,0.00>,
	<0.00,0.00>,<0.00,3.00>
	scale <1/3,1,1/3>
	rotate -90*x
	rotate 90*z
	
}

#macro MakeFrame(Height,Width)
	union {
		object {
			Molding
			scale <1,1,Height/2>
			translate Width/2*x
		}
		object {
			Molding
			scale <1,1,Height/2>
			translate Width/2*x
			rotate 180*y
		}
		object {
			Molding
			scale <1,1,Width/2>
			translate Height/2*x
			rotate 90*y
		}
		object {
			Molding
			scale <1,1,Width/2>
			translate Height/2*x
			rotate -90*y
		}
		rotate -90*x
		translate <Width/2,Height/2,0>
		translate -0.9*z
		//pigment {color rgb <1,0,0>}
	}
#end

#local PannelHeight1 = 24;
#local PannelHeight2 = 13;
#local PannelWidth = 11;
#local BorderWidth = 4;
#local DoorBodyHeight = PannelHeight1*2+PannelHeight2+BorderWidth*4;
#local DoorBodyWidth = PannelWidth*2+BorderWidth*3;
#local DoorThickness = 2;
#local FrameWidth = 2;
#local FrameGap = 0.5;
#local FloorGap = 1;

#local DoorColor = <1,1,0.95>;
#include "MyWoodTextures.inc"
#local PaintedBoardTexture = PaintedBoard_T(DoorColor)

#local RTexture = seed(0);

#local DoorBody = union {
	object {
		MakePannel(PannelHeight1,PannelWidth)
		translate <BorderWidth,BorderWidth,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)>*20}
	}
	object {
		MakePannel(PannelHeight1,PannelWidth)
		translate <BorderWidth*2+PannelWidth,BorderWidth,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakePannel(PannelHeight1,PannelWidth)
		translate <BorderWidth,BorderWidth*2+PannelHeight1,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakePannel(PannelHeight1,PannelWidth)
		translate <BorderWidth*2+PannelWidth,BorderWidth*2+PannelHeight1,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakePannel(PannelHeight2,PannelWidth)
		translate <BorderWidth,BorderWidth*3+PannelHeight1*2,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakePannel(PannelHeight2,PannelWidth)
		translate <BorderWidth*2+PannelWidth,BorderWidth*3+PannelHeight1*2,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	// Frame molding
	object {
		MakeFrame(PannelHeight1,PannelWidth)
		translate <BorderWidth,BorderWidth,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)>*20}
	}
	object {
		MakeFrame(PannelHeight1,PannelWidth)
		translate <BorderWidth*2+PannelWidth,BorderWidth,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakeFrame(PannelHeight1,PannelWidth)
		translate <BorderWidth,BorderWidth*2+PannelHeight1,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakeFrame(PannelHeight1,PannelWidth)
		translate <BorderWidth*2+PannelWidth,BorderWidth*2+PannelHeight1,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakeFrame(PannelHeight2,PannelWidth)
		translate <BorderWidth,BorderWidth*3+PannelHeight1*2,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	object {
		MakeFrame(PannelHeight2,PannelWidth)
		translate <BorderWidth*2+PannelWidth,BorderWidth*3+PannelHeight1*2,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}

	// Side Rails
	box {0,<1,1,-1>
		scale <BorderWidth,DoorBodyHeight,DoorThickness>
		translate <0,0,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	box {0,<1,1,-1>
		scale <BorderWidth,DoorBodyHeight,DoorThickness>
		translate <BorderWidth*2+PannelWidth*2,0,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}

	// Horizontal Rails
	box {0,<1,1,-1>
		scale <BorderWidth+PannelWidth*2,BorderWidth,DoorThickness>
		translate <BorderWidth,0,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20
					rotate 90*z}
	}
	box {0,<1,1,-1>
		scale <BorderWidth+PannelWidth*2,BorderWidth,DoorThickness>
		translate <BorderWidth,BorderWidth+PannelHeight1,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20
					rotate 90*z}
	}
	box {0,<1,1,-1>
		scale <BorderWidth+PannelWidth*2,BorderWidth,DoorThickness>
		translate <BorderWidth,BorderWidth*2+PannelHeight1*2,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20
					rotate 90*z}
	}
	box {0,<1,1,-1>
		scale <BorderWidth+PannelWidth*2,BorderWidth,DoorThickness>
		translate <BorderWidth,BorderWidth*3+PannelHeight1*2+PannelHeight2,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20
					rotate 90*z}
	}
	// Vertical Rails
	box {0,<1,1,-1>
		scale <BorderWidth,PannelHeight1,DoorThickness>
		translate <BorderWidth+PannelWidth,BorderWidth,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	box {0,<1,1,-1>
		scale <BorderWidth,PannelHeight1,DoorThickness>
		translate <BorderWidth+PannelWidth,BorderWidth*2+PannelHeight1,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	box {0,<1,1,-1>
		scale <BorderWidth,PannelHeight2,DoorThickness>
		translate <BorderWidth+PannelWidth,BorderWidth*3+PannelHeight1*2,0>
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}

}

#local DoorFrameHeight = DoorBodyHeight+FrameWidth+FrameGap+FloorGap;
#local DoorFrameWidth = DoorBodyWidth + 2*FrameGap + 2*FrameWidth;
#local DoorFrame = union {
	// Left frame
	prism {	
		linear_sweep
		linear_spline
		0,
		+DoorThickness,
		5,
		<0,0>,
		<0,DoorFrameHeight >,
		<FrameWidth,DoorFrameHeight-FrameWidth>,
		<FrameWidth,0>
		<0,0>
		rotate -90*x
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
	prism {	
		linear_sweep
		linear_spline
		0,
		+DoorThickness,
		5,
		<0,DoorFrameHeight>,
		<DoorFrameWidth,DoorFrameHeight>,
		<DoorFrameWidth-FrameWidth,DoorFrameHeight-FrameWidth>,
		<FrameWidth,DoorFrameHeight-FrameWidth>,
		<0,DoorFrameHeight>

		rotate -90*x
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20
			rotate 90*z}
	}
	prism {	
		linear_sweep
		linear_spline
		0,
		+DoorThickness,
		5,
		<DoorFrameWidth-FrameWidth,0>,
		<DoorFrameWidth-FrameWidth,DoorFrameHeight-FrameWidth>,
		<DoorFrameWidth,DoorFrameHeight>,
		<DoorFrameWidth,0>,
		<DoorFrameWidth-FrameWidth,0>
		
		rotate -90*x
		texture {PaintedBoardTexture translate <rand(RTexture),rand(RTexture),rand(RTexture)> *20}
	}
}

#include "metals.inc"
#local DoorKnob = union {
	box {
		<-BorderWidth/3,BorderWidth/2,0>
		< BorderWidth/3,-BorderWidth,-.2>
	}
	sphere {
		<0,0,-2>
		BorderWidth/3
		scale <1,1,0.5>
	}
	cylinder {
		<0,0,-1>
		<0,0,1>
		BorderWidth/6
	}
	texture {T_Brass_4D}
}

#local DoorWidth = DoorFrameWidth;
#local DoorHeight = DoorFrameHeight;

#declare PanneledDoorSize = <DoorWidth,DoorHeight,DoorThickness>;
#declare PanneledDoor = union {
	union {
		object {DoorBody}
		object {
			DoorKnob
			translate <DoorBodyWidth-BorderWidth/2,BorderWidth*1.75+PannelHeight1,-DoorThickness>
		}
		translate <FrameWidth+FrameGap,FloorGap,0>
	}
		
	object {DoorFrame}
	
}

#if (Render)
	object {
		PanneledDoor
		translate <-DoorWidth/2,-DoorHeight/2,0>
	}
	
	sphere {0,1 pigment {color rgb <1,0,0>}}
	
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-40, 100, -100>
	}
	camera
	{
	  location  <0.0 , 0.0 ,-90.0>
	  look_at   <0.0 , 0.0 , 0.0>
	}
#end
