// Persistence of Vision Ray Tracer Scene Description File
// File: Park.inc
// Vers: 3.1
// Desc: Creates a park that fades from toy blocks to 'real'.
// Date: 3/21/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "MyWoodTextures.inc"

/* this is a special park that fades from a realish park to a wood block park. */

#declare ParkSize = <30,10,15>;
#local HedgeSize = <3,2,2>;


#declare SimpleLeafTexture = texture {
	pigment {
		granite
		color_map {
			[0.0 color rgbt <1,1,1,1>]
			[0.35 color rgbt <1,1,1,1>]
			[0.4 color rgb <0.1,0.55,0.1>]
			[0.5 color rgb <0.1,0.55,0.1>]
			[0.55 color rgbt <1,1,1,1>]
		}
	}
	
}

#local HedgePart = superellipsoid{
	<0.2,0.2>
	scale 1/2*HedgeSize
}

#local WoodHedge = object {
	HedgePart
	translate <0,HedgeSize.y/2,0>
	scale 0.9
}

#local Hedge = union {
	object {
		HedgePart
	}
	object {
		HedgePart
		scale 0.9
	}
	translate <0,HedgeSize.y/2,0>
	texture {SimpleLeafTexture}
}

// Hedge half the garden
#local RHedge = seed(0);
#local X = HedgeSize.x;
#local Z = -ParkSize.z/2;
// near hedge
#while (X < ParkSize.x/2)
	object {
		Hedge
		translate <X,0,Z>
	}
	#local X = X + HedgeSize.x;
#end
// right hedge
#while (Z < ParkSize.z/2)
	object {
		Hedge
		rotate 90*y
		translate <X,0,Z>
		
	}
	#local Z = Z + HedgeSize.x;
#end
// far hedge
#while (X > -HedgeSize.x)
	object {
		Hedge
		translate <X,0,Z>
	}
	#local X = X - HedgeSize.x;
#end

// Hedge the other half of the garden
// far hedge
#while (X > -ParkSize.x/2)
	object {
		WoodHedge
		DyedWood_T(<0.1,0.55,0.1>)
		rotate (rand(RHedge)-0.5)*20*y
		translate <X,0,Z>
	}
	#local X = X - HedgeSize.x;
#end
// left hedge
#while (Z > -ParkSize.z/2)
	object {
		WoodHedge
		DyedWood_T(<0.1,0.55,0.1>)
		rotate 90*y
		rotate (rand(RHedge)-0.5)*20*y
		translate <X,0,Z>
	}
	#local Z = Z - HedgeSize.x;
#end
// near hedge
#while (X < 0)
	object {
		WoodHedge
		DyedWood_T(<0.1,0.55,0.1>)
		rotate (rand(RHedge)-0.5)*20*y
		translate <X,0,Z>
	}
	#local X = X + HedgeSize.x;
#end

// lollipop tree
#declare WoodTree = union {
	sphere {
		<0,11,0>
		3
		DyedWood_T(<0.1,0.55,0.1>)
	}
	lathe {
		quadratic_spline
		10
		<0.0, 0.00>, <3.0,0.00>, <3.0,0.00>, <3.0,0.25>, <3.0,0.25>, 
		<2.0, 0.50>, <1.0,1.00>, <0.5,2.00>, <0.5,9.00>, <0.0,9.00>
		rotate 90*z
		DyedWood_T(<0.8,0.6,0.4>)
		rotate -90*z
	}
}

// Make believe trees
object {
	WoodTree
	scale 3/4
	translate <-ParkSize.x/2+3,0,ParkSize.z/2-3>
}
object {
	WoodTree
	rotate 135*y // change visible grain pattern
	scale 3/4
	translate <-ParkSize.x/2+3,0,-ParkSize.z/2+3>
}

// Realish trees
#include "SimpleTree.inc"
//#declare RSimpleTree = seed(10);
union {
	MakeSimpleTree(8,1,0.002)
	scale 1/2
	translate <ParkSize.x/2-3,0,ParkSize.z/2-3>
}
union {
	MakeSimpleTree(8,1,0.002)
	scale 1/2
	translate <ParkSize.x/2-3,0,-ParkSize.z/2+3>
}


#include "Fountain.inc"
object {Fountain
	translate <0,-1,-1>
	scale 1.5}

#local GrassPigment = pigment {
	granite 
	color_map {
		[0.5 color rgb <.3,.6,.2>]
		[1.0 color rgb <.4,1 ,.4>]
	}
	scale 0.01
}

#local GrassNormal = normal {
	granite 3
	scale 0.01
}
	
// Ground, needs to be clear on one side and grassy on the other.
box {
	0,
	ParkSize
	
	texture {
		pigment {
			gradient x
			turbulence <0.2,0.3,0.3>
			pigment_map {
				[0.0 color rgbt <1,1,1,1>]
				[0.2 color rgbt <1,1,1,1>]
				[0.3 granite 
						color_map {
							[0.5 color rgb <.3,.6,.2>]
							[1.0 color rgb <.4,1 ,.4>]}
						scale 0.01]
				[1.0 granite 
						color_map {
							[0.5 color rgb <.3,.6,.2>]
							[1.0 color rgb <.4,1 ,.4>]}
						scale 0.01]
				//[1.0 color rgb <.4,1,.4>]
			}
		}
		normal {
			granite 
			scale 0.01
		}
		scale <ParkSize.x*1.5,1,1>
	}		
	translate -ParkSize/2 - <0,ParkSize.y/2,0> + <0,0.01,0>
}


#if (Render = 1)

// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}

#include "colors.inc"
#include "woods.inc"
plane {
	y,
	0
	texture {T_Wood20}
}


// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <-50, 40, -10>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <0, 40, -50>
}
/**/		
#local view = 3
#switch (view)
	#case (2)
		camera
			{
		  		location  <0.0 , 30.0 , 0.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
		#break
	#case (1)
		camera
		{
	  		location  <0.0 , 10.0 , -20.0>
	  		look_at   <0.0 , 5.0 , 0.0>
		}
		#break
	#case (3) // scene camera
		camera
		{
			//up y
			//right 6/4*x
	  		location  <-30.0 , 10.0 , -30.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
		#break
#end
#end // if render
