// Persistence of Vision Ray Tracer Scene Description File
// File: ParkTextures.inc
// Vers: 3.1
// Desc: Textures for tree spheres and bushes and bark.
// Date: 3/20/00
	// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "colors.inc"

#declare RParkTextures = seed(0);

#macro PickArrayElt(InArray,InRandomStream)
	#local Length = dimension_size(InArray,1);
	(InArray[floor(rand(InRandomStream)*0.999 * Length)])
#end

#declare ATreeColors = array[9] {
	<044,056,033>/100, <047,056,032>/100, <095,098,062>/100, <102,116,081>/100,
	<068,082,041>/100, <057,074,041>/100, <090,103,052>/100, <101,105,052>/100,
	<051,061,035>/100}
/*	<044,046,033>/100, <047,046,032>/100, <095,088,062>/100, <102,106,081>/100,
	<068,072,041>/100, <057,064,041>/100, <090,093,052>/100, <101,095,052>/100,
	<051,051,035>/100}*/

#macro MakeLeafSphere_T()
	#local TheColor = color rgb PickArrayElt(ATreeColors,RParkTextures);
	texture {
		pigment {
			granite
			color_map {
				[0.0 color rgbt <1,1,1,1>]
				[0.3 color rgbt <1,1,1,1>]
				[0.4 TheColor]
				[0.5 TheColor]
				[0.6 color rgbt <1,1,1,1>]
			}
		}
	}
#end

#declare LeafSphere_T = texture {
	pigment {
		granite
		color_map {
			[0.0 color rgbt <1,1,1,1>]
			[0.3 color rgbt <1,1,1,1>]
			[0.4 color rgb <0.1,0.55,0.1>]
			[0.5 color rgb <0.1,0.55,0.1>]//<.4,1,.4>
			[0.6 color rgbt <1,1,1,1>]
		}
	}
}

#declare Bark_T = texture {
	pigment {
		wrinkles
		color_map {
			[0.00 color rgb <0.6,0.4,0.2>]
			[0.20 color rgb <0.6,0.4,0.2>]
			[1.00 color rgb <0.3,0.1,0.0>]
		}
		scale <1/10,1/3,1/10>
	}
	normal {
		wrinkles
		scale <1/10,1/3,1/10>
	}
}

#declare ParkGrass_T = texture {
	pigment {
		granite 
		color_map {
			[0.0 color <0.0,0.6,0.0>]
			[0.3 color <0.2,0.5,0.7>]
			[0.6 color <0.2,0.8,0.4>]
			[0.9 color <0.8,1.0,0.6>]
		}
		triangle_wave
		scale 0.01
	}
}

#if (Render = 1)

	// Featured object(s)
	sphere {
		<-2,0,0>,0.5
		MakeLeafSphere_T()
	}
	sphere {
		<-1,0,0>,0.5
		MakeLeafSphere_T()
	}
	sphere {
		<0,0,0>,0.5
		MakeLeafSphere_T()
	}
	sphere {
		<1,0,0>,0.5
		MakeLeafSphere_T()
	}
	sphere {
		<2,0,0>,0.5
		MakeLeafSphere_T()
	}
	
	global_settings {ambient_light 2}
	
	camera
	{
	  location  <0, 3 , -3>
	  look_at   <0 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-100 , 50 , -50>
	}
	
	background {color <1,1,1>}
#end


