// Persistence of Vision Ray Tracer Scene Description File
// File: Residential.inc
// Vers: 3.1
// Desc: Residential Block builder
// Date: 4/9/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

#include "CityParks.inc"

#declare Sqrt2 = sqrt(2);


#macro PickArrayElt(InArray,InRandomStream)
	#local Length = dimension_size(InArray,1);
	(InArray[floor(rand(InRandomStream)*0.999 * Length)])
#end

#declare RHousePaintColor = seed(0);
#declare NHousePaintColors = 36;
#declare AHousePaintColor = array[NHousePaintColors]
{	<207,191,175>/256, <222,213,177>/256, <208,213,216>/256, <205,207,217>/256,
	<216,215,227>/256, <213,215,216>/256, <197,190,168>/256, <221,206,194>/256,
	<153,146,194>/256, <115,124,107>/256, <143,176,221>/256, <100,103,074>/256,
	<215,217,218>/256, <231,198,110>/256, <230,227,227>/256, <225,214,194>/256,
	<219,217,211>/256, <227,224,239>/256, <178,193,233>/256, <191,186,133>/256,
	<182,155,132>/256, <226,223,206>/256, <175,164,154>/256, <188,192,201>/256,
	<217,218,218>/256, <196,185,159>/256, <225,230,234>/256, <229,233,238>/256,
	<167,159,125>/256, <201,142,110>/256, <215,198,164>/256, <239,240,236>/256,
	<212,207,209>/256, <209,194,167>/256, <231,196,109>/256, <224,217,204>/256}

/*
#macro HousePaintColor ()
	#declare ThePaintColor = color rgb AHousePaintColor[floor(rand(RHousePaintColor)/1.001*NHousePaintColors)]
								+(<rand(RHousePaintColor),rand(RHousePaintColor),rand(RHousePaintColor)>-0.5)/10;
#end
*/

#declare NHouseRoofColors = 26;
#declare AHouseRoofColor = array[NHouseRoofColors] {
	<129,117,080>/256, <192,176,155>/256, <071,062,055>/256, <074,064,069>/256,
	<056,046,042>/256, <054,053,049>/256, <129,104,088>/256, <070,069,062>/256,
	<070,069,059>/256, <152,117,072>/256, <118,095,057>/256, <071,075,051>/256,
	<051,064,038>/256, <137,147,132>/256, <120,123,107>/256, <079,070,074>/256,
	<116,086,062>/256, <071,094,066>/256, <149,125,089>/256, <088,080,087>/256,
	<072,067,065>/256, <112,072,053>/256, <187,115,054>/256, <169,076,045>/256,
	<110,107,130>/256, <138,118,070>/256}

#declare AHouseGravelRoofColor = array[19] {
	<104,096,065>/256, <115,101,075>/256, <098,084,074>/256, <101,093,074>/256, 
	<064,059,053>/256, <113,101,086>/256, <143,151,145>/256, <105,090,067>/256, 
	<117,104,083>/256, <135,140,133>/256, <123,117,090>/256, <078,063,045>/256, 
	<128,112,086>/256, <132,123,086>/256, <110,090,070>/256, <117,105,086>/256, 
	<108,096,072>/256, <110,093,067>/256, <051,037,025>/256}

#declare AWindowColor = array[16] {
	<133,124,110>/256, <127,141,126>/256, <051,055,056>/256, <052,059,057>/256,
	<053,056,047>/256, <095,122,107>/256, <110,133,110>/256, <143,160,167>/256,
	<154,159,144>/256, <150,177,196>/256, <046,057,053>/256, <114,118,077>/256,
	<045,055,044>/256, <173,188,181>/256, <076,078,071>/256, <200,200,200>/256}


#declare WindowFillSize = 20;
// This was originally a patterned texture, but then I realized you can't layer over those...
// which is of course the entire purpose of this texture.. to be the bottom layer. oops.
#declare WindowFill_T = texture {
	pigment {
		gradient y													
		pigment_map {
			#local CountY = 0;
			#while (CountY < WindowFillSize)
				#local Stripe = pigment {
					gradient x
					color_map {
						#local CountX = 0;
						#while(CountX < WindowFillSize)
							#local TheWindowColor = PickArrayElt(AWindowColor,RHousePaintColor);
							[CountX/WindowFillSize color rgb TheWindowColor]
							[(CountX+1)/WindowFillSize color rgb TheWindowColor]
							#local CountX = CountX+1;
						#end
					}
				}
				#local a=1;
				[CountY/WindowFillSize Stripe]
				[(CountY+1)/WindowFillSize Stripe]
				#local CountY = CountY  + 1;
			#end
		}//Pigment map
		rotate 45*y
		scale <1/Sqrt2,1,1/Sqrt2>*WindowFillSize // want window color blocks to be of size 1.
	}
}//Texture

#macro RandomWindowFill_T()
	texture {
		WindowFill_T
		translate <floor(rand(RHousePaintColor)*WindowFillSize),floor(rand(RHousePaintColor)*WindowFillSize),floor(rand(RHousePaintColor)*WindowFillSize)>
	}
#end

// we could also have a parallel RadialWindowFill_T, but the scaling on that would be really
// wierd, and I'm not sure it would be worth it..  Try checker fill first.


#declare RHouse = seed(0);

#declare HipRoof = difference {
	box {
		<-1/Sqrt2,-1/Sqrt2,0>,<1/Sqrt2,1/Sqrt2,6>
		rotate 45*z
	}
	plane {-<0,1,-1>,0}
	plane {-<0,1, 1>,0 translate 6*z}
	plane {y,0}
	scale <1,1,1/3>
	translate <0,0,-1>
}
//object {HipRoof pigment {rgb <0.5,0.5,0.5>} scale 2}

// *******************************************
// Double Bay House
// *******************************************
#macro NBayHouse (Size)
	#local FloorHeight = 0.6;
	#declare Size = <floor(Size.x),div(Size.y-0.5,FloorHeight)*FloorHeight+0.1*FloorHeight,Size.z>;
	#if (Size.x != 0)
		#local RoofHeight = 0.4;
		union {
			#local ThePaintColor = color rgb PickArrayElt(AHousePaintColor,RHousePaintColor)+(<rand(RHousePaintColor),rand(RHousePaintColor),rand(RHousePaintColor)>-0.5)/10;
			#local MuttonColor = rgb <1,1,1>;
			#local Bay = 0;
			#while (Bay < Size.x)
				cylinder {
					<0,0,0>,<0,Size.y/FloorHeight,0>,0.4
					// curtains
					//texture{ pigment { gradient <1,0,1> turbulence 0.1 scale 1/30 color_map{[0.0 rgb <0.5,0.5,0.5>][1.00 rgb <0.7,0.7,0.7>]} sine_wave}}
					RandomWindowFill_T()
					// horizontal muttons
					texture{ pigment { gradient y scale 1/10 color_map {[0.00 MuttonColor][0.10 MuttonColor][0.10 Clear][1.00 Clear]}}
							finish {ambient 0.1 brilliance 1 diffuse 0.5 specular 0.40}}
					// vertical muttons
					texture{ pigment { radial     frequency 24 color_map {[0.00 MuttonColor][0.10 MuttonColor][0.10 Clear][1.00 Clear]}}
							finish {ambient 0.1 brilliance 1 diffuse 0.5 specular 0.40}}
					// vertical wall texture stripes
					texture{ pigment { radial frequency 8  color_map {[0.00 MuttonColor][0.20 MuttonColor][0.20 Clear][1.00 Clear]}}}
					// horizontal wall texture stripes
					texture{ pigment { gradient y scale 1 color_map {[0.00 ThePaintColor][0.3 ThePaintColor][0.3 MuttonColor][0.35 MuttonColor][0.35 Clear][0.95 Clear][0.95 MuttonColor][1.00 MuttonColor]}}}
					scale <1,FloorHeight,1>
					translate <Bay+0.5,0,0.5>
				}
				#local Bay = Bay + 1;
			#end
			box {
				<0,0,0.4>,<Size.x,Size.y,Size.z>
				pigment {ThePaintColor}
			}
			object {
				HipRoof
				scale <Size.x/2,RoofHeight,(Size.z-0.4)/2>
				translate <Size.x/2,Size.y,Size.z/2+0.4/2>
				#local TheRoofColor = color rgb PickArrayElt(AHouseRoofColor,RHousePaintColor);
				texture {pigment {bozo turbulence 1 octaves 1 scale 1/10 rotate rand(RHouse)*360 color_map {[0.0 TheRoofColor/1.2] [1.0 TheRoofColor*1.2]} triangle_wave}}
			}
			//translate <-Size.x/2,0,-Size.z/2>
			//scale 0.5
		}
	#else
		// 0 width object, but we must give an object since it's required by our caller.
		box {0,0 pigment {color rgb <0,0,0>}}
	#end
#end

#include "MyTextures.inc"
// *******************************************
// Flat Topped House
// *******************************************
#macro CubeHouse (Size)
	#local FloorHeight = 0.65;
	#local FloorWidth = 0.5;
	#declare Size = <min(div(Size.x,FloorWidth),3)*FloorWidth,div(Size.y-0.5,FloorHeight)*FloorHeight+0.1*FloorHeight,Size.z>;
	#if (Size.x != 0)
		#local RoofHeight = 0.2;
		difference {
			#local ThePaintColor = color rgb PickArrayElt(AHousePaintColor,RHousePaintColor)+(<rand(RHousePaintColor),rand(RHousePaintColor),rand(RHousePaintColor)>-0.5)/10;
			#local MuttonColor = rgb <1,1,1>-<rand(RHousePaintColor),rand(RHousePaintColor),rand(RHousePaintColor)>/10;
			#local Clabords_T = texture{ pigment {gradient y scale 1/10 color_map{[0 ThePaintColor/1.1][1 ThePaintColor]}} normal{gradient y 0.1 scale 1/10 slope_map{[0 <0,3>][0.1 <0.3 3>][0.1 <0.3, -3/9>][1.0 <0,-3/9>]}} finish{ambient 0.2}}
			#local a = 1;
			#local Window_T = RandomWindowFill_T()
				// horizontal muttons
				texture{ pigment { gradient y scale 1/10 color_map {[0.00 MuttonColor][0.10 MuttonColor][0.10 Clear][1.00 Clear]}}
						finish {ambient 0.1 brilliance 1 diffuse 0.5 specular 0.40}}
				// vertical muttons
				texture{ pigment { gradient x scale 1/10/Sqrt2 rotate 45*y color_map {[0.00 MuttonColor][0.10 MuttonColor][0.10 Clear][1.00 Clear]}}
						finish {ambient 0.1 brilliance 1 diffuse 0.5 specular 0.40 reflection 0.1}}
				//texture{ Glass_T}
			#local WindowStartX = 0.2;
			#local WindowStopX = 0.8;
			#local WindowTBWindowFrameStripe = texture{
				gradient x
				scale <1/Sqrt2,1,1/Sqrt2>
				texture_map {
					[WindowStartX Clabords_T]
					[WindowStartX pigment{MuttonColor}]
					[WindowStopX pigment{MuttonColor}]
					[WindowStopX Clabords_T]
				}
				rotate 45*y
			}
			#local a = 1;
			#local WindowWindowStripe = texture{
				gradient x
				scale <1/Sqrt2,1,1/Sqrt2>
				texture_map {
					[WindowStartX Clabords_T]
					[WindowStartX pigment{MuttonColor}]
					[WindowStartX+0.05 pigment{MuttonColor}]
					[WindowStartX+0.05 Window_T scale <Sqrt2,1,Sqrt2> rotate -45*y]
					[WindowStopX-0.05 Window_T scale <Sqrt2,1,Sqrt2> rotate -45*y]
					[WindowStopX-0.05 pigment{MuttonColor}]
					[WindowStopX pigment{MuttonColor}]
					[WindowStopX Clabords_T]
				}
				rotate 45*y
			}
			box {
				<0,0,0>,<Size.x/FloorWidth,Size.y/FloorHeight,Size.z/FloorWidth>
				texture {
					gradient y
					texture_map {
						[0.00 Clabords_T]
						[0.30 Clabords_T]
						[0.30 WindowTBWindowFrameStripe]
						[0.35 WindowTBWindowFrameStripe]
						[0.35 WindowWindowStripe]
						[0.95 WindowWindowStripe]
						[0.95 WindowTBWindowFrameStripe]
						[1.00 WindowTBWindowFrameStripe]
					}
				}
				scale <FloorWidth,FloorHeight,FloorWidth>
			}
			box {
				<0.05,0,0.05>,
				<0.95,1,0.95>
				//scale <Size.x,0.99,Size.z>
				#local Gravel_T = MakeGravel_T(PickArrayElt(AHouseGravelRoofColor,RHousePaintColor))
								texture {pigment {bozo translate rand(RHousePaintColor)*10 color_map { [0.25 color rgbt <1,1,1,1>] [1 color rgbt <0,0,0,0.5>]} scale 3}}
				#local a = 1;
				texture {
					gradient y
					texture_map {
						[0.2 Gravel_T scale 1/5]
						[0.2 Aluminum_T]
					}
				}
				scale <Size.x,RoofHeight*1.5,Size.z>
				translate <0,Size.y-RoofHeight,0>
			}
			//translate <-Size.x/2,0,-Size.z/2>
			//scale 0.5
		}
	#else
		// 0 width object, but we must give an object since it's required by our caller.
		box {0,0}
	#end
#end

#declare NumResidentialHouseTypes = 2;
#macro MakeHouse(Size)
	#local Pick = floor(rand(RHouse)*0.999 * NumResidentialHouseTypes);
	#switch(Pick)
		#case(0)
			NBayHouse(Size)
			#break
		#case(1)
			CubeHouse(Size)
			#break
	#end
#end

#declare RHouseSize = seed(0);

#macro MakeHouseBlock(BlockSize)
	union {
		#local HouseDepth = min(BlockSize.z/4,4+rand(RHouseSize));
		#local HouseSpacing = 0.3;
		#local HouseStaggerSize = 0.5;
		// Fill -Z sides of block
		#local X = 0;
		#while (X < BlockSize.x)
			// When we have more houses, add switch
			#local HouseSize = <min(2.9,BlockSize.x-X),BlockSize.y,HouseDepth>;
			object {
				MakeHouse(HouseSize)
				translate <X,0,HouseStaggerSize*rand(RHouseSize)>
			}
			// The house creation macro changes the value of HouseSize to the true size of the house.
			#if (HouseSize.x = 0)
				#local X = BlockSize.x+1;
			#else
				#local X = X + HouseSize.x + HouseSpacing;
			#end
		#end
		// Fill +Z sides of block
		#local X = BlockSize.x;
		#while (X > 0)
			// When we have more houses, add switch
			#local HouseSize = <min(2.9,X),BlockSize.y,HouseDepth>;
			object {
				MakeHouse(HouseSize)
				rotate 180*y
				translate <X,0,BlockSize.z-HouseStaggerSize*rand(RHouseSize)>
			}
			// The house creation macro changes the value of HouseSize to the true size of the house.
			#if (HouseSize.x = 0)
				#local X = -1;
			#else
				#local X = X - HouseSize.x - HouseSpacing;
			#end
		#end
		// Fill X side of block
		#local Z = HouseDepth+HouseSpacing;
		#while (Z < BlockSize.z-HouseDepth-HouseSpacing)
			// When we have more houses, add switch
			#local HouseSize = <min(2.9,BlockSize.z-HouseDepth-HouseSpacing-Z),BlockSize.y,HouseDepth>;
			object {
				MakeHouse(HouseSize)
				rotate -90*y
				translate <BlockSize.x-HouseStaggerSize*rand(RHouseSize),0,Z>
			}
			// The house creation macro changes the value of HouseSize to the true size of the house.
			#if (HouseSize.x = 0)
				#local Z = BlockSize.z-HouseDepth-HouseSpacing+1;
			#else
				#local Z = Z + HouseSize.x + HouseSpacing;
			#end
		#end
		// Fill -X side of block
		#local Z = BlockSize.z-HouseDepth-HouseSpacing;
		#while (Z > HouseDepth+HouseSpacing)
			// When we have more houses, add switch
			#local HouseSize = <min(2.9,Z-HouseDepth-HouseSpacing),BlockSize.y,HouseDepth>;
			object {
				MakeHouse(HouseSize)
				rotate 90*y
				translate <HouseStaggerSize*rand(RHouseSize),0,Z>
			}
			// The house creation macro changes the value of HouseSize to the true size of the house.
			#if (HouseSize.x = 0)
				#local Z = -1;
			#else
				#local Z = Z - HouseSize.x - HouseSpacing;
			#end
		#end
	
		#local CourtyardSize = <BlockSize.x-2*HouseDepth, BlockSize.y, BlockSize.z-2*HouseDepth>;
		object { 
			MakeResidentialCourtyard( CourtyardSize)
			translate <+BlockSize.x/2,0,+BlockSize.z/2>
		}
		translate <-BlockSize.x/2,0,-BlockSize.z/2>
	}
#end

#macro MakeResidentialBlock(BlockSize)
	#declare BlockSize = <BlockSize.z,BlockSize.y,BlockSize.x>;
	object {
		MakeHouseBlock(BlockSize)
		rotate 90*y
	}
	#declare BlockSize = <BlockSize.z,BlockSize.y,BlockSize.x>;	
#end

#declare RAwning = seed(0);
#declare AwningColors = array[4] {<1,0,0>,<1,1,0>,<0,1,0>,<0,0,1>}
// Zero point is the bottom middle. 
#macro MakeShopAwning()
	prism {
		linear_sweep
		linear_spline
		-1,
		1,
		4,
		<0,0>,<0,1>,<1,1>,<0,0>
		
		#local AwningColor = AwningColors[floor(rand(RAwning)/1.001*4)];
		texture {
			pigment {
				gradient y
				color_map {
					[0.0 color rgb <1,1,1>]
					[0.25 color rgb <1,1,1>]
					[0.25 color rgb AwningColor]
					[0.75 color rgb AwningColor]
					[0.75 color rgb <1,1,1>]
					[1.00 color rgb <1,1,1>]
				}
				frequency 10
			}
		}
		translate -z
		rotate 90*z
	}
#end

// white enamel
#declare ShopWindowBar_T = texture {
	pigment {color rgb <1,1,1>}
	finish {
		phong 1.0
		phong_size 100
	}
}

#declare ShopGlass_T = texture {
	pigment {color rgb <0.5,0.5,0.5>}
	finish {
		reflection 0.5
		ambient 0
		diffuse 0
	}
}
	
#declare ShopWindowDoorSlice_T = texture {

	finish {
		reflection 0.5
		ambient 0
		diffuse 0
	}
}
	
#declare ShopWindowDoorSlice_T = texture {
	gradient x
	texture_map {
		[0.00 ShopWindowBar_T]
		[0.05 ShopWindowBar_T]
		[0.05 ShopGlass_T]
		[1.00 ShopGlass_T]
	}
	triangle_wave
}

#declare ShopWindowDoor_T = texture {
	gradient y
	texture_map {
		[0.00 ShopWindowBar_T]
		[0.05 ShopWindowBar_T]
		[0.05 ShopWindowDoorSlice_T]
		[1.00 ShopWindowDoorSlice_T]
	}
}
		
#declare ShopDoubleDoor = box {
	<-1,0,1>,
	<1,2,-0.01>
	texture {
		ShopWindowDoor_T
	}
	scale <1.5,1,1>
}
#declare ShopTrippleWindow = box {
	<1,0,1>,
	<4,1,-0.01>
	texture {
		ShopWindowDoor_T
	}
	scale <2,1,1>
	translate 1*y 
}

#if (Render = 1)
	global_settings {ambient_light 2}
	#include "colors.inc"
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	 	pigment
	  	{
	  	  gradient y
	  	  color_map { 
	  	  	[0.0 MidnightBlue] 
	  	  	[1.0 CornflowerBlue*2] 
	  	  }
	  	}
	}
	/*object {
		CubeHouse(<2,10,10>)
		translate <-1,0,-11>
	}
	box {
		-15,15
		RandomWindowFill_T()
		scale 1/2
	}
	*/
	object {
		MakeResidentialBlock(<20,2.5,15>)
		//translate <-10,0,0>
	}

	/*
	box {-20,20 texture {WindowFill_T}
		scale 1/4
		rotate 45*y}
	
	object {
		ShopDoubleDoor
		translate -2*x
	}
	
	object {
		ShopTrippleWindow
		translate -1*x
	}
	//MakeResidentialBlock(<10,10>)
	
	union {
		MakeShopAwning()
		scale <4,1,1>
		translate <0,3,0>
		//translate 5*y
	}
	box {
		<-4,0,4>
		<4,5,0>
		pigment {brick <0.7,0.7,0.6>,<0.5,0.1,0.1> scale 0.1 translate 0}
	}
	*/
	plane{
		y,
		0
		pigment {color rgb <0,0.5,0.5>}
	}
	camera
	{
	  location  <0, 5 , -12>
	  look_at   <0 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-100 , 50 , -50>
	}
	
	background {color <1,1,1>}
#end


