// Persistence of Vision Ray Tracer Scene Description File
// File: Room.inc
// Vers: 3.1
// Desc: Room boundary for 'The City Imagined'
// Date: 3/18/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#ifndef (RoomWidth)
	#declare RoomWidth = 12*12;
#end
#ifndef (RoomDepth)
	#declare RoomDepth = 12*12;
#end
#ifndef (RoomHeight)
	#declare RoomHeight = 8*12;
#end

#include "MyWoodTextures.inc"
#local BaseBoardColor = <1,1,0.95>;
#local PaintedBoardTexture = PaintedBoard_T(BaseBoardColor)

//Floor
#include "Floor.inc"

#local BaseBoard = prism {
	linear_sweep
	linear_spline
	-1,
	1,
	8
	<0,0>,<0,5>,<1/8,5>,<1/8,5-1/8>,<3/8,5-6/8>,<1/2,5-6/8>,<1/2,0>,<0,0>
	rotate 90*z
	rotate -90*x
}

#include "PanneledDoor.inc"

#local BaseBoardTexture = texture {
	PaintedBoardTexture
	rotate 90*z
}
	
#include "colors.inc"
// Far Wall
union {
	difference {
		union {
			box {
				<-RoomWidth/2-20, 0, RoomDepth/2+20>,
				< RoomWidth/2+100, RoomHeight, RoomDepth/2 >
				pigment {
					gradient x
					turbulence <0.1,0,0>
					pigment_map {
						[0.0 color rgbt <1,1,1,1>]
						[0.2 color rgbt <1,1,1,1>]
						[0.3 wrinkles 
								color_map {
									[0.5 Salmon*2]
									[1.0 Salmon/2]}
								scale 0.1 
								scale 1/<RoomWidth*2,10,10>]
						[1.0 wrinkles 
								color_map {
									[0.5 Salmon*2]
									[1.0 Salmon/2]}
								scale 0.1
								scale 1/<RoomWidth*2,10,10>]	
						//[1.0 color rgb <.4,1,.4>]
					}
					translate 0.55*x
					scale <RoomWidth*2,10,10>
					
				}
			}
			// Base board
			object {
				BaseBoard
				scale <RoomWidth/2+100,1,1>
				translate <0,0,RoomDepth/2>

				// Far wall fades out, we need to fade out the base board too.
				texture {
					gradient x
					turbulence <0.1,0,0>
					translate 0.55*x
					scale <RoomWidth*2,10,10>
					texture_map {
						[0.0 pigment { color rgbt <1,1,1,1>}]
						[0.2 pigment { color rgbt <1,1,1,1>}]
						[0.3 BaseBoardTexture scale 1/<RoomWidth*2,10,10>]
						[1.0 BaseBoardTexture scale 1/<RoomWidth*2,10,10>]
					}
				}
			}
		}
		// Cavity for door
		box {
			<0,0,RoomDepth/2-1>
			PanneledDoorSize + <0,0,RoomDepth/2>
		}
	}
	
	// Door
	object {
		PanneledDoor
		translate <0,0,RoomDepth/2+PanneledDoorSize.z/2>
	}
}

/*
// Right Wall
union {
	box {
		<RoomWidth/2, 0, RoomDepth/2+20>
		<RoomWidth/2+20, RoomHeight, -RoomDepth/2-20>
		pigment {color <.9,.9,1>}
	}
	// Base board
	object {
		BaseBoard
		scale <RoomWidth/2,1,1>
		texture {BaseBoardTexture}
		rotate 90*y
		translate <RoomWidth/2,0,0>
	}
}
*/

// Left Wall
union {
	box {
		<-RoomWidth/2, 0, RoomDepth/2+20>
		<-RoomWidth/2-20, RoomHeight, -RoomDepth/2-20>	
		pigment {color <.9,1,.9>}
	}
	// Base board
	object {
		BaseBoard
		scale <RoomWidth/2,1,1>
		texture {BaseBoardTexture}
		rotate -90*y
		translate <-RoomWidth/2,0,0>
	}
}

#if (Render = 1)
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>  // light's color
	  translate <-20, 100, -100>
	}
	camera
	{
	  location  <0.0 , 100.0 , -100>
	  look_at   <0.0 , 50.0 , 0>
	  //location  <0.0 , 20.0 , 50>
	  //look_at   <0.0 , 0.0 , 90>
	  //		location  <-30.0 , 10.0 , 00.0>
	  //		look_at   <0.0 , 0.0 , 0.0>
	}
#end
