// Persistence of Vision Ray Tracer Scene Description File
// File: SimplePalm.inc
// Vers: 3.1
// Desc: Simple palm tree to line my californian streets with.
// Date: 3/20/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

#declare PalmLeaf_P = <0,0.4,0.1>;

#declare PalmLeaf_T = texture {
		pigment {
			gradient z
			color_map {
				[0.00 color rgbt <1,1,1,1>]
				[0.20 color rgbt <1,1,1,1>]
				[0.25 color rgb PalmLeaf_P]
				[0.80 color rgb PalmLeaf_P]
				[0.85 color rgbt <1,1,1,1>]
			}
			frequency 20
		}
}

#declare PalmTrunk_T = texture {
	pigment {spiral2 10 scale 0.2 color_map{ [0.0 rgb <.6,.5,.3>][0.4 rgb <.6,.5,.3>][0.6 rgb <.8,.6,.3>][1.0 rgb <.8,.6,.3>]}}
	//pigment {color rgb <.7,.7,.4>}
}

#declare RSimplePalm = seed(0);

#declare PalmLeaf = sphere {
	0,
	1
	clipped_by {
		//union {
			plane {
				<4,-3,0>,
				-0.3
			}
			plane {
				<-4,-3,0>,
				-0.3
			}
		//}
	}
	translate <0,-1/2-0.05,3/4+0.08>
	texture {
		PalmLeaf_T
	}
}

#declare NumPalmLeaf = 4;
#declare NumPalmTier = 2;

#declare PalmTop = union {
	#local Tier = 0;
	#while (Tier < NumPalmTier)
		#local Count = 0;
		#while (Count < NumPalmLeaf)
			object {
				PalmLeaf
				rotate <60/NumPalmTier*Tier,0,0>
				rotate <0,360/NumPalmLeaf*(Count+Tier/NumPalmTier),0>
			}
			#local Count = Count + 1;
		#end
		#local Tier = Tier + 1;
	#end
}
#macro PalmTrunk(Angle, Height, Width)
	torus {
		Width,
		0.05
		rotate 90*x
		clipped_by {
			plane {
				-y
				0
			}
			plane {
				vrotate(y,<0,0,-Angle>)
				0
			}
		}
		translate <Width,0,0>
		scale <1/(1-cos(radians(Angle))),Height/(Width*sin(radians(Angle))),1/(1-cos(radians(Angle)))>
		texture {
			PalmTrunk_T
		}
	}
#end

#macro SimplePalm(Height)
	union {
		#local Width = Height*(rand(RSimplePalm)/2+0.5);
		#local Angle = 35 + 20*rand(RSimplePalm);
		PalmTrunk(Angle,Height,Width)
		object {
			PalmTop
			rotate <0,0,-Angle/3>
			translate <Width,Height,0>
		}
		rotate rand(RSimplePalm)*360*y
	}
#end

#if (Render = 1)

	union {
		//SimplePalm(3)
		SimplePalm(3)
		rotate 90*y
	}		

// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}

#include "colors.inc"

plane {
	-1*y,
	0
	pigment {
		checker
		color Green
		color Yellow
	}
}
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <-50, 40, -10>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <0, 40, -50>
}
/**/		
#local view = 2
#switch (view)
	#case (2)
		box {
			<-100,-10,30>,
			< 100, 100,3>
			pigment { color <1,1,1>}
		}
		camera
			{
		  		location  <0.0 , 3.0 , -5.0>
		  		look_at   <0.0 , 2.0 , 0.0>
			}
	#break
	#case (1)
		camera
		{
	  		location  <0.0 , 20.0 , -20.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
	#break	
#end
#end // if render
