// Persistence of Vision Ray Tracer Scene Description File
// File: SimpleTree.inc
// Vers: 3.1
// Desc: Recursive tree definition, very simple built out of cylinders and spheres.
// Date: 3/20/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "ParkTextures.inc"

#declare RSimpleTree = seed(3);
#declare MeanBranchRatio = 6;
#declare RangeBranchRatio = 2;
#macro MakeSimpleTree(Level,Radius,MinRadius)
	#local BranchRatio = MeanBranchRatio + RangeBranchRatio * (rand(RSimpleTree)-0.5);
	#local BranchLength = BranchRatio * Radius;
	cylinder {
		0,
		<0,BranchLength, 0>,
		Radius
		texture {Bark_T}
	}
	// simple way to make branch joint look a little better
	sphere {
		<0,0, 0>,
		Radius
		scale <1,2,1>
		translate BranchLength*y
		texture {Bark_T}
	}
	#if ((Radius > MinRadius) & (Level > 0))
		#local Angle1 = (<rand(RSimpleTree),rand(RSimpleTree),0.5>-0.5) * 2 * <45,180,0>;
		// in general we probably want the branches to bend proportionately to their new girth...
		#local BranchRatio = rand(RSimpleTree);
		// Make a binomial or something distribution out of a uniform one.
		#local BranchRatio = (BranchRatio-0.5)*(BranchRatio-0.5)+0.5; 
		union {
			MakeSimpleTree(Level-1,Radius*sqrt(BranchRatio),MinRadius)
			rotate Angle1.x * x
			rotate Angle1.y * y
			translate <0,BranchLength,0>
		}
		union {
			MakeSimpleTree(Level-1,Radius*sqrt(1-BranchRatio),MinRadius)
			rotate Angle1.x * x
			rotate (Angle1.y + 180) * y
			translate <0,BranchLength,0>
		}
		// This is stuck in as a hack for my final scene.  Only good for level 8 trees...
		// you would like this to be 2 levels less than the total levels or something...
		#if (Level < 6)
			sphere {
				<0,BranchLength,0>
				BranchLength//*0.75
				texture {LeafSphere_T}
			}
		#end
	#else
		// we're at the end of the line, make a leaf sphere.
		sphere {
			<0,BranchLength,0>
			BranchLength//*0.75
			texture {LeafSphere_T}
		}
	#end
#end

#macro LollypopTree(Height,LeafRadius,TrunkRadius)
	union {
		cylinder {
			<0,0,0>,
			<0,Height-LeafRadius,0>,
			TrunkRadius
			texture {Bark_T}
		}
		sphere {
			<0,Height-LeafRadius,0>,
			LeafRadius
			MakeLeafSphere_T()
		}
	}
#end
#macro MakeSimpleTreeGroup(XSize,ZSize,Level,Radius,MinRadius)
	#local X = 0;
	#while (X < XSize)
		#local Z = 0;
		#while (Z < ZSize)	
			union {
				MakeSimpleTree(Level,Radius,MinRadius)
				translate <20*X,0,20*Z>
			}
			#local Z = Z+1;
		#end
		#local X = X+1;
	#end
#end

#if (Render = 1)
	MakeSimpleTreeGroup(2,1,8,1,0.002)

// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }
}


plane {
	-1*y,
	0
	pigment {
		checker
		color Green
		color Yellow
	}
}
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <-50, 40, -10>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color <1,1,1>*.75 // light's color
  translate <0, 40, -50>
}
/**/		
#local view = 1
#switch (view)
	#case (2)
		box {
			<-100,-10,30>,
			< 100, 100,3>
			pigment { color <1,1,1>}
		}
		camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
	#break
	#case (1)
		camera
		{
	  		location  <-30 , 15 , -30>
	  		look_at   <20.0 , 10.0 , 20.0>
		}
	#break	
#end
#end // if render
