// Persistence of Vision Ray Tracer Scene Description File
// File: Tower.inc
// Vers: 3.1
// Desc: Assembles Towers into city (meant to be viewed from a distance, low detail.)
// Date: 3/26/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#declare RTower = seed(0);
#declare NumTowers = 5;
#include "Tower0.inc"
#include "Tower1.inc"
#include "Tower2.inc"
#include "Tower3.inc"
#include "Tower4.inc"

#macro MakeTower(Size)
	#local WhichTower = div(rand(RTower)*0.999*NumTowers,1); // 0.999 avoids 1.0 case
	// Pov could really use function pointers...
	#switch (WhichTower)
		#case(0)
			MakeTower0(Size)
			#break
		#case(1)
			MakeTower1(Size)
			#break
		#case(2)
			MakeTower2(Size)
			#break
		#case(3)
			MakeTower3(Size)
			#break
		#case(4)
			MakeTower4(Size)
			#break
	#end
#end

#macro MakeTowerGroup(XSize,ZSize)
	union {
		#local X = 0;
		#while (X < XSize)
			#local Z = 0;
			#while (Z < ZSize)	
				object {
					MakeTower(<20,100,20>)
					translate <40*(X-XSize/2),0,40*(Z-ZSize/2)>
				}
				#local Z = Z+1;
			#end
			#local X = X+1;
		#end
	}
#end


#if (Render = 1)
	global_settings{ambient_light <1,1,1>*3}

	MakeTowerGroup(10,10)
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}


	plane {
		-1*y,
		0
		pigment {
			checker
			color rgb <0,1,0>
			color <1,1,0>
		}
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <-500, 200, -100>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 200, -500>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 200, 0>
	}

	#local view = 1
	#switch (view)
		#case (2)
			camera
			{
		 		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <-250.0 , 200.0 , -250.0>
		  		look_at   <20.0 , 0.0 , 20.0>
			}
			#break	
	#end
#end // if render
