// Persistence of Vision Ray Tracer Scene Description File
// File: Tower0.inc
// Vers: 3.1
// Desc: Basic Skyscrapers meant to be viewed from a distance.
// 			Mirrored glass tower
// Date: 3/20/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#declare TowerBarTexture = texture {
		pigment {
			gradient y
			color_map {
				[0.0 color rgbt <1,1,1,1>]
				[0.5 color rgbt <1,1,1,1>]
				[0.5 color rgb <.4,.4,.4>]
				[0.6 color rgb <.4,.4,.4>]
				[0.6 color rgbt <1,1,1,1>]
			}
		}
}

		// Reflective wavy glass base
#declare TowerGrayWaveyGlass_T = texture {
	pigment {color rgb <.7,.7,.7>}
	normal {
		bozo 0.2//rand(RTower)
		scale 5
	}
	finish {
		reflection 0.4 //rand(RTower) // 0.5
		ambient 0//rand(RTower) // 0
		diffuse 0//rand(RTower) // 0
	}
}

#declare Tower0_1_T =	texture {TowerGrayWaveyGlass_T}
		// Dividing lines are overlayed.
						texture {TowerBarTexture}
						texture {TowerBarTexture rotate 90*x}
						texture {TowerBarTexture rotate 90*z}
#declare Tower0_2_T =	texture {TowerGrayWaveyGlass_T translate 5*y}
						texture {TowerBarTexture}
						texture {TowerBarTexture rotate 90*x}
						texture {TowerBarTexture rotate 90*z}

#macro MakeTower0(Size)
	box {
		<-Size.x/2,     0,-Size.z/2>,
		< Size.x/2,Size.y, Size.z/2>
		texture {
			checker 
				texture {Tower0_1_T}
				texture {Tower0_2_T}
			
		}
	}
#end

#if (Render = 1)
	MakeTower0(<10,30,10>)
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}
	
	
	plane {
		-1*y,
		0
		pigment {
			checker
			color rgb <0,1,0>
			color <1,1,0>
		}
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <-50, 40, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 40, -50>
	}

	#local view = 1
	#switch (view)
		#case (2)
			box {
				<-100,-10,30>,
				< 100, 100,3>
				pigment { color <1,1,1>}
			}
			camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <-20.0 , 25.0 , -30.0>
		  		look_at   <20.0 , 10.0 , 20.0>
			}
		#break	
	#end	
#end // if render
