// Persistence of Vision Ray Tracer Scene Description File
// File: Tower1.inc
// Vers: 3.1
// Desc: Basic Skyscrapers meant to be viewed from a distance.
// Date: 3/20/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


// Mod: 3/25, More towers

#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#declare SateliteDish = sphere {
	0,
	1
	clipped_by {
		plane {
			y,
			-0.75
		}
	}
	translate 1*y
	pigment {color rgb <0.7,0.7,0.7>}
}


#declare PTower1GrayStone = <0.7,0.7,0.7>;
#declare PTower1LightGrayStone = <0.98,0.98,0.98>;
#declare PTower1DarkGrayStone = <0.2,0.2,0.2>;
#declare PTower1WindowFrame = <0.0,0.0,0.0>;
#declare PTower1WindowWhite = <0.9,0.9,0.9>;
#declare PTower1Window = <0.2,0.2,0.2>;
#declare PClear = <1,1,1,1>;

#declare Tower1Texture0 = texture {
	pigment {
		color rgb PTower1Window
	}
	normal {
		bozo 0.2
		turbulence 0.3
	}
	finish 
	{
		reflection 0.2
		ambient 0
		diffuse 0
	}
}

#declare Tower1Texture1 = texture {
		pigment {
			gradient y
			color_map {
				[0.00 color rgb PTower1GrayStone]
				[0.20 color rgb PTower1GrayStone]
				[0.20 color rgb PTower1WindowFrame]
				[0.30 color rgb PTower1WindowFrame]
				[0.30 color rgb PTower1WindowWhite]
				[0.50 color rgb PTower1WindowWhite]
				[0.50 color rgbt PClear]
				[1.00 color rgbt PClear]
			}
			triangle_wave
		}
}
#declare Tower1Texture2 = texture {
		pigment {
			gradient x
			color_map {
				[0.00 color rgb PTower1GrayStone]
				[0.40 color rgb PTower1GrayStone]
				[0.40 color rgb PTower1WindowFrame]
				[0.50 color rgb PTower1WindowFrame]
				[0.50 color rgbt PClear]
				[1.00 color rgbt PClear]
			}
			triangle_wave
		}
}
#declare Tower1Texture3 = texture {
		pigment {
			gradient y
			color_map {
				[0.00 color rgb PTower1GrayStone]
				[0.20 color rgb PTower1GrayStone]
				[0.20 color rgbt PClear]
				[1.00 color rgbt PClear]
			}
			triangle_wave
		}
}

#macro MakeTower1Face(Size)
	box {
		<0,0,0>,
		Size
		scale <1,2/3,1>
		texture {Tower1Texture0}
		texture {Tower1Texture1}
		texture {Tower1Texture2}	
		texture {Tower1Texture3}	
		scale <1,3/2,1>
		translate -Size.x/2 * x
	}
#end

#macro MakeTower1Corner(Size)
	box {
		0,
		Size
		pigment {color rgb PTower1GrayStone}
	}
#end

#declare Tower1WallThickness = 0.4;
#macro MakeTower1EndCap(Size)
	#local TheBlock = union {
		box {
			<-Size.x/2,           0,-Size.z/2>
			< Size.x/2,Size.y/2-0.1, Size.z/2>
			pigment {color rgb PTower1GrayStone}
		}
		box {
			<-Size.x/2,Size.y/2-0.1,-Size.z/2>
			< Size.x/2,Size.y/2    , Size.z/2>
			pigment {color rgb PTower1LightGrayStone}
		}
	}
	union {
		difference {
			object {
				TheBlock
			}
			box {
				<-Size.x/2+Tower1WallThickness,    Size.y/4,-Size.z/2+Tower1WallThickness>
				< Size.x/2-Tower1WallThickness,Size.y/2+0.1, Size.z/2-Tower1WallThickness>
				pigment {color rgb PTower1DarkGrayStone}
			}
		}
		difference {
			object {
				TheBlock
			}
			box {
				<-Size.x/2+Tower1WallThickness,    Size.y*7/16,-Size.z/2+Tower1WallThickness>
				< Size.x/2-Tower1WallThickness,Size.y*4/8+0.1, Size.z/2-Tower1WallThickness>
				pigment {color rgb PTower1DarkGrayStone}
			}
			scale <3/4,2,3/4>
		}
		// Maybe some satelite dishes
		object {
			SateliteDish
			rotate -60*x
			translate <Size.x/4*3/4,Size.y,-Size.z/2*3/4>
		}
		object {
			SateliteDish
			rotate -60*x
			rotate -45*y
			translate <Size.x/2*3/4,Size.y,-Size.z/2*3/4>
		}
	}
#end

// This is actually a generic rotate and place function.
#macro MakeTowerCorners(Corner,Disp,NumCorners,CornerAngle)
	//#local NumCorners = 4;
	//#local CornerAngle = <0,90,0>;
	#local Count = 0;
	#while (Count < NumCorners)
		object {
			Corner
			translate Disp
			rotate Count*CornerAngle
		}
		#local Count = Count + 1;
	#end
#end

#declare Tower1EndCapHeight = 3;
#declare Tower1CornerWidth = 0.5;

// tower 1 should be a multiple of 3 high, and a multiple of 1 wide and deep.
#macro MakeTower1(SizeIn)
	#local Size = <div(SizeIn.x,1),div(SizeIn.y,3)*3,div(SizeIn.z,1)>;
	union {
		#local Corner = MakeTower1Corner(<Tower1CornerWidth,Size.y-Tower1EndCapHeight,Tower1CornerWidth>)
		MakeTowerCorners(Corner,-<Size.x/2,0,Size.z/2>,2,<0,180,0>)
		#local Face = MakeTower1Face(<Size.x-2*Tower1CornerWidth,Size.y-Tower1EndCapHeight,Tower1CornerWidth>)
		MakeTowerCorners(Face,<0,0,-Size.z/2>,2,<0,180,0>)

		#local Corner = object {
			MakeTower1Corner(<Tower1CornerWidth,Size.y-Tower1EndCapHeight,Tower1CornerWidth>)
			rotate -90*y
		}
		MakeTowerCorners(Corner,<Size.x/2,0,-Size.z/2>,2,<0,180,0>)
		#local Face = object {
			MakeTower1Face(<Size.z-2*Tower1CornerWidth,Size.y-Tower1EndCapHeight,Tower1CornerWidth>)
			rotate -90*y
		}
		MakeTowerCorners(Face,<Size.x/2,0,0>,2,<0,180,0>)

		object {
			MakeTower1EndCap(<Size.x,Tower1EndCapHeight,Size.z>)
			translate (Size.y-Tower1EndCapHeight) * y
		}
	}
#end	

#if (Render = 1)
	MakeTower1(<10,15,5>)
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}
	
	
	plane {
		-1*y,
		0
		pigment {
			checker
			color rgb <0,1,0>
			color <1,1,0>
		}
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <-50, 40, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 40, -50>
	}

	#local view = 1
	#switch (view)
		#case (2)
			box {
				<-100,-10,30>,
				< 100, 100,3>
				pigment { color <1,1,1>}
			}
			camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <-20.0 , 25.0 , -30.0>
		  		look_at   <20.0 , 10.0 , 20.0>
			}
		#break	
	#end	
#end // if render
