// Persistence of Vision Ray Tracer Scene Description File
// File: Tower2.inc
// Vers: 3.1
// Desc: Basic Skyscrapers meant to be viewed from a distance.
// 			Stripey gray stone tower
// Date: 3/26/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "colors.inc"

#declare SateliteDish = sphere {
	0,
	1
	clipped_by {
		plane {
			y,
			-0.75
		}
	}
	translate 1*y
	pigment {color rgb <0.7,0.7,0.7>}
}


#declare PTower2GrayStone = <0.7,0.7,0.7>;
#declare PTower2Window = <0.2,0.2,0.2>;
#declare PClear = <1,1,1,1>;

#declare Tower2Texture0 = texture {
		pigment {
			gradient x
			// window strips are 0.16 wide, divide is 0.08, border is 0.18
			// * 2 since we're using a triangle wave and symetry.
			color_map {
				[0.00 color rgb PTower2GrayStone]
				[0.36 color rgb PTower2GrayStone]
				[0.36 color rgb PTower2Window]
				[0.68 color rgb PTower2Window]
				[0.68 color rgb PTower2GrayStone]
				[0.84 color rgb PTower2GrayStone]
				[0.84 color rgb PTower2Window]
				[1.00 color rgb PTower2Window]
			}
			triangle_wave
		}
}

#macro MakeTower2Face(Size)
	box {
		<0,0,0>,
		Size
		texture {Tower2Texture0}
		translate -Size.x/2 * x
	}
#end

#macro MakeTower2Corner(Size)
	box {
		0,
		Size
		pigment {color rgb PTower2GrayStone}
	}
#end

#declare Tower2WallThickness = 0.4;
#macro MakeTower2EndCap(Size)
	//union {
		difference {
			box {
				<-Size.x/2,     0,-Size.z/2>
				< Size.x/2,Size.y, Size.z/2>
				pigment {color rgb PTower2GrayStone}
			}
			box {
				<-Size.x/2+Tower2WallThickness,  Size.y/4,-Size.z/2+Tower2WallThickness>
				< Size.x/2-Tower2WallThickness,Size.y+0.1, Size.z/2-Tower2WallThickness>
				pigment {color rgb PTower2GrayStone}
			}
		}
		// other accessories, boxes etc...
	//}
#end

// This is actually a generic rotate and place function.
#macro MakeTowerCorners(Corner,Disp,NumCorners,CornerAngle)
	//#local NumCorners = 4;
	//#local CornerAngle = <0,90,0>;
	#local Count = 0;
	#while (Count < NumCorners)
		object {
			Corner
			translate Disp
			rotate Count*CornerAngle
		}
		#local Count = Count + 1;
	#end
#end

#declare Tower2EndCapHeight = 2;
#declare Tower2CornerWidth = 0.18;

// tower 2 should be a multiple of 1 high, and a multiple of 1 wide and deep.
#macro MakeTower2(SizeIn)
	#local Size = <div(SizeIn.x-Tower2CornerWidth*2,1)+Tower2CornerWidth*2,div(SizeIn.y,1),div(SizeIn.z-Tower2CornerWidth*2,1)+Tower2CornerWidth*2>;
	union {
		#local Corner = MakeTower2Corner(<Tower2CornerWidth,Size.y-Tower2EndCapHeight,Tower2CornerWidth>)
		MakeTowerCorners(Corner,-<Size.x/2,0,Size.z/2>,2,<0,180,0>)
		#local Face = MakeTower2Face(<Size.x-2*Tower2CornerWidth,Size.y-Tower2EndCapHeight,Tower2CornerWidth>)
		MakeTowerCorners(Face,<0,0,-Size.z/2>,2,<0,180,0>)

		#local Corner = object {
			MakeTower2Corner(<Tower2CornerWidth,Size.y-Tower2EndCapHeight,Tower2CornerWidth>)
			rotate -90*y
		}
		MakeTowerCorners(Corner,<Size.x/2,0,-Size.z/2>,2,<0,180,0>)
		#local Face = object {
			MakeTower2Face(<Size.z-2*Tower2CornerWidth,Size.y-Tower2EndCapHeight,Tower2CornerWidth>)
			rotate -90*y
		}
		MakeTowerCorners(Face,<Size.x/2,0,0>,2,<0,180,0>)

		object {
			MakeTower2EndCap(<Size.x,Tower2EndCapHeight,Size.z>)
			translate (Size.y-Tower2EndCapHeight) * y
		}
	}
#end	

#if (Render = 1)
	MakeTower2(<10,30,10>)
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}
	
	
	plane {
		-1*y,
		0
		pigment {
			checker
			color rgb <0,1,0>
			color <1,1,0>
		}
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <-50, 40, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 40, -50>
	}

	#local view = 1
	#switch (view)
		#case (2)
			box {
				<-100,-10,30>,
				< 100, 100,3>
				pigment { color <1,1,1>}
			}
			camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <-20.0 , 25.0 , -30.0>
		  		look_at   <20.0 , 10.0 , 20.0>
			}
		#break	
	#end	
#end // if render
