// Persistence of Vision Ray Tracer Scene Description File
// File: Tower3.inc
// Vers: 3.1
// Desc: Basic Skyscrapers meant to be viewed from a distance.
// 			White with black square windows, elongated cap
// Date: 3/26/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#declare PTower3Wall = <0.99,0.99,0.99>;
#declare PTower3Window = <0.2,0.2,0.2>;
#declare PClear = <1,1,1,1>;

#declare Tower3Ambient = 0.1;

#declare Tower3Texture0 = texture {
	pigment {
		color rgb PTower3Window
	}
	normal {
		bozo 0.2
		turbulence 0.3
	}
	finish 
	{
		reflection 0.2
		ambient 0
		diffuse 0
	}
}

// horizontal stripes
#declare Tower3Texture1 = texture {
		pigment {
			gradient y
			color_map {
				[0.00 color rgb PTower3Wall]
				[0.50 color rgb PTower3Wall]
				[0.50 color rgbt PClear]
				[1.00 color rgbt PClear]
			}
			triangle_wave
		}
	finish 
	{
		ambient Tower3Ambient
	}
}
#declare Tower3Texture2 = texture {
		pigment {
			gradient x
			color_map {
				[0.00 color rgb PTower3Wall]
				[0.40 color rgb PTower3Wall]
				[0.40 color rgbt PClear]
				[1.00 color rgbt PClear]
			}
			triangle_wave
		}
	finish 
	{
		ambient Tower3Ambient
	}
}

#macro MakeTower3Face(Size)
	box {
		<0,0,0>,
		Size
		texture {Tower3Texture0}
		texture {Tower3Texture1}
		texture {Tower3Texture2}	
		translate -Size.x/2 * x
	}
#end

#macro MakeTower3Corner(Size)
	box {
		0,
		Size
		texture {
			pigment {color rgb PTower3Wall}
			finish {ambient Tower3Ambient}
		}
	}
#end

#declare Tower3WallThickness = 0.4;
#macro MakeTower3EndCap(Size)
	union {
		difference {
			object {
				MakeTower3Body(<Size.x,1,Size.z>)
				scale <1,Size.y,1>
			}
			box {
				<-Size.x/2+Tower3WallThickness,  Size.y/4,-Size.z/2+Tower3WallThickness>
				< Size.x/2-Tower3WallThickness,Size.y+0.1, Size.z/2-Tower3WallThickness>
				pigment {color rgb PTower3Wall}
			}
		}
			box {
				<-Size.x/2+Tower3WallThickness,Size.y/2,-Size.z/2+Tower3WallThickness>
				< Size.x/2-Tower3WallThickness,Size.y/4, Size.z/2-Tower3WallThickness>
				pigment {color rgb PTower3Wall}
			}
	}
#end

// This is actually a generic rotate and place function.
#macro MakeTowerCorners(Corner,Disp,NumCorners,CornerAngle)
	//#local NumCorners = 4;
	//#local CornerAngle = <0,90,0>;
	#local Count = 0;
	#while (Count < NumCorners)
		object {
			Corner
			translate Disp
			rotate Count*CornerAngle
		}
		#local Count = Count + 1;
	#end
#end

#declare Tower3EndCapHeight = 2;
#declare Tower3CornerWidth = 0.5;

#macro MakeTower3Body(Size)
	union {
		#local Corner = MakeTower3Corner(<Tower3CornerWidth,Size.y,Tower3CornerWidth>)
		MakeTowerCorners(Corner,-<Size.x/2,0,Size.z/2>,2,<0,180,0>)
		#local Face = MakeTower3Face(<Size.x-2*Tower3CornerWidth,Size.y,Tower3CornerWidth>)
		MakeTowerCorners(Face,<0,0,-Size.z/2>,2,<0,180,0>)

		#local Corner = object {
			MakeTower3Corner(<Tower3CornerWidth,Size.y,Tower3CornerWidth>)
			rotate -90*y
		}
		MakeTowerCorners(Corner,<Size.x/2,0,-Size.z/2>,2,<0,180,0>)
		#local Face = object {
			MakeTower3Face(<Size.z-2*Tower3CornerWidth,Size.y,Tower3CornerWidth>)
			rotate -90*y
		}
		MakeTowerCorners(Face,<Size.x/2,0,0>,2,<0,180,0>)
	}
#end	

#macro MakeTower3(SizeIn)
	// tower 3 should be a multiple of 1 high, and a multiple of 1 wide and deep.
	#local Size = <div(SizeIn.x-Tower3CornerWidth*2,1)+Tower3CornerWidth*2,div(SizeIn.y,1),div(SizeIn.z-Tower3CornerWidth*2,1)+Tower3CornerWidth*2>;
	union {
		MakeTower3Body(<Size.x,Size.y-Tower3EndCapHeight, Size.z>)

		object {
			MakeTower3EndCap(<Size.x,Tower3EndCapHeight,Size.z>)
			translate (Size.y-Tower3EndCapHeight) * y
		}
	}
#end	

#if (Render = 1)
	MakeTower3(<10,30,10>)
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}
	
	
	plane {
		-1*y,
		0
		pigment {
			checker
			color rgb <0,1,0>
			color <1,1,0>
		}
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <-50, 40, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 40, -50>
	}

	#local view = 1
	#switch (view)
		#case (2)
			box {
				<-100,-10,30>,
				< 100, 100,3>
				pigment { color <1,1,1>}
			}
			camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <-20.0 , 25.0 , -30.0>
		  		look_at   <20.0 , 10.0 , 20.0>
			}
		#break	
	#end	
#end // if render
