// Persistence of Vision Ray Tracer Scene Description File
// File: Tower4.inc
// Vers: 3.1
// Desc: Basic Skyscrapers meant to be viewed from a distance.
// 			Cylindrical striped
// Date: 4/18/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#declare Tower4Stone_T = texture { pigment {color rgb <0.8,0.8,0.8>} finish {specular 0.3 roughness 0.5}}
#declare Tower4Window_T = texture { pigment {color rgb <0.2,0.2,0.2>} finish {specular 0.7 roughness 0.0005}}

#macro MakeTower4(Size)
	#local R = min(Size.x,Size.z)/2;
	cylinder {
		<0,0,0>,
		<0,Size.y,0>,
		R
		texture {
			radial 
			frequency floor(2*pi*R) // window width approximately 1.
			texture_map {[0.0 Tower4Stone_T][0.6 Tower4Stone_T][0.6 Tower4Window_T][1.0 Tower4Window_T]}
		}
	}
#end
					

#if (Render = 1)
	MakeTower4(<10,30,10>)
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}
	
	
	plane {
		-1*y,
		0
		pigment {
			checker
			color rgb <0,1,0>
			color <1,1,0>
		}
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <-50, 40, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 40, -50>
	}

	#local view = 1
	#switch (view)
		#case (2)
			box {
				<-100,-10,30>,
				< 100, 100,3>
				pigment { color <1,1,1>}
			}
			camera
			{
		  		location  <0.0 , 10.0 , -20.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <-20.0 , 25.0 , -30.0>
		  		look_at   <20.0 , 10.0 , 20.0>
			}
		#break	
	#end	
#end // if render
