// Persistence of Vision Ray Tracer Scene Description File
// File: TowerAccessories.inc
// Vers: 3.1
// Desc: Simple accessories for the top of my skyscrappers, such as flags and satelite dishes.
// Date: 3/26/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

// Points straight up.
#declare SateliteDish = sphere {
	0,
	1
	clipped_by {
		plane {
			y,
			-0.75
		}
	}
	translate 1*y
	pigment {color rgb <0.7,0.7,0.7>}
}

#declare Sqrt2 = sqrt(2);

#declare FireEscapeStairThickness = 0.1;
#declare FireEscapeRailHeight = 0.3;
#declare FireEscapeRailThickness = 0.05;

#declare Clear = color rgbt <1,1,1,1>;

// possibly add size parameter, although sizing to a 1x1x1 box and post scaling should be fine.
#macro MakeFireEscape (NFloors, UnitSize, Color) 
	#local  FireEscapeStair = box {
		<0,0,0.5>,
		<Sqrt2,FireEscapeStairThickness,1>
		texture {pigment {gradient x scale FireEscapeStairThickness color_map {[0.0 Clear][0.5 Clear][0.5 Color][1.0 Color]}}}
		rotate 45*z
	}
	#local FireEscapePlatform = box {
		<0,0,0>,
		<1,FireEscapeRailHeight,1>
		texture { pigment { radial frequency 1/FireEscapeRailThickness translate 0.5 color_map {[0.0 Clear][0.5 Clear][0.5 Color][1.0 Color]}}}
		hollow on
		clipped_by {plane {y, FireEscapeRailHeight - 0.001}}
		translate y
	}
	#local FireEscapeLevel = union {
		object {FireEscapeStair}
		object {FireEscapePlatform}
	}
	union {
		#local Count = 0;
		#while (Count < NFloors)
			object {FireEscapeLevel translate Count * y}
			#local Count = Count + 1;
		#end
		scale UnitSize
	}
#end

#if (Render = 1)
	
	MakeFireEscape(10,<1,2,0.5>,color rgb <1,0.5,0>)
	// Create an infinite sphere around scene and allow any texture on it
	sky_sphere
	{
	  pigment
	  {
	    gradient y
	    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	  }
	}
	#include "colors.inc"
	
	plane {
		-1*y,
		0
		pigment {
			checker
			color Green
			color Yellow
		}
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <50, 40, -10>
	}
	
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 40, -50>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.75 // light's color
	  translate <0, 200, 0>
	}	
	/**/		
	#local view = 1
	#switch (view)
		#case (2)
			camera
			{
		  		location  <0.0 , 30.0 , -20.0>
		  		look_at   <0.0 , 15.0 , 0.0>
			}
			#break
		#case (1)
			camera
			{
		  		location  <0.0 , 10.0 , -10.0>
		  		look_at   <0.0 ,  5.0 , 0.0>
			}
			#break	
	#end
#end // if render
