// Persistence of Vision Ray Tracer Scene Description File
// File: TrackBufferStop.inc
// Vers: 3.1
// Desc: Block to stop the train from running off the end of the track.
// Date: 4/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

#declare BufferStopSize = <3/2*TrackCrossSectionSize.x,TrackCrossSectionSize.x,TrackCrossSectionSize.x>;

#declare BufferStopTrackConnectsPosition = array[1] {<0,0,0>}
#declare BufferStopTrackNumConnects = 1;
#declare BufferStopTrackConnectsAngle = array[1] {<0,180,0>}
#declare BufferStopTrackConnectsGender = array[1] {0}
#declare BufferStopBlock = union {
	prism {
		linear_sweep
		linear_spline
		0,
		BufferStopSize.x-0.1,
		
		TrackCrossSectionNumPoints+1, // Last point to close the curve.
		#local Count = 0;
		#while (Count < TrackCrossSectionNumPoints)
			TrackCrossSection[Count],
			#local Count = Count+1;
		#end
		TrackCrossSection[0]
		rotate 180*y
		rotate 90*x
		rotate 90*y
		translate <0,0,-TrackCrossSectionCenter.x>
	}	
	prism {
		linear_sweep
		linear_spline
		-BufferStopSize.z/2,
		BufferStopSize.z/2,
		6,
		<BufferStopSize.x/3,0>,<BufferStopSize.x/3,BufferStopSize.y>,
		<BufferStopSize.x*2/3,BufferStopSize.y>,<BufferStopSize.x,BufferStopSize.y*2/3>,
		<BufferStopSize.x,0>,<BufferStopSize.x/3,0>
		rotate -90*x
	}
}
	
#include "TrackFunctions.inc"

#declare BufferStopFTrackConnectsPosition = BufferStopTrackConnectsPosition
#declare BufferStopFTrackNumConnects = BufferStopTrackNumConnects;
#declare BufferStopFTrackConnectsAngle = BufferStopTrackConnectsAngle
#declare BufferStopFTrackConnectsGender = array[1] {0}

#declare BufferStopFTrack = AddConnects(BufferStopBlock,
												BufferStopFTrackConnectsAngle,
												BufferStopFTrackConnectsPosition,
												BufferStopFTrackConnectsGender,
												BufferStopFTrackNumConnects)

#declare BufferStopMTrackConnectsPosition = BufferStopTrackConnectsPosition
#declare BufferStopMTrackNumConnects = BufferStopTrackNumConnects;
#declare BufferStopMTrackConnectsAngle = BufferStopTrackConnectsAngle
#declare BufferStopMTrackConnectsGender = array[1] {1}

#declare BufferStopMTrack = AddConnects(BufferStopBlock,
												BufferStopMTrackConnectsAngle,
												BufferStopMTrackConnectsPosition,
												BufferStopMTrackConnectsGender,
												BufferStopMTrackNumConnects)
												

#if (Render = 1)
	#include "TrackTextures.inc"
	object {
		BufferStopFTrack
		texture {TrackWood_T}
	}
	object {
		BufferStopMTrack
		texture {TrackWood_T}
		translate <0,0,2>
	}
	camera
	{
	  location  <0.0 , 7.0 ,-3.0>
	  look_at   <0.0 , 0.0 , 0.0>
	}
	background{color rgb 1}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <3, 10, -20>
	}
#end
