// Persistence of Vision Ray Tracer Scene Description File
// File: TrackBuilder.inc
// Vers: 3.1
// Desc: Given an array of track names and which connect point to start with, this 
//        instansiates the objects and positions them correctly.
// Date: 3/15/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end
			
#declare kMiniStraight = 0.0;
#declare kMiniStraightFF = 0.1;
#declare kMiniStraightMM = 0.2;
#declare kMediumStraight = 0.3;
#declare kShortStraight = 0.4;
#declare kLongStraight = 0.5;
#declare kShortCurveL = 1.1;
#declare kShortCurveR = 1.2;
#declare kLongCurveL = 1.3;
#declare kLongCurveR = 1.4;
#declare kSolidBridge1 = 2.0;
#declare kSolidBridge2 = 2.1;
#declare kRampUp = 2.2;
#declare kRampDown = 2.3;
#declare kCSSplitLM = 3.0;
#declare kCSSplitLF = 3.1;
#declare kCSSplitRM = 3.2;
#declare kCSSplitRF = 3.3;
#declare kSupport1 = 4.0;
#declare kTSplitFFM = 5.0;
#declare kTSplitFMM = 5.1;
#declare kTSplitMFF = 5.2;
#declare kTSplitMMF = 5.3;
#declare kXSplit = 6.0;
#declare kBufferStopF = 7.0;
#declare kBufferStopM = 7.1;
#declare kInvisibleStopF = 7.2;
#declare kInvisibleStopM = 7.3;


#if (Render = 1)

	// Featured object(s)
	#declare TrackNumSegments = 42;
	#declare Track = array[TrackNumSegments] {
		kCSSplitLM,0,
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,
		kShortStraight,0,kShortStraight,0,kShortStraight,0,
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,
		kCSSplitRF,2,
		kLongCurveL,1,
		kShortCurveL,1,kShortCurveL,1,
		kShortStraight,1,kShortStraight,1,
		kShortCurveL,1,kShortCurveL,1,
		kLongCurveL,1,
		}

	global_settings {ambient_light 2}
	plane{
		y,
		0
		pigment {color rgb <0.5,0.5,0.5>}
	}
	camera
	{
	  location  <0, 40 , 0>
	  look_at   <0 , 0.0 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-100 , 50 , -50>
	}
	
	background {color <1,1,1>}
#end

#if (TrackNumSegments > 0)

#include "TrackTextures"

#include "TrackLongStraight.inc"
#include "TrackShortCurve.inc"
#include "TrackLongCurve.inc"
#include "TrackSolidBridge.inc"
#include "TrackMediumStraight.inc"
#include "TrackShortStraight.inc"
#include "TrackMiniStraight.inc"
#include "TrackRamp.inc"
#include "TrackCSSplit.inc"
#include "TrackTSplit.inc"
#include "TrackXSplit.inc"
#include "TrackBufferStop.inc"
#include "TrackInvisibleStop.inc"

#include "TrackSupport1.inc"
#include "WoodCutOutTrees.inc"

#macro PushTrackEndStack (Position, Angle, Gender)
	#if (TrackEndStackIndex+1 >= TrackEndStackMaxSize)
		#warning "TrackEndStack overflow"
	#else
		#declare TrackEndStackIndex = TrackEndStackIndex + 1;
		#declare TrackEndStackPos[TrackEndStackIndex] = Position;
		#declare TrackEndStackAng[TrackEndStackIndex] = <mod(Angle.x+360,360),mod(Angle.y+360,360),mod(Angle.z+360,360)>;
		#declare TrackEndStackGen[TrackEndStackIndex] = Gender;
	#end
#end

#macro PopTrackEndStack (Position, Angle, Gender)
	#if (TrackEndStackIndex <= -1)
		#warning "TrackEndStack underflow"
	#else
		#declare Position = TrackEndStackPos[TrackEndStackIndex];
		#declare Angle =    TrackEndStackAng[TrackEndStackIndex];
		#declare Gender =   TrackEndStackGen[TrackEndStackIndex];
		#declare TrackEndStackIndex = TrackEndStackIndex - 1;
	#end
#end

#macro CheckLoopClosure (Position, Angle, Gender)
	#local ClosedLoop = 0;
	#local StackConnect = 0;
	#while ((!ClosedLoop) & (StackConnect <= TrackEndStackIndex))
		#if (VEqual(TrackEndStackPos[StackConnect],Position))
			#local ClosedLoop = 1;
			#if (!VEqual(<mod(TrackEndStackAng[StackConnect].x+360,180),mod(TrackEndStackAng[StackConnect].y +360,180),mod(TrackEndStackAng[StackConnect].z +360,180)>,<mod(Angle.x +360,180),mod(Angle.y +360,180),mod(Angle.z +360,180)>))
				#debug concat(str(mod(TrackEndStackAng[StackConnect].x,180),10,10),"   ",str(mod(TrackEndStackAng[StackConnect].y,180),10,10),"   ",str(mod(TrackEndStackAng[StackConnect].z,180),10,10),"   ")
				#debug concat(str(mod(Angle.x,180),10,10),"   ",str(mod(Angle.y,180),10,10),"   ",str(mod(Angle.z,180),10,10),"   ")
				#warning "Loop Closure Angle Missmatch"
				sphere {0,0.5 translate Position pigment{color rgb <0,1,0>}}
				#local ClosedLoop = 0;
				#local StackConnect = StackConnect + 1;
			#end
			#if (TrackEndStackGen[StackConnect] = Gender)
				// Want the genders to be different.
				#warning "Loop Closure Gender Mismatch"
				#debug concat("End Gender = ", str(Gender,3,3)," Beginning Gender = ",str(TrackEndStackGen[StackConnect],3,3),".  ")
				sphere {0,0.5 translate Position pigment{color rgb <0,0,1>}}
			#end
		#else
			#local StackConnect = StackConnect + 1;
		#end
	#end
	
	#if (ClosedLoop = 1)
		// Remove this connect from our 'stack' (oops...)
		#if (StackConnect = TrackEndStackIndex)
			// just decrement the stack pointer and we're fine.
			#declare TrackEndStackIndex = TrackEndStackIndex - 1;
		#else
			#while (StackConnect < TrackEndStackIndex)
				#declare TrackEndStackPos[StackConnect] = TrackEndStackPos[StackConnect+1];
				#declare TrackEndStackAng[StackConnect] = TrackEndStackAng[StackConnect+1];
				#declare TrackEndStackGen[StackConnect] = TrackEndStackGen[StackConnect+1];
				#local StackConnect = StackConnect + 1;
			#end
			#declare TrackEndStackIndex = TrackEndStackIndex - 1;
		#end
	
		PopTrackEndStack (Position, Angle, Gender)
	#end
#end

#macro VEqual (Vector1, Vector2)
	#local Temp = (Vector1 = Vector2);
	(Temp.x*Temp.y*Temp.z)
#end

#declare FinalTrackConnectNumPoints = 200;
#declare FinalTrackConnectPoints = array[FinalTrackConnectNumPoints]
#declare FinalTrackConnectAngles = array[FinalTrackConnectNumPoints]

#declare MaleConnect = 0;
#declare FemaleConnect = 1;
#declare TrackEndStackMaxSize = 50;
#declare TrackEndStackPos = array[TrackEndStackMaxSize]
#declare TrackEndStackAng = array[TrackEndStackMaxSize]
#declare TrackEndStackGen = array[TrackEndStackMaxSize]
#declare TrackEndStackIndex = -1; // Empty Stack
PushTrackEndStack(<0,0,0>,<0,0,0>,0)
PushTrackEndStack(<0,0,0>,<0,0,0>,1)
union {
	#local Position = TrackEndStackPos[TrackEndStackIndex];
	#local Angle =    TrackEndStackAng[TrackEndStackIndex];
	#local Gender =   TrackEndStackGen[TrackEndStackIndex];
	#local Segment = 0;
	#local RPigment = seed(0);
	#local RJitter = seed(0);

	#while (Segment < TrackNumSegments)
		#switch (Track[Segment])
			#case (kMiniStraight)
				#local TrackHolder = MiniStraightTrack
				#local ConnectsPosHolder = MiniStraightTrackConnectsPosition
				#local ConnectsAngHolder = MiniStraightTrackConnectsAngle
				#local ConnectsGenHolder = MiniStraightTrackConnectsGender
				#local NumConnectsHolder = MiniStraightTrackNumConnects;
				#break
			#case (kMiniStraightFF)
				#local TrackHolder = MiniStraightFFTrack
				#local ConnectsPosHolder = MiniStraightFFTrackConnectsPosition
				#local ConnectsAngHolder = MiniStraightFFTrackConnectsAngle
				#local ConnectsGenHolder = MiniStraightFFTrackConnectsGender
				#local NumConnectsHolder = MiniStraightFFTrackNumConnects;
				#break
			#case (kMiniStraightMM)
				#local TrackHolder = MiniStraightMMTrack
				#local ConnectsPosHolder = MiniStraightMMTrackConnectsPosition
				#local ConnectsAngHolder = MiniStraightMMTrackConnectsAngle
				#local ConnectsGenHolder = MiniStraightMMTrackConnectsGender
				#local NumConnectsHolder = MiniStraightMMTrackNumConnects;
				#break
			#case (kMediumStraight)
				#local TrackHolder = MediumStraightTrack
				#local ConnectsPosHolder = MediumStraightTrackConnectsPosition
				#local ConnectsAngHolder = MediumStraightTrackConnectsAngle
				#local ConnectsGenHolder = MediumStraightTrackConnectsGender
				#local NumConnectsHolder = MediumStraightTrackNumConnects;
				#break
			#case (kShortStraight)
				#local TrackHolder = ShortStraightTrack
				#local ConnectsPosHolder = ShortStraightTrackConnectsPosition
				#local ConnectsAngHolder = ShortStraightTrackConnectsAngle
				#local ConnectsGenHolder = ShortStraightTrackConnectsGender
				#local NumConnectsHolder = ShortStraightTrackNumConnects;
				#break
			#case (kLongStraight)
				#local TrackHolder = LongStraightTrack
				#local ConnectsPosHolder = LongStraightTrackConnectsPosition
				#local ConnectsAngHolder = LongStraightTrackConnectsAngle
				#local ConnectsGenHolder = LongStraightTrackConnectsGender
				#local NumConnectsHolder = LongStraightTrackNumConnects;
				#break
			#case (kShortCurveL)
				#local TrackHolder = ShortCurveLTrack
				#local ConnectsPosHolder = ShortCurveLTrackConnectsPosition
				#local ConnectsAngHolder = ShortCurveLTrackConnectsAngle
				#local ConnectsGenHolder = ShortCurveLTrackConnectsGender
				#local NumConnectsHolder = ShortCurveLTrackNumConnects;
				#break
			#case (kShortCurveR)
				#local TrackHolder = ShortCurveRTrack
				#local ConnectsPosHolder = ShortCurveRTrackConnectsPosition
				#local ConnectsAngHolder = ShortCurveRTrackConnectsAngle
				#local ConnectsGenHolder = ShortCurveRTrackConnectsGender
				#local NumConnectsHolder = ShortCurveRTrackNumConnects;
				#break
			#case (kLongCurveL)
				#local TrackHolder = LongCurveLTrack
				#local ConnectsPosHolder = LongCurveLTrackConnectsPosition
				#local ConnectsAngHolder = LongCurveLTrackConnectsAngle
				#local ConnectsGenHolder = LongCurveLTrackConnectsGender
				#local NumConnectsHolder = LongCurveLTrackNumConnects;
				#break
			#case (kLongCurveR)
				#local TrackHolder = LongCurveRTrack
				#local ConnectsPosHolder = LongCurveRTrackConnectsPosition
				#local ConnectsAngHolder = LongCurveRTrackConnectsAngle
				#local ConnectsGenHolder = LongCurveRTrackConnectsGender
				#local NumConnectsHolder = LongCurveRTrackNumConnects;
				#break
			#case (kSolidBridge1)
				#local TrackHolder = SolidBridge1Track
				#local ConnectsPosHolder = SolidBridge1TrackConnectsPosition
				#local ConnectsAngHolder = SolidBridge1TrackConnectsAngle
				#local ConnectsGenHolder = SolidBridge1TrackConnectsGender
				#local NumConnectsHolder = SolidBridge1TrackNumConnects;
				#break
			#case (kSolidBridge2)
				#local TrackHolder = SolidBridge2Track
				#local ConnectsPosHolder = SolidBridge2TrackConnectsPosition
				#local ConnectsAngHolder = SolidBridge2TrackConnectsAngle
				#local ConnectsGenHolder = SolidBridge2TrackConnectsGender
				#local NumConnectsHolder = SolidBridge2TrackNumConnects;
				#break
			#case (kRampUp)
				#local TrackHolder = RampUpTrack
				#local ConnectsPosHolder = RampUpTrackConnectsPosition
				#local ConnectsAngHolder = RampUpTrackConnectsAngle
				#local ConnectsGenHolder = RampUpTrackConnectsGender
				#local NumConnectsHolder = RampUpTrackNumConnects;
				#break
			#case (kRampDown)
				#local TrackHolder = RampDownTrack
				#local ConnectsPosHolder = RampDownTrackConnectsPosition
				#local ConnectsAngHolder = RampDownTrackConnectsAngle
				#local ConnectsGenHolder = RampDownTrackConnectsGender
				#local NumConnectsHolder = RampDownTrackNumConnects;
				#break
			#case (kCSSplitLM)
				#local TrackHolder = CSSplitLMTrack
				#local ConnectsPosHolder = CSSplitLMTrackConnectsPosition
				#local ConnectsAngHolder = CSSplitLMTrackConnectsAngle
				#local ConnectsGenHolder = CSSplitLMTrackConnectsGender
				#local NumConnectsHolder = CSSplitLMTrackNumConnects;
				#break
			#case (kCSSplitLF)
				#local TrackHolder = CSSplitLFTrack
				#local ConnectsPosHolder = CSSplitLFTrackConnectsPosition
				#local ConnectsAngHolder = CSSplitLFTrackConnectsAngle
				#local ConnectsGenHolder = CSSplitLFTrackConnectsGender
				#local NumConnectsHolder = CSSplitLFTrackNumConnects;
				#break
			#case (kCSSplitRM)
				#local TrackHolder = CSSplitRMTrack
				#local ConnectsPosHolder = CSSplitRMTrackConnectsPosition
				#local ConnectsAngHolder = CSSplitRMTrackConnectsAngle
				#local ConnectsGenHolder = CSSplitRMTrackConnectsGender
				#local NumConnectsHolder = CSSplitRMTrackNumConnects;
				#break
			#case (kCSSplitRF)
				#local TrackHolder = CSSplitRFTrack
				#local ConnectsPosHolder = CSSplitRFTrackConnectsPosition
				#local ConnectsAngHolder = CSSplitRFTrackConnectsAngle
				#local ConnectsGenHolder = CSSplitRFTrackConnectsGender
				#local NumConnectsHolder = CSSplitRFTrackNumConnects;
				#break
			#case (kSupport1)
				#local NumSupports = floor(Position.y/TrackRiserHeight);
				#if (NumSupports > 1)
					#local TrackHolder = union {
						#local Count = 0;
						#while (Count < NumSupports)
							object {Support1Track 
								translate -Count * TrackRiserHeight * y
							}
							#local Count = Count + 1;
						#end
					}
				#else 
					#local TrackHolder = Support1Track
				#end					
				#local ConnectsPosHolder = Support1TrackConnectsPosition
				#local ConnectsAngHolder = Support1TrackConnectsAngle
				#local ConnectsGenHolder = Support1TrackConnectsGender
				#local NumConnectsHolder = Support1TrackNumConnects;
				#break
			#case (kTSplitFFM)
				#local TrackHolder = 		TSplitFFMTrack
				#local ConnectsPosHolder =	TSplitFFMTrackConnectsPosition
				#local ConnectsAngHolder =	TSplitFFMTrackConnectsAngle
				#local ConnectsGenHolder =	TSplitFFMTrackConnectsGender
				#local NumConnectsHolder =	TSplitFFMTrackNumConnects;
				#break
			#case (kTSplitFMM)
				#local TrackHolder = 		TSplitFMMTrack
				#local ConnectsPosHolder =	TSplitFMMTrackConnectsPosition
				#local ConnectsAngHolder =	TSplitFMMTrackConnectsAngle
				#local ConnectsGenHolder =	TSplitFMMTrackConnectsGender
				#local NumConnectsHolder =	TSplitFMMTrackNumConnects;
				#break
			#case (kTSplitMFF)
				#local TrackHolder = 		TSplitMFFTrack
				#local ConnectsPosHolder =	TSplitMFFTrackConnectsPosition
				#local ConnectsAngHolder =	TSplitMFFTrackConnectsAngle
				#local ConnectsGenHolder =	TSplitMFFTrackConnectsGender
				#local NumConnectsHolder =	TSplitMFFTrackNumConnects;
				#break
			#case (kTSplitMMF)
				#local TrackHolder = 		TSplitMMFTrack
				#local ConnectsPosHolder =	TSplitMMFTrackConnectsPosition
				#local ConnectsAngHolder =	TSplitMMFTrackConnectsAngle
				#local ConnectsGenHolder =	TSplitMMFTrackConnectsGender
				#local NumConnectsHolder =	TSplitMMFTrackNumConnects;
				#break
			#case (kXSplit)
				#local TrackHolder = 		XSplitTrack
				#local ConnectsPosHolder =	XSplitTrackConnectsPosition
				#local ConnectsAngHolder =	XSplitTrackConnectsAngle
				#local ConnectsGenHolder =	XSplitTrackConnectsGender
				#local NumConnectsHolder =	XSplitTrackNumConnects;
				#break
			#case (kBufferStopF)
				#local TrackHolder = 		BufferStopFTrack
				#local ConnectsPosHolder =	BufferStopFTrackConnectsPosition
				#local ConnectsAngHolder =	BufferStopFTrackConnectsAngle
				#local ConnectsGenHolder =	BufferStopFTrackConnectsGender
				#local NumConnectsHolder =	BufferStopFTrackNumConnects;
				#break
			#case (kBufferStopM)
				#local TrackHolder = 		BufferStopMTrack
				#local ConnectsPosHolder =	BufferStopMTrackConnectsPosition
				#local ConnectsAngHolder =	BufferStopMTrackConnectsAngle
				#local ConnectsGenHolder =	BufferStopMTrackConnectsGender
				#local NumConnectsHolder =	BufferStopMTrackNumConnects;
				#break
			#case (kInvisibleStopF)
				#local TrackHolder = 		InvisibleStopFTrack
				#local ConnectsPosHolder =	InvisibleStopFTrackConnectsPosition
				#local ConnectsAngHolder =	InvisibleStopFTrackConnectsAngle
				#local ConnectsGenHolder =	InvisibleStopFTrackConnectsGender
				#local NumConnectsHolder =	InvisibleStopFTrackNumConnects;
				#break
			#case (kInvisibleStopM)
				#local TrackHolder = 		InvisibleStopMTrack
				#local ConnectsPosHolder =	InvisibleStopMTrackConnectsPosition
				#local ConnectsAngHolder =	InvisibleStopMTrackConnectsAngle
				#local ConnectsGenHolder =	InvisibleStopMTrackConnectsGender
				#local NumConnectsHolder =	InvisibleStopMTrackNumConnects;
				#break
			
			#else 
				#debug concat("Unknown Track type specified in track list", str(Track[Segment],1,1))
				#error concat("Unknown Track type specified in track list", str(Track[Segment],1,1))
				#break	
			
		#end
		
		#local WhichConnect = Track[Segment+1];
		
		#if (Gender != ConnectsGenHolder[WhichConnect])		
			#local PreAngle = <0,180,0>-ConnectsAngHolder[WhichConnect];
			#local PreTranslate = -ConnectsPosHolder[WhichConnect];
			object {
				TrackHolder
				texture {
					TrackWood_T
					rotate (rand(RPigment)-.5)*30*z
					rotate (rand(RPigment)-.5)*45*y
				}
				// Rotate and translate to get the right connect at possition 0
				translate PreTranslate
				rotate PreAngle
				// Rotate and translate to match the end of the last piece we laid down.
				rotate Angle
				translate Position + (<rand(RJitter),rand(RJitter),rand(RJitter)>-MaxTrackJitterCenter) * 2 * MaxTrackJitter
			}
			
			#local Connect = 0;
			#while (Connect < NumConnectsHolder)
				#local ConnectsPosHolder[Connect] = ConnectsPosHolder[Connect] + PreTranslate;
				#local ConnectsAngHolder[Connect] = ConnectsAngHolder[Connect] + PreAngle + Angle;
				#local ConnectsPosHolder[Connect] = Position + vrotate(ConnectsPosHolder[Connect],PreAngle+Angle);
				#local Connect = Connect + 1;
			#end
			
			// Push them all on, then pop one off...
			#if (NumConnectsHolder > 1)
				#local Connect = mod(WhichConnect+1,NumConnectsHolder);
				#while (Connect != WhichConnect)
					// need to push the extra connections onto the stack.
					PushTrackEndStack(	ConnectsPosHolder[Connect],
										ConnectsAngHolder[Connect],
										ConnectsGenHolder[Connect])
					#local Connect = mod(Connect + 1,NumConnectsHolder);
				#end
			#end
			
			
			PopTrackEndStack(Position,Angle,Gender)
				
			// check for closing a loop and possible pop a new starting place off the stack.
			CheckLoopClosure(Position,Angle,Gender)
			
			#if(Segment/2 < FinalTrackConnectNumPoints)
				#declare FinalTrackConnectPoints[Segment/2] = Position;
				#declare FinalTrackConnectAngles[Segment/2] = Angle;
			#end
			
		#else
			sphere {Position, 1 pigment{color rgb <1,0,0>}}
			#debug concat ("Gender Error at ",str(Segment,1,1))
			//#error "Gender Error"
		#end
		
		#local Segment = Segment + 2;
	#end				
}                     

#end
