// Persistence of Vision Ray Tracer Scene Description File
// File: TrackCSSplit.inc
// Vers: 3.1
// Desc: VSplit track composed of a long 45deg arc and medium straight track
// Date: 3/??/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

	#local Radius = TrackCurveRadius;
	#local InnerRadius = Radius - TrackCrossSectionSize.x/2;
	#local OuterRadius = InnerRadius + TrackCrossSectionSize.x;
	
#declare LongCurveBlockRExtension = intersection {
	lathe{
		linear_spline
		TrackCrossSectionRExtension2NumPoints+1,
		#local Count = 0;
		#while (Count < TrackCrossSectionRExtension2NumPoints)
			TrackCrossSectionRExtension2[Count] + <InnerRadius,0>,
			#local Count = Count+1;
		#end
		TrackCrossSectionRExtension2[0] + <InnerRadius,0>
	}
	box {
		<0,-.1,0>,
		<OuterRadius+3,TrackCrossSectionSize.y+.1,OuterRadius+3>
	}
	box {
		<0,-.1,0>,
		<OuterRadius+3,TrackCrossSectionSize.y+.1,OuterRadius+3>
		rotate y*45
	}
}	

#declare CSSplitLMTrackConnectsAngle = array[3] {<0,180,0>, <0,-45,0>, <0,0,0>}
#declare CSSplitLMTrackConnectsPosition = array[3] {<0,0,0>,Radius*<sin(radians(45)),0,1-cos(radians(45))>,
															<TrackUnitLength*3/4,0,0>}
#declare CSSplitLMTrackNumConnects = 3;
#declare CSSplitLMTrackConnectsGender = array[3] {0,1,1}

#declare ShortStraightBlock = union {
	prism {
		linear_sweep
		linear_spline
		CSSplitLMTrackConnectsPosition[0].x,
		CSSplitLMTrackConnectsPosition[2].x,
		TrackCrossSectionRExtension2NumPoints+1, // Last point to close the curve.
		#local Count = 0;
		#while (Count < TrackCrossSectionRExtension2NumPoints)
			TrackCrossSectionRExtension2[Count],
			#local Count = Count+1;
		#end
		TrackCrossSectionRExtension2[0]
		rotate 180*y
		rotate 90*x
		rotate 90*y
		translate <0,0,-TrackCrossSectionCenter.x>
	}
	box {
		<0,0,0>,
		<0.4,TrackCrossSectionSize.y,3>
		translate <CSSplitLMTrackConnectsPosition[2].x - 0.1,0,TrackCrossSectionSize.x/2 + 0.1>
		//pigment {color rgb <1,0,0>}
	}
}	


#declare CSSplitBlock = intersection {
	object {
		LongCurveBlockRExtension
		rotate 90*y
		translate <0,0,Radius>
	}
	object {ShortStraightBlock
		translate <0,-0.0001,0>
	 }
}

#include "TrackFunctions.inc"

#declare CSSplitLMTrack = AddConnects(CSSplitBlock, 
										CSSplitLMTrackConnectsAngle,
										CSSplitLMTrackConnectsPosition,
										CSSplitLMTrackConnectsGender,
										CSSplitLMTrackNumConnects)


#declare CSSplitLFTrackConnectsAngle = CSSplitLMTrackConnectsAngle
#declare CSSplitLFTrackConnectsPosition = CSSplitLMTrackConnectsPosition
#declare CSSplitLFTrackNumConnects = 3;
#declare CSSplitLFTrackConnectsGender = array[3] {1,0,0}

#declare CSSplitLFTrack = AddConnects(CSSplitBlock, 
										CSSplitLFTrackConnectsAngle,
										CSSplitLFTrackConnectsPosition,
										CSSplitLFTrackConnectsGender,
										CSSplitLFTrackNumConnects)


#declare CSSplitRMTrackConnectsAngle = array[3] {<0,180,0>, <0,45,0>, <0,0,0>}
#declare CSSplitRMTrackConnectsPosition = array[3] {<0,0,0>,Radius*<sin(radians(45)),0,-(1-cos(radians(45)))>,CSSplitLMTrackConnectsPosition[2]}
#declare CSSplitRMTrackNumConnects = 3;
#declare CSSplitRMTrackConnectsGender = array[3] {0,1,1}

#declare CSSplitRMTrack = object {
	CSSplitLMTrack
	rotate 180*x
	translate TrackCrossSectionSize.y*y
}


#declare CSSplitRFTrackConnectsAngle = CSSplitRMTrackConnectsAngle
#declare CSSplitRFTrackConnectsPosition = CSSplitRMTrackConnectsPosition
#declare CSSplitRFTrackNumConnects = 3;
#declare CSSplitRFTrackConnectsGender = array[3] {1,0,0}

#declare CSSplitRFTrack = object {
	CSSplitLFTrack
	rotate 180*x
	translate TrackCrossSectionSize.y*y
}


#if (Render = 1)
	#include "TrackTextures.inc"

	object {
		CSSplitLMTrack
		texture {TrackWood_T}
	}
	object {
		CSSplitLFTrack
		texture {TrackWood_T}
		translate <0,0,4>
	}
	object {
		CSSplitRMTrack
		texture {TrackWood_T}
		translate <7,0,0>
	}
	object {
		CSSplitRFTrack
		texture {TrackWood_T}
		translate <7,0,4>
	}
	/*object {
		LongCurveRTrack
		texture {TrackWood_T}
	}*/
	camera
	{
	  location  <7.0 , 20.0 , 3.0>
	  look_at   <7.0 , 0.0 , 3.0>
	}
	background{color rgb <1,1,1>}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color 1.5  // light's color
	  translate <-10, 30, -20>
	}
#end

