// Persistence of Vision Ray Tracer Scene Description File
// File: TrackConnects.inc
// Vers: 3.1
// Desc: 
// Date: 3/11/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"

#declare TrackMalePlugRadius = 0.43/2;
#declare TrackMalePlugOffsetRectSize = <0.205+TrackMalePlugRadius,TrackCrossSectionSize.y,0.195>;
// standard cylindrical plug
#declare TrackMaleConnect1 = union {
	cylinder {
		<0,0,0>,
		<0,TrackCrossSectionSize.y,0>,
		TrackMalePlugRadius
		translate <TrackMalePlugOffsetRectSize.x,0,0>
	}
	box {
		<0,0,-TrackMalePlugOffsetRectSize.z/2>,
		TrackMalePlugOffsetRectSize * <1,1,0.5>
	}
}

// special spherical plug
#declare TrackMaleConnect2 = union {
	sphere {
		<TrackMalePlugOffsetRectSize.x,TrackCrossSectionSize.y/2,0>,
		TrackMalePlugRadius
	}
	cylinder {
		TrackMalePlugOffsetRectSize * <0,0.5,0>,
		TrackMalePlugOffsetRectSize * <1,0.5,0>,
		TrackMalePlugOffsetRectSize.z/2
	}
}

#declare TrackFemalePlugRadius = 0.5/2;
#declare TrackFemalePlugOffsetRectSize = <0.16+TrackFemalePlugRadius,TrackCrossSectionSize.y,0.265>;
#declare TrackFemaleConnect1 = union {
	cylinder {
		<0,-0.001,0>,
		<0,TrackCrossSectionSize.y+0.001,0>,
		TrackFemalePlugRadius
		translate <TrackFemalePlugOffsetRectSize.x,0,0>
	}
	box {
		<-.1,-.001,-TrackFemalePlugOffsetRectSize.z/2>,
		TrackFemalePlugOffsetRectSize * <1,1,0.5> + <0,0.001,0>
	}
}

#declare MaxTrackJitter = (TrackFemalePlugOffsetRectSize - TrackMalePlugOffsetRectSize)/2 + <0,0.03,0>;
#declare MaxTrackJitterCenter = <0,0.5,0.5>;
// For debugging

#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"
	object {
		TrackMaleConnect1
		texture {TrackWood_T}
	}
	difference {
		box {
			<0,0,-TrackCrossSectionSize.x/2>
			<1,TrackCrossSectionSize.y,TrackCrossSectionSize.x/2>
		}
		object {TrackFemaleConnect1}
		texture {TrackWood_T}
		translate <2,0,0>
	}
	
	difference {
		box {
			<0,0,-TrackCrossSectionSize.x/2>
			<1,TrackCrossSectionSize.y,TrackCrossSectionSize.x/2>
		}
		object {TrackFemaleConnect1}
		texture {TrackWood_T}
		translate <4,0,0>
	}
	object {
		TrackMaleConnect1
		texture {TrackWood_T}
		translate <4,0,0>
	}

	/*sphere {
		0,
		1
		pigment {Red}
	}
	sphere {
		LongCurveRTrackConnects[1],
		1
		pigment {Blue}
	}*/
	camera
	{
	  location  <3.0 , 5.0 ,-5.0>
	  look_at   <3.0 , 0.0 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <3, 10, -20>
	}
#end
