// Persistence of Vision Ray Tracer Scene Description File
// File: TrackCrossSection.inc
// Vers: 3.1
// Desc: 
// Date: 3/9/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end


//#declare TrackMediumUnitLength = 23/4;

#declare TrackCrossSectionNumPoints = 14;
#declare TrackCrossSection = array[TrackCrossSectionNumPoints] {
									<0.000,0.46>,<0.125,0.48>,<0.125,0.40>,<0.375,0.40>,<0.375,0.50>,
									<1.125,0.50>,<1.125,0.40>,<1.375,0.40>,<1.375,0.48>,<1.500,0.46>,
									<1.500,0.02>,<1.48,0.00>,<0.02,0.00>,<0.00,0.02>}
#declare TrackCrossSectionRExtensionNumPoints = 14;
#declare TrackCrossSectionRExtension = array[TrackCrossSectionNumPoints] {
									<0.000,0.46>,<0.125,0.48>,<0.125,0.40>,<0.375,0.40>,<0.375,0.50>,
									<1.125,0.50>,<1.125,0.40>,<1.375,0.40>,<1.375,0.48>,<1.500,0.46>,
									<1.500,0.02>,<1.48,0.00>,<0.02,0.00>,<0.00,0.02>}
#declare TrackCrossSection2NumPoints = 20;
#declare TrackCrossSection2 = array[TrackCrossSection2NumPoints] {
									<0.000,0.46>,<0.125,0.48>,<0.125,0.40>,<0.375,0.40>,<0.375,0.50>,
									<1.125,0.50>,<1.125,0.40>,<1.375,0.40>,<1.375,0.48>,<1.500,0.46>,
									<1.500,0.04>,<1.375,0.02>,<1.375,0.10>,<1.125,0.10>,<1.125,0.00>,
									<0.375,0.00>,<0.375,0.10>,<0.125,0.10>,<0.125,0.02>,<0.000,0.04>}
#declare TrackCrossSection2NumPoints = 32;
#declare TrackCrossSection2 = array[TrackCrossSection2NumPoints] {
									<0.000,0.46>,<0.040,0.50>,
									<0.085,0.50>,<0.125,0.46>,<0.125,0.40>,<0.375,0.40>,<0.375,0.46>,<0.415,0.50>,
									<1.085,0.50>,<1.125,0.46>,<1.125,0.40>,<1.375,0.40>,<1.375,0.46>,<1.415,0.50>,
									<1.460,0.50>,<1.500,0.46>,<1.500,0.04>,<1.460,0.00>,
									<1.415,0.00>,<1.375,0.04>,<1.375,0.10>,<1.125,0.10>,<1.125,0.04>,<1.085,0.00>,
									<0.415,0.00>,<0.375,0.04>,<0.375,0.10>,<0.125,0.10>,<0.125,0.04>,<0.085,0.00>,
									<0.040,0.00>,<0.000,0.04>}
#declare TrackCrossSectionRExtension2NumPoints = 30;
#declare TrackCrossSectionRExtension2 = array[TrackCrossSectionRExtension2NumPoints] {
									<0.000,0.46>,<0.040,0.50>,
									<0.085,0.50>,<0.125,0.46>,<0.125,0.40>,<0.375,0.40>,<0.375,0.46>,<0.415,0.50>,
									<1.085,0.50>,<1.125,0.46>,<1.125,0.40>,<1.375,0.40>,<1.375,0.46>,<1.415,0.50>,
									<7.500,0.50>,<7.500,0.00>,
									<1.415,0.00>,<1.375,0.04>,<1.375,0.10>,<1.125,0.10>,<1.125,0.04>,<1.085,0.00>,
									<0.415,0.00>,<0.375,0.04>,<0.375,0.10>,<0.125,0.10>,<0.125,0.04>,<0.085,0.00>,
									<0.040,0.00>,<0.000,0.04>}
#declare TrackCrossSectionDoubleExtension2NumPoints = 28;
#declare TrackCrossSectionDoubleExtension2 = array[TrackCrossSectionDoubleExtension2NumPoints] {
									<-7.000,0.50>,
									<0.085,0.50>,<0.125,0.46>,<0.125,0.40>,<0.375,0.40>,<0.375,0.46>,<0.415,0.50>,
									<1.085,0.50>,<1.125,0.46>,<1.125,0.40>,<1.375,0.40>,<1.375,0.46>,<1.415,0.50>,
									<7.500,0.50>,<7.500,0.00>,
									<1.415,0.00>,<1.375,0.04>,<1.375,0.10>,<1.125,0.10>,<1.125,0.04>,<1.085,0.00>,
									<0.415,0.00>,<0.375,0.04>,<0.375,0.10>,<0.125,0.10>,<0.125,0.04>,<0.085,0.00>,
									<-7.000,0.00>}
#declare TrackCrossSectionCenter = <.75,.25,0>;
#declare TrackCrossSectionSize = <1.5,.5,0>;
#declare TrackGrooveSize = <0.25,0.1>;
#declare TrackGroovePosition = array[2] {< 0.125, 0.40>, <1.125, 0.40>}


#declare TrackMiniUnitLength =    54/25.4; // 1/4
#declare TrackXUnitLength =       72/25.4; // 1/3
#declare TrackShortUnitLength =  108/25.4; // 1/2
#declare TrackMediumUnitLength = 147/25.4; // 2/3
#declare TrackUnitLength =       216/25.4; // 1/1

//#declare TrackShortCurveRadius = 9.0/2.54/sin(pi/4)-TrackCrossSectionCenter.x;
//#declare TrackCurveRadius = 17.0/2.54/sin(pi/4)-TrackCrossSectionCenter.x;
#declare TrackShortCurveRadius = TrackShortUnitLength;
#declare TrackCurveRadius = TrackUnitLength;

//#declare TrackRiserHeight = 73/25.4;
#declare TrackRiserHeight = 2+13/32;


#if (Render = 1)
	#include "colors.inc"
	
	// Featured object(s)
	#local Count = 0;
	#while (Count < TrackCrossSection2NumPoints)
		sphere {0,0.01
			pigment {Red}
			translate <TrackCrossSection2[Count].x,TrackCrossSection2[Count].y, 0>
		}
		#if (Count != TrackCrossSection2NumPoints-1)
			cylinder {
				<TrackCrossSection2[Count].x,TrackCrossSection2[Count].y, 0>
				<TrackCrossSection2[Count+1].x,TrackCrossSection2[Count+1].y, 0>
				0.01
				pigment {Yellow}
			}
		#else
			cylinder {
				<TrackCrossSection2[Count].x,TrackCrossSection2[Count].y, 0>
				<TrackCrossSection2[0].x,TrackCrossSection2[0].y, 0>
				0.01
				pigment {Yellow}
			}
		#end
		#local Count = Count + 1;
	#end
	
	#local Count = 0;
	#while (Count < TrackCrossSectionRExtension2NumPoints)
		sphere {0,0.01
			pigment {Blue}
			translate <TrackCrossSectionRExtension2[Count].x,TrackCrossSectionRExtension2[Count].y, 0>
			translate 1*y
		}
		#if (Count != TrackCrossSectionRExtension2NumPoints-1)
			cylinder {
				<TrackCrossSectionRExtension2[Count].x,TrackCrossSectionRExtension2[Count].y, 0>
				<TrackCrossSectionRExtension2[Count+1].x,TrackCrossSectionRExtension2[Count+1].y, 0>
				0.01
				translate 1*y
				pigment {Green}
			}
		#end
		#local Count = Count + 1;
	#end


	global_settings {ambient_light 2}
	camera
	{
	  location  <0.75, 0.5, -3>
	  look_at   <0.75 , 0.5 , 0>
	}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*1.5  // light's color
	  translate <-100 , 50 , -50>
	}
	
	background {color <1,1,1>}
#end


