// Persistence of Vision Ray Tracer Scene Description File
// File: TrackFunctions.inc
// Vers: 3.1
// Desc: Functions to assist in creating track sections.
// Date: 4/23/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#include "TrackConnects.inc"


#macro AddConnects(BaseObject, ConnectAngles, ConnectPositions, ConnectGenders, NumConnects)
	union {
		// Add Male connects
		#local Count = 0;
		#while (Count < NumConnects)
			#if (ConnectGenders[Count] = 1)
				object { // origin Connect
					TrackMaleConnect1
					rotate ConnectAngles[Count]
					translate ConnectPositions[Count]
				}
			#end
			#local Count = Count + 1;
		#end
		difference {
			object {BaseObject}
			
			// Remove Female Connects.
			#local Count = 0;
			#while (Count < NumConnects)
				#if (ConnectGenders[Count] = 0)
					object { // origin Connect
						TrackFemaleConnect1
						rotate ConnectAngles[Count]
						rotate 180*y
						translate ConnectPositions[Count]
					}
					#end
				#local Count = Count + 1;
			#end
		}
	}		
#end


#if (Render = 1)
	// Featured Objects
	
	
	camera
	{
	  location  <7.0 , 20.0 , 3.0>
	  look_at   <7.0 , 0.0 , 3.0>
	}
	background{color rgb <1,1,1>}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color 1.5  // light's color
	  translate <-10, 10, -20>
	}
#end

