// Persistence of Vision Ray Tracer Scene Description File
// File: TrackInvisibleStop.inc
// Vers: 3.1
// Desc: This is a hack, because it's really hard to add branches to 
//        established track descriptions and get them to come out right.
// Date: 4/23/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"


#declare InvisibleStopTrackConnectsPosition = array[1] {<0,0,0>}
#declare InvisibleStopTrackNumConnects = 1;
#declare InvisibleStopTrackConnectsAngle = array[1] {<0,180,0>}
#declare InvisibleStopTrackConnectsGender = array[1] {0}

#declare InvisibleStopBlock = sphere{0,0.001 pigment {color rgbt <1,1,1,1>}}
	
#include "TrackFunctions.inc"

#declare InvisibleStopFTrackConnectsPosition = InvisibleStopTrackConnectsPosition
#declare InvisibleStopFTrackNumConnects = InvisibleStopTrackNumConnects;
#declare InvisibleStopFTrackConnectsAngle = InvisibleStopTrackConnectsAngle
#declare InvisibleStopFTrackConnectsGender = array[1] {0}

#declare InvisibleStopFTrack = InvisibleStopBlock

#declare InvisibleStopMTrackConnectsPosition = InvisibleStopTrackConnectsPosition
#declare InvisibleStopMTrackNumConnects = InvisibleStopTrackNumConnects;
#declare InvisibleStopMTrackConnectsAngle = InvisibleStopTrackConnectsAngle
#declare InvisibleStopMTrackConnectsGender = array[1] {1}

#declare InvisibleStopMTrack = InvisibleStopBlock
												

#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"
	object {
		InvisibleStopFTrack
		texture {TrackWood_T}
	}
	object {
		InvisibleStopMTrack
		texture {TrackWood_T}
		translate <0,0,2>
	}
	camera
	{
	  location  <0.0 , 7.0 ,-3.0>
	  look_at   <0.0 , 0.0 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <3, 10, -20>
	}
#end
