// Persistence of Vision Ray Tracer Scene Description File
// File: TrackLayoutSamples.inc
// Vers: 3.1
// Desc: Some Sample track layouts
// Date: 4/23/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end

#ifndef (Detail_Level)
	#local Detail_Level = 10; // 0..10
#end

	#local TrackNumSegments = 0;
	#local Track = array[2]
	#include "TrackBuilder.inc"


	#declare DoubleOvalTrackNumSegments = 42;
	#declare DoubleOvalTrack = array[DoubleOvalTrackNumSegments] {
		kCSSplitLM,0,
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,
		kShortStraight,0,kShortStraight,0,kShortStraight,0,
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,
		kCSSplitRF,2,
		kLongCurveL,1,
		kShortCurveL,1,kShortCurveL,1,
		kShortStraight,1,kShortStraight,1,
		kShortCurveL,1,kShortCurveL,1,
		kLongCurveL,1,
		}

	#declare XTrackNumSegments = 56;
	#declare XTrack = array[XTrackNumSegments] {
		kTSplitFFM,0, kTSplitFFM,0, kLongCurveL,0, kLongCurveL,0,
		kTSplitFFM,0, kTSplitFFM,0, kLongCurveL,0, kLongCurveL,0,
		kTSplitFMM,0, kTSplitFMM,0, kLongCurveL,0, kLongCurveL,0,
		kTSplitFMM,0, kTSplitFMM,0, kLongCurveL,0, kLongCurveL,0,
		
		kLongStraight,0,kLongStraight,0,kLongStraight,0,
		kLongStraight,0,kLongStraight,0,kLongStraight,0,
		kLongStraight,0,kLongStraight,0,kLongStraight,0,
		kLongStraight,0,kLongStraight,0,kLongStraight,0

	}
	#declare XOverTrackNumSegments = (7*4 + 5*4)*2;
	#declare XOverTrack = array[XOverTrackNumSegments] {
		kShortStraight,0, kTSplitFFM,0, kShortStraight,0, kTSplitFFM,0, kShortStraight,0, kLongCurveL,0, kLongCurveL,0,
		kShortStraight,0, kTSplitFFM,0, kShortStraight,0, kTSplitFFM,0, kShortStraight,0, kLongCurveL,0, kLongCurveL,0,
		kShortStraight,0, kTSplitFMM,0, kShortStraight,0, kTSplitFMM,0, kShortStraight,0, kLongCurveL,0, kLongCurveL,0,
		kShortStraight,0, kTSplitFMM,0, kShortStraight,0, kTSplitFMM,0, kShortStraight,0, kLongCurveL,0, kLongCurveL,0,
		
		kShortStraight,0, kRampUp,0, kRampDown,0, kLongStraight,0, kLongStraight,0,
		kLongStraight,0, kLongStraight,0, kRampUp,0, kRampDown,0, kShortStraight,0, 
		kShortStraight,0, kRampUp,0, kRampDown,0, kLongStraight,0, kLongStraight,0,
		kLongStraight,0, kLongStraight,0, kRampUp,0, kRampDown,0, kShortStraight,0, 
	}
	
	#declare FlowerTrackNumSegments = (8*8)*2;
	#declare FlowerTrack = array[FlowerTrackNumSegments] {
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
		kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongCurveL,0,kLongStraight,0
	}
	#declare MondoTrackNumSegments = (2 + 5 + 22 + 3 + 12 + 36 + 21 + 6 + 8 + 16 + 36 + 3 + 5*4)*2;
	#declare MondoTrack = array[MondoTrackNumSegments] {
		kShortStraight,0, kXSplit,0, 
		
		kLongCurveR,0, kLongCurveR,0, kLongCurveL,0, kLongCurveL,0, 
		kXSplit,0, 
		
		kShortCurveR,0, kShortCurveR,0, kShortStraight,0,
		kShortCurveR,0, kShortCurveR,0, 
		kShortCurveL,0, kShortCurveL,0, kShortCurveL,0, kShortCurveL,0, 
		kShortCurveR,0, kShortCurveR,0,  
		kShortCurveL,0, kShortCurveL,0, kShortCurveL,0, kShortCurveL,0, kShortStraight,0, kShortStraight,0,
		kShortCurveR,0, kShortCurveR,0, kShortStraight,0, kShortStraight,0,
		kBufferStopF,0, 
		
		kLongCurveL,0, kLongCurveL,0,kBufferStopF,0, 
		
		kMiniStraightMM,0, kLongStraight,0, kShortCurveL,0,kShortStraight,0, kShortStraight,0, 
		kShortCurveR,0, kLongStraight,0, kLongCurveL,0,  
		kCSSplitRM,0,
		kLongStraight,0, kShortStraight,0, kLongCurveL,0
		
		kRampUp,0, kSupport1,0, kLongStraight,0, kSupport1,0, kRampDown,0
		kLongStraight,0, kLongStraight,0, 
		kLongCurveL,0, kLongStraight,0, kLongStraight,0, kLongCurveL,0, kLongStraight,0, 
		kRampUp,0, kSupport1,0, kRampUp,0, kSupport1,0, kLongCurveL,0, //kSupport1,0
		kShortStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, 
		kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, 
		kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, 
		kBufferStopF,0,

		kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, 
		kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, 
		kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, 
		kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, 
		kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, 
		kInvisibleStopF,0		
		
		kShortStraight,0, kTSplitFFM,0, kShortStraight,0, kLongCurveL,0, kLongCurveL,0,
		kShortStraight,0, 
		
		kXSplit,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, kLongStraight,0, kBufferStopF,0, 
		
		kShortStraight,0, kTSplitFFM,0, kShortStraight,0, kCSSplitLM,0, kInvisibleStopF,0 kLongCurveL,0,
		kShortStraight,0, kTSplitFMM,0, kShortStraight,0, kTSplitFMM,0, kShortStraight,0, kLongCurveL,0, kLongCurveL,0,
		kShortStraight,0, kTSplitFMM,0, kShortStraight,0, 
		
		kXSplit,1, 
		kShortCurveL,1, kShortCurveL,1, 
		kMiniStraightMM,0, kRampUp,0, kSupport1,0, kLongStraight,0, kSupport1,0, 
		kLongStraight,0, kSupport1,0, kShortStraight,0, kSupport1,0,kShortStraight,0, kSupport1,0, 
		kLongCurveR,0, kSupport1,0, kLongCurveR,0, kSupport1,0,
		kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, kLongStraight,0, kSupport1,0, 
		kShortStraight,0, kSupport1,0, 
		kLongCurveR,0, kSupport1,0, kLongCurveR,0, kSupport1,0, 
		kRampDown,0, kMiniStraight,0, kMiniStraightFF,0
		kInvisibleStopM,0,
		
		kShortStraight,0, kLongCurveL,0, kLongCurveL,0,
		
		kShortStraight,0, kRampUp,0, kRampDown,0, kLongStraight,0, kLongStraight,0,
		kLongStraight,0, kLongStraight,0, kRampUp,0, kRampDown,0, kShortStraight,0, 
		kShortStraight,0, kRampUp,0, kRampDown,0, kLongStraight,0, kLongStraight,0,
		kLongStraight,0, kLongStraight,0, kRampUp,0, kRampDown,0, kShortStraight,0, 
	}
#if (Render = 1)
	// Featured object(s)
	#local TrackNumSegments = MondoTrackNumSegments;
	#local Track = MondoTrack
	#include "TrackBuilder.inc"

	global_settings {ambient_light 2}
	plane{
		y,
		0
		pigment {color rgb <0.5,0.5,0.5>}
	}
	#if (1)
		camera
		{
		  location  <30, 200 , 30>
		  look_at   <30 , 0.0 , 30>
		  orthographic
		}
		// create a regular point light source
		light_source
		{
		  0*x // light's position (translated below)
		  color <1,1,1>*1.5  // light's color
		  translate <-30, 60, -30>   // <x y z> position of light
		}
	#else
		camera
		{
			//up y
			//right 6/4*x
	  		location  <-30.0 , 10.0 , -30.0>
	  		look_at   <0.0 , 0.0 , 0.0>
		}
		light_source
		{
		  0*x // light's position (translated below)
		  color <1,1,1>*1.5  // light's color
		  translate <-30, 60, -30>   // <x y z> position of light
		}
		/*light_source
		{
		  0*x // light's position (translated below)
		  color rgb 1.5  // light's color
		  // <widthVector> <heightVector> nLightsWide mLightsHigh
		  area_light
		  <0, 20, 0> <0, 0, 20> // lights spread out across this distance (x * z)
		  4,4                // total number of lights in grid (4x*4z = 16 lights)
		  adaptive 0          // 0,1,2,3... 
		  jitter              // adds random softening of light
		  translate <-30, 60, -30>   // <x y z> position of light
		}*/
	#end
	background {color <1,1,1>}
#end
