// Persistence of Vision Ray Tracer Scene Description File
// File: TrackMiniStraight.inc
// Vers: 3.1
// Desc: Straight track piece
// Date: 3/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

#declare MiniStraightTrackConnectsPosition = array[2] {<0,0,0>,<TrackMiniUnitLength,0,0>}
#declare MiniStraightTrackNumConnects = 2;
#declare MiniStraightTrackConnectsAngle = array[2] {<0,180,0>, <0,0,0>}
#declare MiniStraightTrackConnectsGender = array[2] {0,1}
#declare MiniStraightBlock = prism {
	linear_sweep
	linear_spline
	MiniStraightTrackConnectsPosition[0].x,
	MiniStraightTrackConnectsPosition[1].x,
	TrackCrossSection2NumPoints+1, // Last point to close the curve.
	#local Count = 0;
	#while (Count < TrackCrossSection2NumPoints)
		TrackCrossSection2[Count],
		#local Count = Count+1;
	#end
	TrackCrossSection2[0]
	rotate 180*y
	rotate 90*x
	rotate 90*y
	translate <0,0,-TrackCrossSectionCenter.x>
}	

#include "TrackFunctions.inc"
#declare MiniStraightTrack = AddConnects(MiniStraightBlock,
												MiniStraightTrackConnectsAngle,
												MiniStraightTrackConnectsPosition,
												MiniStraightTrackConnectsGender,
												MiniStraightTrackNumConnects)
												
#declare MiniStraightFFTrackConnectsPosition = MiniStraightTrackConnectsPosition
#declare MiniStraightFFTrackConnectsAngle = MiniStraightTrackConnectsAngle
#declare MiniStraightFFTrackNumConnects = MiniStraightTrackNumConnects;
#declare MiniStraightFFTrackConnectsGender = array[2] {0,0}
#declare MiniStraightFFTrack = AddConnects(MiniStraightBlock,
												MiniStraightFFTrackConnectsAngle,
												MiniStraightFFTrackConnectsPosition,
												MiniStraightFFTrackConnectsGender,
												MiniStraightFFTrackNumConnects)

#declare MiniStraightMMTrackConnectsPosition = MiniStraightTrackConnectsPosition
#declare MiniStraightMMTrackConnectsAngle = MiniStraightTrackConnectsAngle
#declare MiniStraightMMTrackNumConnects = MiniStraightTrackNumConnects;
#declare MiniStraightMMTrackConnectsGender = array[2] {1,1}
#declare MiniStraightMMTrack = AddConnects(MiniStraightBlock,
												MiniStraightMMTrackConnectsAngle,
												MiniStraightMMTrackConnectsPosition,
												MiniStraightMMTrackConnectsGender,
												MiniStraightMMTrackNumConnects)


#if (Render = 1)
	#include "TrackTextures.inc"
	object {
		MiniStraightTrack
		texture {TrackWood_T}
	}
	object {
		MiniStraightFFTrack
		texture {TrackWood_T}
		translate <0,0,2>
	}
	object {
		MiniStraightMMTrack
		texture {TrackWood_T}
		translate <0,0,4>
	}
	camera
	{
	  location  <0.0 , 7.0 ,-3.0>
	  look_at   <0.0 , 0.0 , 0.0>
	}
	background{color rgb 1}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color red 1.0  green 1.0  blue 1.0  // light's color
	  translate <3, 10, -20>
	}
#end
