// Persistence of Vision Ray Tracer Scene Description File
// File: TrackRamp.inc
// Vers: 3.1
// Desc: Up and down bridges
// Date: 3/14/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/



#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

#declare RampOutlineNumPoints = 20;
#declare RampOutline = array[RampOutlineNumPoints]
{< 0.0000,0.0000>  < 1.4500,0.0000>  < 2.9500,0.1900>  < 4.4600,0.5900>  < 5.8300,0.9900>
 <16.3000,5.1000>  <17.7100,5.5700>  <18.5900,5.7500>  <19.8900,5.9000>  <21.3000,5.9000>
 <21.3000,7.0900>  <20.0800,7.0900>  <18.7400,6.9700>  <17.4900,6.7100>  <16.1900,6.2500>  
 < 5.3300,2.0900>  < 4.0000,1.6800>  < 2.7400,1.3700>  < 1.4500,1.2200>  < 0.0400,1.2200>}

#declare RampTrackSubtractionNumPoints = 12;
#declare RampTrackSubtraction = array[RampTrackSubtractionNumPoints]
{ <22.3000,7.0900>  <20.0800,7.0900>  <18.7400,6.9700>  <17.4900,6.7100>  <16.1900,6.2500>  
  < 5.3300,2.0900>  < 4.0000,1.6800>  < 2.7400,1.3700>  < 1.4500,1.2200>  <-1.0400,1.2200>
  <-1.0000,9.0000>  <22.3300,9.0000>}

#local BridgeLength = TrackUnitLength;
#local Count = 0;
#while (Count < RampOutlineNumPoints)
	#declare RampOutline[Count] = RampOutline[Count] * <BridgeLength/21.3,(TrackRiserHeight+TrackCrossSectionSize.y)/7.09>;
	#local Count = Count + 1;
#end

#local Count = 0;
#while (Count < RampTrackSubtractionNumPoints)
	#declare RampTrackSubtraction[Count] = RampTrackSubtraction[Count] * <BridgeLength/21.3,(TrackRiserHeight+TrackCrossSectionSize.y)/7.09>;
	#local Count = Count + 1;
#end
												
#declare RampBlockUpTrack = prism {
	linear_sweep
	linear_spline
	0,
	-TrackCrossSectionSize.x, // width of the cross section
	RampOutlineNumPoints+1, // Last points to close the curve.
	#local Count = 0;
	#while (Count < RampOutlineNumPoints)
		RampOutline[Count],
		#local Count = Count+1;
	#end
	RampOutline[0]
	rotate -90*x

	//translate <0,0,-TrackCrossSectionCenter.x>
}	
#declare RampTrackSubtractionTrack = prism {
	linear_sweep
	linear_spline
	0,
	-TrackGrooveSize.x, // Width of the cross section
	RampTrackSubtractionNumPoints+1, // Last points to close the curve.
	#local Count = 0;
	#while (Count < RampTrackSubtractionNumPoints)
		RampTrackSubtraction[Count] - <TrackGrooveSize.y,TrackGrooveSize.y>,
		#local Count = Count+1;
	#end
	RampTrackSubtraction[0] - <TrackGrooveSize.y,TrackGrooveSize.y>
	rotate -90*x
	//translate <0,0,-TrackCrossSectionCenter.x>
}	

#declare RampUpTrackConnectsPosition = array[2] {<0,0,0>,<BridgeLength,TrackRiserHeight,0>}
#declare RampUpTrackNumConnects = 2;
#declare RampUpTrackConnectsAngle = array[2] {<0,180,0>, <0,0,0>}
#declare RampUpTrackConnectsGender = array[2] {0,1}
#declare RampUpBlock = difference{
	object {
		RampBlockUpTrack
	}
	object {
		RampTrackSubtractionTrack
		translate <0,0,TrackGroovePosition[0].x>
	}
	object {
		RampTrackSubtractionTrack
		translate <0,0,TrackGroovePosition[1].x>
	}
	translate <0,0,-TrackCrossSectionSize.x/2>
}
#declare RampUpTrack = union {
	object {
		TrackMaleConnect1
		translate RampUpTrackConnectsPosition[1]
	}
	difference {
		object {RampUpBlock}
		object {
			TrackFemaleConnect1
			scale <1,2,1>
			translate <0,-0.25,0>
		}
	}
}



#declare RampDownTrackConnectsPosition = array[2] {<0,0,0>,<BridgeLength,-TrackRiserHeight,0>}
#declare RampDownTrackNumConnects = 2;
#declare RampDownTrackConnectsAngle = array[2] {<0,180,0>, <0,0,0>}
#declare RampDownTrackConnectsGender = array[2] {0,1}
#declare RampDownTrack = union {
	object {
		TrackMaleConnect1
		translate RampDownTrackConnectsPosition[1]
	}
	difference {
		object {
			RampUpBlock
			rotate y*180
			translate RampDownTrackConnectsPosition[1]
		}
		object {
			TrackFemaleConnect1
			scale <1,2,1>
			translate <0,-0.25,0>
		}
	}
}


#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"

	camera
	{
	  location  <0,3,-3>
	  //right <16,0,0>
	  //up <12,0,0>
	  look_at   <0,0,0>
	}
	#include "TrackMiniStraight.inc"
	object {MiniStraightTrack
		texture {TrackWood_T}
		translate -TrackMiniUnitLength*x
	}
	object {RampUpTrack
		texture {TrackWood_T}
	}

	//object {RampTrackSubtractionTrack pigment {Red}}
/*
	camera
	{
	  location  RampOutline[12] + <0, .5, -1>
	  //right <16,0,0>
	  //up <12,0,0>
	  look_at   RampOutline[12]
	}
*/
	background{Green}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color rgb 0.75  // light's color
	  translate <0, 15, -10>
	}
	light_source
	{
	  0*x // light's position (translated below)
	  color rgb 0.75  // light's color
	  translate <0, 15, 0>
	}
	#local Count = 0;
	#while (Count < RampOutlineNumPoints)
		sphere {
			RampOutline[Count]/2.54,
			0.05
			pigment {Red}
		}
		#local Count = Count + 1;
	#end
#end
