// Persistence of Vision Ray Tracer Scene Description File
// File: TrackScene2.inc
// Vers: 3.1
// Desc: Separated out the track and train part of the scene.
// Date: 4/29/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights and objects
	#local Render = 1;
#else
	#local Render = 0;
#end



#include "TrackLayoutSamples.inc"
#declare TrackNumSegments = MondoTrackNumSegments;
#declare Track = MondoTrack

union {
	// make the track
	#include "TrackBuilder.inc"

	// Put out all the trains
	#include "TrainEngine2.inc"
	#include "TrainCars.inc"
	#declare LightBlue_C = 	color rgb <0.2,0.8,1.0>;
	#declare DeepBlue_C = 	color rgb <0.1,0.1,0.5>;
	#declare Blue_C = 		color rgb <0.0,0.1,0.8>;
	#declare Red_C = 		color rgb <1.0,0.1,0.1>;
	#declare Yellow_C = 	color rgb <0.95,0.95,0.1>;
	#declare Green_C = 		color rgb <0.1,0.55,0.1>;
	
	#declare LightBlueBoxCar =	MakeTrainBoxCar(LightBlue_C)
	#declare DeepBlueBoxCar =	MakeTrainBoxCar(DeepBlue_C)
	#declare GreenBoxCar =		MakeTrainBoxCar(Green_C)
	#declare RedBoxCar =		MakeTrainBoxCar(Red_C)
	#declare YellowBoxCar =		MakeTrainBoxCar(Yellow_C)
	
	#declare LightBlueTankerCar =	MakeTrainTankerCar(LightBlue_C)
	#declare BlueTankerCar =		MakeTrainTankerCar(Blue_C)
	#declare GreenTankerCar =		MakeTrainTankerCar(Green_C)
	#declare RedTankerCar =			MakeTrainTankerCar(Red_C)
	#declare YellowTankerCar =		MakeTrainTankerCar(Yellow_C)

	#declare BlueTippyCar =		MakeTrainTippyCar(Blue_C)
	#declare GreenTippyCar =	MakeTrainTippyCar(Green_C)
	#declare RedTippyCar =		MakeTrainTippyCar(Red_C)
	#declare YellowTippyCar =	MakeTrainTippyCar(Yellow_C)
	
	object {
		RedBoxCar
		rotate 95*x
		rotate 70*y
		translate <-1,TrainCarBaseSize.z/2+0.25,-8>
	}
	
	object {
		BlueTankerCar
		rotate 110*x
		rotate -90*y
		translate <-3,TrainCarBaseSize.z/2+0.375,-5>
	}

	/*#declare RedTankerCar = MakeTrainTankerCar(Red_C)
	#declare YellowTankerCar = MakeTrainTankerCar(Yellow_C)
	
	#declare Object5 = MakeTrainBoxCar(>)
	#declare Object6 = MakeTrainBoxCar(color rgb <1.1,1.1,0.5>)
	#declare Object7 = MakeTrainBoxCar(color rgb <1.1,1.1,1.5>)
*/
	// Name Train (Center Foreground)
	#declare ATrainCars = array[7] {GreenTankerCar,LightBlueBoxCar,GreenTippyCar,TrainNameBoxCar,TrainTitleBoxCar,YellowTankerCar,TrainEngine2}
	#declare ATrainCarLengths = array[7] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[4] {2,2,2,0}
	#declare TrackUnderTrainSize = array[4] {TrackUnitLength, TrackShortUnitLength,TrackShortUnitLength,TrackUnitLength}
	#include "TrainBuilder.inc" 
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[4]
		translate FinalTrackConnectPoints[4]
	}
	
	// Front Weave grid
	#declare ATrainCars = array[6] {YellowTippyCar,LightBlueBoxCar,YellowTankerCar,GreenTippyCar,RedTankerCar,TrainEngine2}
	#declare ATrainCarLengths = array[6] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[4] {0,0,0,0}
	#declare TrackUnderTrainSize = array[4] {TrackUnitLength, TrackShortUnitLength,TrackShortUnitLength,TrackUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[0]
		translate FinalTrackConnectPoints[0]
	}
	// Far Right, Going into City
	#declare ATrainCars = array[14] {LightBlueBoxCar,RedBoxCar,GreenBoxCar,YellowTippyCar,RedTankerCar,GreenTippyCar,RedTippyCar,DeepBlueBoxCar,YellowTankerCar,YellowBoxCar,GreenTankerCar,RedTankerCar,YellowTippyCar,TrainEngine2}
	#declare ATrainCarLengths = array[14] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x, TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[6] {0,2,1,0,0,0}
	#declare TrackUnderTrainSize = array[6] {TrackUnitLength,TrackUnitLength,TrackUnitLength,TrackUnitLength,TrackUnitLength,TrackUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[37]
		translate FinalTrackConnectPoints[37]
	}
	// Far Right, Going into City
	#declare ATrainCars = array[1] {BlueTankerCar}
	#declare ATrainCarLengths = array[1] {TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[2] {0,0}
	#declare TrackUnderTrainSize = array[2] {TrackUnitLength,TrackUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[82]
		translate FinalTrackConnectPoints[82]
	}
	// Bridge in front of city
	#declare ATrainCars = array[3] {RedTankerCar,GreenTippyCar,TrainEngine2}
	#declare ATrainCarLengths = array[3] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[2] {0,0}
	#declare TrackUnderTrainSize = array[2] {TrackUnitLength,TrackUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[45]
		translate FinalTrackConnectPoints[45]
	}
	// Far Left Upper Bridge
	#declare ATrainCars = array[6] {YellowTankerCar,GreenTippyCar,RedBoxCar,LightBlueBoxCar,RedTankerCar,YellowTankerCar}
	#declare ATrainCarLengths = array[6] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[4] {2,0,0,0}
	#declare TrackUnderTrainSize = array[4] {TrackUnitLength,TrackUnitLength,TrackUnitLength,TrackUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[59]
		translate FinalTrackConnectPoints[59]
	}
	// Left of weave grid
	#declare ATrainCars = array[6] {DeepBlueBoxCar,RedTankerCar,BlueTippyCar,YellowTankerCar,GreenBoxCar,RedTippyCar}
	#declare ATrainCarLengths = array[6] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[4] {0,2,2,0}
	#declare TrackUnderTrainSize = array[4] {TrackShortUnitLength,TrackShortUnitLength,TrackShortUnitLength,TrackShortUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[129]
		translate FinalTrackConnectPoints[129]
	}

	// Far Left lower bridge
	#declare ATrainCars = array[6] {GreenBoxCar,RedBoxCar,YellowBoxCar,RedTippyCar,GreenTankerCar,TrainEngine2}
	#declare ATrainCarLengths = array[6] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[3] {0,0,0}
	#declare TrackUnderTrainSize = array[3] {TrackUnitLength,TrackUnitLength,TrackUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[150]
		translate FinalTrackConnectPoints[150]
	}
	// Weave Grid bridge...
	#declare ATrainCars = array[1] {RedTippyCar}
	#declare ATrainCarLengths = array[1] {TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[2] {0,0}
	#declare TrackUnderTrainSize = array[2] {TrackShortUnitLength,TrackShortUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[181]
		translate FinalTrackConnectPoints[181]
	}
	// Left Near ground twisty curve
	#declare ATrainCars = array[1] {RedTippyCar}
	#declare ATrainCarLengths = array[1] {TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[2] {2,2}
	#declare TrackUnderTrainSize = array[2] {TrackShortUnitLength,TrackShortUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[11]
		translate FinalTrackConnectPoints[11]
	}
	// Left Near ground twisty curve
	#declare ATrainCars = array[3] {GreenBoxCar,RedTankerCar,YellowTippyCar}
	#declare ATrainCarLengths = array[3] {TrainCarBaseSize.x,TrainCarBaseSize.x,TrainCarBaseSize.x}
	#declare TrackUnderTrainType = array[3] {2,1,2}
	#declare TrackUnderTrainSize = array[3] {TrackShortUnitLength,TrackShortUnitLength,TrackShortUnitLength}
	union {
		PlaceTrainCarsOnTrack(ATrainCars,ATrainCarLengths,TrackUnderTrainType,TrackUnderTrainSize)
		rotate FinalTrackConnectAngles[14]
		translate FinalTrackConnectPoints[14]
	}
	
	#if (Render = 1)
		translate -10*x
	#end
}


#if (Render = 1)
	#declare View = 0;
	#switch (View)
		#case (0)
			camera
			{
			  location  <0.0 , 100.0 , 0.0>
			  look_at   <0.0 , 0.0 , 0.0>
			  rotate 180*y
			  orthographic
			}
			light_source
			{
				<0,100,0>
				color White
			}
			#break
			#case(3)
			camera
			{
				 location <-6.5,TrackRiserHeight+2,-23.5>
			 	 look_at <-4.5,TrackRiserHeight,-21.5>
			}
			#break
		#case (1)
			camera
			{
				up y
				right 6/4*x
		  		location  <-30.0 , 10.0 , -30.0>
		  		look_at   <0.0 , 0.0 , 0.0>
			}
			#break
		#case (2)
			camera
			{
		  		location  <0.0 , 10.0 ,-100.0>
		  		look_at   <0.0 , 0.0 ,100.0>
			}
			#break	
	#end
	

	global_settings { ambient_light <1,1,1>*1}


	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.65 // light's color
	  translate <-50, 40, -10>
	}
	
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color <1,1,1>*.65 // light's color
	  translate <0, 40, -50>
	}

	background {rgb <1,1,1>}
	
	plane {y,0 pigment {color rgb <0.1,0.1,0.1>}}

#end


