// Persistence of Vision Ray Tracer Scene Description File
// File: TrackShortCurve.inc
// Vers: 3.1
// Desc: Short 45deg arc track
// Date: 3/9/00
// Auth: Katherine Smith
// URL: http://www.bigfoot.com/~kathsth/
// EMail: kathsth@bigfoot.com
/*
	Copyright (C) 2000  Katherine Smith

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#ifndef (Render)
	// We're not being included, but rendered on our own,
	// so we need to create our own camera and lights
	#local Render = 1;
#else
	#local Render = 0;
#end


#include "TrackCrossSection.inc"
#include "TrackConnects.inc"

	#local Radius = TrackShortCurveRadius;
	#local InnerRadius = Radius - TrackCrossSectionSize.x/2;
	#local OuterRadius = InnerRadius + TrackCrossSectionSize.x;
	
#declare ShortCurveBlock = intersection {
	lathe{
		linear_spline
		TrackCrossSection2NumPoints+1,
		#local Count = 0;
		#while (Count < TrackCrossSection2NumPoints)
			TrackCrossSection2[Count] + <InnerRadius,0>,
			#local Count = Count+1;
		#end
		TrackCrossSection2[0] + <InnerRadius,0>
	}
	box {
		<0,-.1,0>,
		<OuterRadius+1,TrackCrossSectionSize.y+.1,OuterRadius+1>
	}
	box {
		<0,-.1,0>,
		<OuterRadius+1,TrackCrossSectionSize.y+.1,OuterRadius+1>
		rotate y*45
	}
}	

#declare ShortCurveLTrackConnectsAngle = array[2] {<0,180,0>, <0,-45,0>}
#declare ShortCurveLTrackConnectsPosition = array[2] {<0,0,0>,Radius*<sin(radians(45)),0,1-cos(radians(45))>}
#declare ShortCurveLTrackNumConnects = 2;
#declare ShortCurveLTrackConnectsGender = array[2] {0,1}

#declare ShortCurveLTrack = union {
	object {
		TrackMaleConnect1
		rotate ShortCurveLTrackConnectsAngle[1]
		translate ShortCurveLTrackConnectsPosition[1]
	}
	difference {
		object {
			ShortCurveBlock
			rotate 90*y
			translate <0,0,Radius>
		}
		object {
			TrackFemaleConnect1
		}
	}
}	

#declare ShortCurveRTrackConnectsAngle = array[2] {<0,180,0>, <0,45,0>}
#declare ShortCurveRTrackConnectsPosition = array[2] {<0,0,0>,Radius*<sin(radians(45)),0,-(1-cos(radians(45)))>}
#declare ShortCurveRTrackNumConnects = 2;
#declare ShortCurveRTrackConnectsGender = array[2] {0,1}

#declare ShortCurveRTrack = object {
	ShortCurveLTrack
	rotate 180*x
	translate TrackCrossSectionSize.y*y
}

#if (Render = 1)
	#include "colors.inc"
	#include "TrackTextures.inc"
	object {
		ShortCurveLTrack
		texture {TrackWood_T}
	}
	object {
		ShortCurveRTrack
		texture {TrackWood_T}
	}
	camera
	{
	  location  <3.0 , 1.0 ,-2.5>
	  look_at   <3.0 , 0.0 , 0.0>
	}
	background{White}
	// create a regular point light source
	light_source
	{
	  0*x // light's position (translated below)
	  color 1.5  // light's color
	  translate <-10, 30, -20>
	}
#end

